/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.InvalidDateFormatException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SMPPDate
implements Serializable {
    static final long serialVersionUID = -2404447252053261604L;
    private static final String FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}{6,number,0}{7,number,00}{8}";
    private static final String SHORT_FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}";
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int tenth;
    private char sign = (char)43;
    private int hashCode;
    private TimeZone savedTimeZone;

    public SMPPDate() {
        this.hashCode = this.toString().hashCode();
        this.savedTimeZone = TimeZone.getDefault();
    }

    public SMPPDate(Date d) {
        if (d == null) {
            throw new NullPointerException("Cannot use a null Date");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        this.setFields(cal);
    }

    public SMPPDate(Calendar cal) {
        if (cal == null) {
            throw new NullPointerException("Cannot use a null Calendar");
        }
        this.setFields(cal);
    }

    public SMPPDate(int years, int months, int days, int hours, int minutes, int seconds) {
        this.year = years;
        this.month = months;
        this.day = days;
        this.hour = hours;
        this.minute = minutes;
        this.second = seconds;
        this.tenth = 0;
        this.sign = (char)82;
        this.savedTimeZone = null;
        this.hashCode = this.toString().hashCode();
    }

    private void setFields(Calendar calendar) {
        this.year = calendar.get(1) - 2000;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.tenth = calendar.get(14) / 100;
        this.savedTimeZone = calendar.getTimeZone();
        this.sign = (char)43;
        int off = this.savedTimeZone.getOffset(System.currentTimeMillis());
        if (off < 0) {
            this.sign = (char)45;
        }
        this.hashCode = this.toString().hashCode();
    }

    private void initCalendar(Calendar calendar) {
        if (this.savedTimeZone != null) {
            calendar.setTimeZone(this.savedTimeZone);
        }
        calendar.set(1, this.year + 2000);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.tenth * 100);
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        this.initCalendar(cal);
        return cal;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getTenth() {
        return this.tenth;
    }

    public int getUtcOffset() {
        int offset = 0;
        if (this.savedTimeZone != null) {
            offset = this.savedTimeZone.getOffset(System.currentTimeMillis());
        }
        return Math.abs(offset) / 900000;
    }

    public TimeZone getTimeZone() {
        return this.savedTimeZone;
    }

    public char getSign() {
        return this.sign;
    }

    public boolean isRelative() {
        return this.sign == 'R';
    }

    public boolean hasTimezone() {
        return this.sign == '+' || this.sign == '-';
    }

    public boolean equals(Object obj) {
        if (obj instanceof SMPPDate) {
            SMPPDate d = (SMPPDate)obj;
            int diff = this.year - d.year + (this.month - d.month) + (this.day - d.day) + (this.hour - d.hour) + (this.minute - d.minute) + (this.second - d.second) + (this.tenth - d.tenth) + (this.sign - d.sign);
            boolean sameTz = this.savedTimeZone == null ? d.savedTimeZone == null : this.savedTimeZone.equals(d.savedTimeZone);
            return diff == 0 && sameTz && this.sign == d.sign;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static SMPPDate parseSMPPDate(String s) throws InvalidDateFormatException {
        SMPPDate d = new SMPPDate();
        if (s == null || s.length() == 0) {
            return d;
        }
        if (s.length() != 16 && s.length() != 12) {
            throw new InvalidDateFormatException("Date string is incorrect length", s);
        }
        boolean longForm = s.length() == 16;
        try {
            d.year = Integer.parseInt(s.substring(0, 2));
            d.month = Integer.parseInt(s.substring(2, 4));
            d.day = Integer.parseInt(s.substring(4, 6));
            d.hour = Integer.parseInt(s.substring(6, 8));
            d.minute = Integer.parseInt(s.substring(8, 10));
            d.second = Integer.parseInt(s.substring(10, 12));
            if (longForm) {
                d.sign = s.charAt(15);
                if (d.sign != 'R') {
                    d.tenth = Integer.parseInt(s.substring(12, 13));
                    int utcOffset = Integer.parseInt(s.substring(13, 15));
                    int rawOffset = utcOffset * 900000;
                    if (d.sign == '-') {
                        rawOffset = -rawOffset;
                    }
                    int hours = utcOffset / 4;
                    int minutes = (utcOffset - hours * 4) * 15;
                    Object[] args = new Object[]{new Character(d.sign), hours, minutes};
                    String id = MessageFormat.format("UTC{0}{1,number,00}:{1,number,00}", args);
                    d.savedTimeZone = new SimpleTimeZone(rawOffset, id);
                } else {
                    d.savedTimeZone = null;
                }
            } else {
                d.sign = '\u0000';
                d.savedTimeZone = null;
            }
            d.hashCode = d.toString().hashCode();
        }
        catch (NumberFormatException x) {
            throw new InvalidDateFormatException("Invalid SMPP date string", s);
        }
        return d;
    }

    public String toString() {
        int utcOffset = this.getUtcOffset();
        Object[] args = new Object[]{new Integer(this.year), new Integer(this.month), new Integer(this.day), new Integer(this.hour), new Integer(this.minute), new Integer(this.second), new Integer(this.tenth), new Integer(utcOffset), new Character(this.sign)};
        String format = FORMAT;
        if (this.sign == '\u0000') {
            format = SHORT_FORMAT;
        }
        return MessageFormat.format(format, args);
    }
}

