/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class SMPPIO {
    private static final String US_ASCII = "US-ASCII";

    private SMPPIO() {
    }

    public static int readInt(InputStream in, int len) throws IOException {
        int r;
        byte[] b = new byte[len];
        int p = 0;
        for (int loop = 0; loop < len - p && (r = in.read(b, p, len - p)) != -1; ++loop) {
            p += r;
        }
        return SMPPIO.bytesToInt(b, 0, len);
    }

    public static String readCString(InputStream in) throws IOException {
        StringBuffer s = new StringBuffer();
        int b = in.read();
        while (b != 0) {
            if (b == -1) {
                throw new IOException("End of Input Stream before NULL byte");
            }
            s.append((char)b);
            b = in.read();
        }
        if (s.length() == 0) {
            return null;
        }
        return s.toString();
    }

    public static String readCString(byte[] b, int offset) {
        String s;
        try {
            int p = offset;
            while (b[p] != 0) {
                ++p;
            }
            s = p > offset ? new String(b, offset, p - offset, US_ASCII) : "";
        }
        catch (UnsupportedEncodingException x) {
            s = "";
        }
        return s;
    }

    public static String readString(InputStream in, int len) throws IOException {
        String s = null;
        if (len >= 1) {
            int r;
            byte[] b = new byte[len];
            StringBuffer buf = new StringBuffer();
            for (int l = 0; l < len; l += r) {
                r = in.read(b, 0, len - l);
                if (r == -1) {
                    throw new IOException("EOS before NUL byte read.");
                }
                buf.append(new String(b, 0, r, US_ASCII));
            }
            if (buf.length() > 0) {
                s = buf.toString();
            }
        }
        return s;
    }

    public static String readString(byte[] b, int offset, int len) {
        String s = "";
        try {
            if (len > 0) {
                s = new String(b, offset, len - offset, US_ASCII);
            }
        }
        catch (UnsupportedEncodingException x) {
            // empty catch block
        }
        return s;
    }

    public static byte[] intToBytes(int num, int len) {
        return SMPPIO.intToBytes(num, len, null, 0);
    }

    public static byte[] intToBytes(int num, int len, byte[] array, int offset) {
        byte[] b = array;
        if (array == null) {
            b = new byte[len];
            offset = 0;
        }
        int sw = (len - 1) * 8;
        int mask = 255 << sw;
        for (int l = 0; l < len; ++l) {
            b[offset + l] = (byte)((num & mask) >>> sw);
            sw -= 8;
            mask >>>= 8;
        }
        return b;
    }

    public static byte[] longToBytes(long num, int len) {
        return SMPPIO.longToBytes(num, len, null, 0);
    }

    public static byte[] longToBytes(long num, int len, byte[] b, int offset) {
        if (b == null) {
            b = new byte[len];
            offset = 0;
        }
        long sw = (len - 1) * 8;
        long mask = 255L << (int)sw;
        for (int l = 0; l < len; ++l) {
            b[offset + l] = (byte)((num & mask) >>> (int)sw);
            sw -= 8L;
            mask >>>= 8;
        }
        return b;
    }

    public static int bytesToInt(byte[] b, int offset, int size) {
        int num = 0;
        int sw = 8 * (size - 1);
        for (int loop = 0; loop < size; ++loop) {
            num |= (b[offset + loop] & 0xFF) << sw;
            sw -= 8;
        }
        return num;
    }

    public static long bytesToLong(byte[] b, int offset, int size) {
        long num = 0L;
        long sw = 8L * ((long)size - 1L);
        for (int loop = 0; loop < size; ++loop) {
            num |= ((long)b[offset + loop] & 0xFFL) << (int)sw;
            sw -= 8L;
        }
        return num;
    }

    public static void writeInt(int x, int len, OutputStream out) throws IOException {
        out.write(SMPPIO.intToBytes(x, len));
    }

    public static void writeCString(String s, OutputStream out) throws IOException {
        SMPPIO.writeString(s, out);
        out.write(0);
    }

    public static void writeString(String s, int len, OutputStream out) throws IOException {
        if (s == null) {
            return;
        }
        if (len > s.length()) {
            SMPPIO.writeString(s, out);
        } else {
            SMPPIO.writeString(s.substring(0, len), out);
        }
    }

    public static void writeString(String s, OutputStream out) throws IOException {
        if (s == null) {
            return;
        }
        out.write(s.getBytes());
    }
}

