/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.WindowsFailedSnapshotTracker;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.security.ThreadAwareSecurityManager;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.NativeTransportService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AchillesCassandraDaemon
extends CassandraDaemon {
    private static final Logger logger = LoggerFactory.getLogger(AchillesCassandraDaemon.class);
    private NativeTransportService nativeTransportService;

    protected void setup() {
        if (FBUtilities.isWindows) {
            WindowsFailedSnapshotTracker.deleteOldSnapshots();
        }
        ThreadAwareSecurityManager.install();
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            StorageMetrics.exceptions.inc();
            logger.error("Exception in thread {}", (Object)t, (Object)e);
            Tracing.trace((String)"Exception in thread {}", (Object)t, (Object)e);
            for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                JVMStabilityInspector.inspectThrowable((Throwable)e2);
                if (e2 instanceof FSError) {
                    if (e2 != e) {
                        logger.error("Exception in thread {}", (Object)t, (Object)e2);
                    }
                    FileUtils.handleFSError((FSError)((FSError)e2));
                }
                if (!(e2 instanceof CorruptSSTableException)) continue;
                if (e2 != e) {
                    logger.error("Exception in thread " + t, e2);
                }
                FileUtils.handleCorruptSSTable((CorruptSSTableException)((CorruptSSTableException)e2));
            }
        });
        StorageService.instance.populateTokenMetadata();
        Schema.instance.loadFromDisk();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (keyspaceName.equals("system")) continue;
            for (CFMetaData cfm : Schema.instance.getTablesAndViews(keyspaceName)) {
                try {
                    ColumnFamilyStore.scrubDataDirectories((CFMetaData)cfm);
                }
                catch (StartupException e2) {
                    this.exitOrFail(e2.returnCode, e2.getMessage(), e2.getCause());
                }
            }
        }
        Keyspace.setInitialized();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace {}", (Object)keyspaceName);
            }
            for (ColumnFamilyStore cfs : Keyspace.open((String)keyspaceName).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        try {
            this.loadRowAndKeyCacheAsync().get();
        }
        catch (Throwable t2) {
            JVMStabilityInspector.inspectThrowable((Throwable)t2);
            logger.warn("Error loading key or row cache", t2);
        }
        try {
            CommitLog.instance.recoverSegmentsOnDisk();
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        StorageService.instance.populateTokenMetadata();
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    if (!store.getCompactionStrategyManager().shouldBeEnabled()) continue;
                    store.disableAutoCompaction();
                }
            }
        }
        SystemKeyspace.finishStartup();
        StorageService.instance.registerDaemon((CassandraDaemon)this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e4) {
            System.err.println(e4.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            this.exitOrFail(1, "Fatal configuration error", e4);
        }
        this.nativeTransportService = new NativeTransportService();
        this.completeSetup();
    }

    private void exitOrFail(int code, String message, Throwable cause) {
        logger.error(message, cause);
        System.exit(code);
    }

    private ListenableFuture<?> loadRowAndKeyCacheAsync() {
        ListenableFuture keyCacheLoad = CacheService.instance.keyCache.loadSavedAsync();
        ListenableFuture rowCacheLoad = CacheService.instance.rowCache.loadSavedAsync();
        ListenableFuture retval = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{keyCacheLoad, rowCacheLoad});
        return retval;
    }

    public void start() {
        this.startNativeTransport();
        StorageService.instance.setRpcReady(true);
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        if (this.nativeTransportService != null) {
            this.nativeTransportService.destroy();
        }
        StorageService.instance.setRpcReady(false);
        if (FBUtilities.isWindows) {
            System.exit(0);
        }
    }

    public void startNativeTransport() {
        if (this.nativeTransportService == null) {
            throw new IllegalStateException("setup() must be called first for CassandraDaemon");
        }
        this.nativeTransportService.start();
    }

    public void stopNativeTransport() {
        if (this.nativeTransportService != null) {
            this.nativeTransportService.stop();
        }
    }

    public boolean isNativeTransportRunning() {
        return this.nativeTransportService != null ? this.nativeTransportService.isRunning() : false;
    }
}

