/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.embedded.CassandraEmbeddedConfigParameters;
import info.archinnov.achilles.embedded.CassandraEmbeddedServer;
import info.archinnov.achilles.embedded.CassandraShutDownHook;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CassandraEmbeddedServerBuilder {
    private String listenAddress;
    private String rpcAddress;
    private String broadcastAddress = "";
    private String broadcastRpcAddress = "";
    private CassandraShutDownHook cassandraShutDownHook;
    private String dataFileFolder;
    private String commitLogFolder;
    private String savedCachesFolder;
    private String hintsFolder;
    private String cdcRawFolder;
    private boolean cleanDataFiles = true;
    private boolean cleanConfigFile = true;
    private int concurrentReads;
    private int concurrentWrites;
    private int cqlPort;
    private ProtocolVersion protocolVersion;
    private int jmxPort;
    private int thriftPort;
    private int storagePort;
    private int storageSSLPort;
    private String clusterName;
    private String keyspaceName;
    private boolean durableWrite = false;
    private boolean useUnsafeCassandraDaemon = false;
    private List<String> scriptLocations = new ArrayList<String>();
    private Map<String, Map<String, Object>> scriptTemplates = new HashMap<String, Map<String, Object>>();
    private TypedMap cassandraParams = new TypedMap();

    private CassandraEmbeddedServerBuilder() {
    }

    public static CassandraEmbeddedServerBuilder builder() {
        return new CassandraEmbeddedServerBuilder();
    }

    public CassandraEmbeddedServerBuilder withListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
        return this;
    }

    public CassandraEmbeddedServerBuilder withRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
        return this;
    }

    public CassandraEmbeddedServerBuilder withBroadcastAddress(String broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
        return this;
    }

    public CassandraEmbeddedServerBuilder withBroadcastRpcAddress(String broadcastRpcAddress) {
        this.broadcastRpcAddress = broadcastRpcAddress;
        return this;
    }

    public CassandraEmbeddedServerBuilder withShutdownHook(CassandraShutDownHook cassandraShutDownHook) {
        this.cassandraShutDownHook = cassandraShutDownHook;
        return this;
    }

    public CassandraEmbeddedServerBuilder withDataFolder(String dataFolder) {
        this.dataFileFolder = dataFolder;
        return this;
    }

    public CassandraEmbeddedServerBuilder withCommitLogFolder(String commitLogFolder) {
        this.commitLogFolder = commitLogFolder;
        return this;
    }

    public CassandraEmbeddedServerBuilder withSavedCachesFolder(String savedCachesFolder) {
        this.savedCachesFolder = savedCachesFolder;
        return this;
    }

    public CassandraEmbeddedServerBuilder withHintsFolder(String hintsFolder) {
        this.hintsFolder = hintsFolder;
        return this;
    }

    public CassandraEmbeddedServerBuilder withCdcRawFolder(String cdcRawFolder) {
        this.cdcRawFolder = cdcRawFolder;
        return this;
    }

    public CassandraEmbeddedServerBuilder cleanDataFilesAtStartup(boolean cleanDataFilesAtStartup) {
        this.cleanDataFiles = cleanDataFilesAtStartup;
        return this;
    }

    public CassandraEmbeddedServerBuilder withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public CassandraEmbeddedServerBuilder withKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        return this;
    }

    public CassandraEmbeddedServerBuilder withCQLPort(int clqPort) {
        this.cqlPort = clqPort;
        return this;
    }

    public CassandraEmbeddedServerBuilder withConnectionProtocol(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public CassandraEmbeddedServerBuilder withJMXPort(int jmxPort) {
        this.jmxPort = jmxPort;
        return this;
    }

    public CassandraEmbeddedServerBuilder withThriftPort(int thriftPort) {
        this.thriftPort = thriftPort;
        return this;
    }

    public CassandraEmbeddedServerBuilder withStoragePort(int storagePort) {
        this.storagePort = storagePort;
        return this;
    }

    public CassandraEmbeddedServerBuilder withStorageSSLPort(int storageSSLPort) {
        this.storageSSLPort = storageSSLPort;
        return this;
    }

    public CassandraEmbeddedServerBuilder withConcurrentReads(int concurrentReads) {
        this.concurrentReads = concurrentReads;
        return this;
    }

    public CassandraEmbeddedServerBuilder withConcurrentWrites(int concurrentWrites) {
        this.concurrentWrites = concurrentWrites;
        return this;
    }

    public CassandraEmbeddedServerBuilder withDurableWrite(boolean durableWrite) {
        this.durableWrite = durableWrite;
        return this;
    }

    public CassandraEmbeddedServerBuilder withScript(String scriptLocation) {
        Validator.validateNotBlank((String)scriptLocation, (String)"The script location should not be blank while executing CassandraEmbeddedServerBuilder.withScript()", (Object[])new Object[0]);
        this.scriptLocations.add(scriptLocation.trim());
        return this;
    }

    public CassandraEmbeddedServerBuilder withScriptTemplate(String scriptTemplateLocation, Map<String, Object> values) {
        Validator.validateNotBlank((String)scriptTemplateLocation, (String)"The script template should not be blank while executing CassandraEmbeddedServerBuilder.withScriptTemplate()", (Object[])new Object[0]);
        Validator.validateNotEmpty(values, (String)"The template values should not be empty while executing CassandraEmbeddedServerBuilder.withScriptTemplate()", (Object[])new Object[0]);
        this.scriptTemplates.put(scriptTemplateLocation.trim(), values);
        return this;
    }

    public CassandraEmbeddedServerBuilder withParams(TypedMap cassandraParams) {
        this.cassandraParams.putAll((Map)cassandraParams);
        return this;
    }

    public CassandraEmbeddedServerBuilder useUnsafeCassandraDeamon() {
        this.useUnsafeCassandraDaemon = true;
        return this;
    }

    public CassandraEmbeddedServerBuilder useUnsafeCassandraDeamon(boolean useUnsafeCassandraDaemon) {
        this.useUnsafeCassandraDaemon = useUnsafeCassandraDaemon;
        return this;
    }

    public Cluster buildNativeCluster() {
        CassandraEmbeddedServer embeddedServer = new CassandraEmbeddedServer(this.buildConfigMap());
        return embeddedServer.getNativeCluster();
    }

    public Session buildNativeSession() {
        CassandraEmbeddedServer embeddedServer = new CassandraEmbeddedServer(this.buildConfigMap());
        return embeddedServer.getNativeSession();
    }

    public CassandraEmbeddedServer buildServer() {
        return new CassandraEmbeddedServer(this.buildConfigMap());
    }

    private TypedMap buildConfigMap() {
        this.cassandraParams.put((Object)"cleanCassandraDataFiles", (Object)this.cleanDataFiles);
        this.cassandraParams.put((Object)"cleanCassandraConfigFile", (Object)this.cleanConfigFile);
        if (StringUtils.isNotBlank((CharSequence)this.listenAddress)) {
            this.cassandraParams.put((Object)"listenAddress", (Object)this.listenAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)this.rpcAddress)) {
            this.cassandraParams.put((Object)"rpcAddress", (Object)this.rpcAddress);
        }
        if (this.broadcastAddress != null) {
            this.cassandraParams.put((Object)"broadcastAddress", (Object)this.broadcastAddress);
        }
        if (this.broadcastRpcAddress != null) {
            this.cassandraParams.put((Object)"broadcastRpcAddress", (Object)this.broadcastRpcAddress);
        }
        if (this.cassandraShutDownHook != null) {
            this.cassandraParams.put((Object)"shutdownHook", (Object)this.cassandraShutDownHook);
        }
        if (StringUtils.isNotBlank((CharSequence)this.dataFileFolder)) {
            this.cassandraParams.put((Object)"datafileFolder", (Object)this.dataFileFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.commitLogFolder)) {
            this.cassandraParams.put((Object)"commitlogFolder", (Object)this.commitLogFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.savedCachesFolder)) {
            this.cassandraParams.put((Object)"savedCachesFolder", (Object)this.savedCachesFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.hintsFolder)) {
            this.cassandraParams.put((Object)"hintsFolder", (Object)this.hintsFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cdcRawFolder)) {
            this.cassandraParams.put((Object)"cdcRawFolder", (Object)this.cdcRawFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clusterName)) {
            this.cassandraParams.put((Object)"clusterName", (Object)this.clusterName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyspaceName)) {
            this.cassandraParams.put((Object)"defaultKeyspaceName", (Object)this.keyspaceName);
        }
        if (this.cqlPort > 0) {
            this.cassandraParams.put((Object)"cqlPort", (Object)this.cqlPort);
        }
        if (this.jmxPort > 0) {
            this.cassandraParams.put((Object)"jmxPort", (Object)this.jmxPort);
        }
        if (this.thriftPort > 0) {
            this.cassandraParams.put((Object)"thriftPort", (Object)this.thriftPort);
        }
        if (this.storagePort > 0) {
            this.cassandraParams.put((Object)"storagePort", (Object)this.storagePort);
        }
        if (this.storageSSLPort > 0) {
            this.cassandraParams.put((Object)"storageSSLPort", (Object)this.storageSSLPort);
        }
        if (this.concurrentReads > 0) {
            this.cassandraParams.put((Object)"concurrentReads", (Object)this.concurrentReads);
        }
        if (this.concurrentWrites > 0) {
            this.cassandraParams.put((Object)"concurrentReads", (Object)this.concurrentWrites);
        }
        if (this.scriptLocations.size() > 0) {
            List existingScriptLocations = (List)this.cassandraParams.getTypedOr("scriptLocations", new ArrayList());
            existingScriptLocations.addAll(this.scriptLocations);
            this.cassandraParams.put((Object)"scriptLocations", (Object)existingScriptLocations);
        }
        if (this.scriptTemplates.size() > 0) {
            Map existingScriptTemplates = (Map)this.cassandraParams.getTypedOr("scriptTemplates", new HashMap());
            existingScriptTemplates.putAll(this.scriptTemplates);
            this.cassandraParams.put((Object)"scriptTemplates", (Object)existingScriptTemplates);
        }
        if (this.useUnsafeCassandraDaemon) {
            this.cassandraParams.put((Object)"useUnsafeCassandraDaemon", (Object)true);
        }
        this.cassandraParams.put((Object)"keyspaceDurableWrite", (Object)this.durableWrite);
        if (!this.cassandraParams.containsKey((Object)"connectionProtocolVersion") || this.cassandraParams.get((Object)"connectionProtocolVersion") == null) {
            this.cassandraParams.put((Object)"connectionProtocolVersion", (Object)Optional.ofNullable(this.protocolVersion).orElse(ProtocolVersion.V4));
        }
        TypedMap parameters = CassandraEmbeddedConfigParameters.mergeWithDefaultParameters(this.cassandraParams);
        return parameters;
    }
}

