/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(OrderedShutdownHook.class);
    private final Queue<Cluster> clusters = new ConcurrentLinkedQueue<Cluster>();
    private final Set<Session> sessions = new CopyOnWriteArraySet<Session>();

    void addCluster(Cluster cluster) {
        this.clusters.add(cluster);
    }

    void addSession(Session session) {
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
        }
    }

    void callShutDown() {
        this.sessions.forEach(session -> {
            log.info(String.format("Call shutdown on Session instance '%s'", session.toString()));
            session.close();
        });
        this.clusters.forEach(cluster -> {
            log.info(String.format("Call shutdown on Cluster instance '%s' of cluster name '%s'", cluster, cluster.getClusterName()));
            try {
                cluster.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

