/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.stream.IntStream;

public class PortFinder {
    private static int MAX_TRIES = 100;

    public static int randomAvailable() {
        return PortFinder.findAvailableBetween(1025, 65534);
    }

    public static int findFirstAvailableBetween(int startInclusive, int endExclusive) {
        return IntStream.range(startInclusive, endExclusive).filter(port -> PortFinder.isTcpPortAvailable("localhost", port)).filter(port -> PortFinder.isTcpPortAvailable("127.0.0.1", port)).findFirst().orElseThrow(() -> new IllegalStateException("no available port found between " + startInclusive + " and " + endExclusive + "."));
    }

    public static Integer findAvailableBetween(int start, int end) {
        int tested = PortFinder.randomBetween(start, end);
        for (int i = 0; i < MAX_TRIES; ++i) {
            if (PortFinder.isAvailable(tested)) {
                return tested;
            }
            tested = PortFinder.randomBetween(start, end);
        }
        throw new IllegalStateException("no available port found between " + start + " and " + end + " after " + MAX_TRIES + "tries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean isAvailable(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTcpPortAvailable(String hostname, int port) {
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(hostname), port), 1);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static int randomBetween(int start, int end) {
        return start + (int)(Math.random() * (double)(end - start + 1));
    }
}

