/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey3.InstrumentedResourceMethodApplicationListener;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.dropwizard.jersey.caching.CacheControlledResponseFeature;
import io.dropwizard.jersey.guava.OptionalMessageBodyWriter;
import io.dropwizard.jersey.guava.OptionalParamBinder;
import io.dropwizard.jersey.optional.OptionalDoubleMessageBodyWriter;
import io.dropwizard.jersey.optional.OptionalIntMessageBodyWriter;
import io.dropwizard.jersey.optional.OptionalLongMessageBodyWriter;
import io.dropwizard.jersey.params.AbstractParamConverterProvider;
import io.dropwizard.jersey.sessions.SessionFactoryProvider;
import io.dropwizard.jersey.validation.FuzzyEnumParamConverterProvider;
import io.dropwizard.util.JavaVersion;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final TypeResolver TYPE_RESOLVER = new TypeResolver();
    private static final Pattern PATH_DIRTY_SLASHES = Pattern.compile("\\s*/\\s*/+\\s*");
    private String urlPattern = "/*";
    private String contextPath = "/";
    private final ComponentLoggingListener loggingListener = new ComponentLoggingListener(this);

    public DropwizardResourceConfig() {
        this(null);
    }

    public DropwizardResourceConfig(@Nullable MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        this.property("jersey.config.server.wadl.disableWadl", Boolean.TRUE);
        this.register(this.loggingListener);
        this.register((Object)new MetricRegistryBinder(metricRegistry));
        this.register(new InstrumentedResourceMethodApplicationListener(metricRegistry, Clock.defaultClock(), true));
        this.register(CacheControlledResponseFeature.class);
        this.register(OptionalMessageBodyWriter.class);
        this.register((Object)new OptionalParamBinder());
        this.register(io.dropwizard.jersey.optional.OptionalMessageBodyWriter.class);
        this.register(OptionalDoubleMessageBodyWriter.class);
        this.register(OptionalIntMessageBodyWriter.class);
        this.register(OptionalLongMessageBodyWriter.class);
        this.register(AbstractParamConverterProvider.class);
        this.register(new FuzzyEnumParamConverterProvider());
        this.register((Object)new SessionFactoryProvider.Binder());
    }

    public static DropwizardResourceConfig forTesting() {
        return DropwizardResourceConfig.forTesting(null);
    }

    public static DropwizardResourceConfig forTesting(@Nullable MetricRegistry metricRegistry) {
        DropwizardResourceConfig config = new DropwizardResourceConfig(metricRegistry);
        config.property("jersey.config.test.container.port", "0");
        return config;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getEndpointsInfo() {
        return this.loggingListener.getEndpointsInfo();
    }

    Set<Class<?>> allClasses() {
        HashSet allClasses = new HashSet(this.getClasses());
        for (Object singleton : this.getSingletons()) {
            allClasses.add(singleton.getClass());
        }
        return allClasses;
    }

    public ResourceConfig register(Object component) {
        Object object = Objects.requireNonNull(component);
        Class<?> clazz = object.getClass();
        if (component instanceof Class) {
            return super.register((Class)component);
        }
        if (Providers.isProvider(clazz) || Binder.class.isAssignableFrom(clazz)) {
            return super.register(object);
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new LoaderClassPath(((Object)((Object)this)).getClass().getClassLoader()));
            CtClass cc = pool.makeClass(SpecificBinder.class.getName() + UUID.randomUUID());
            cc.setSuperclass(pool.get(SpecificBinder.class.getName()));
            Object binderProxy = JavaVersion.isJava8() ? cc.toClass().getConstructor(Object.class, Class.class).newInstance(object, clazz) : cc.toClass(SpecificBinder.class).getConstructor(Object.class, Class.class).newInstance(object, clazz);
            super.register(binderProxy);
            return super.register(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String cleanUpPath(String path) {
        return PATH_DIRTY_SLASHES.matcher(path).replaceAll("/").trim();
    }

    static final class MetricRegistryBinder
    extends AbstractBinder {
        private final MetricRegistry metricRegistry;

        public MetricRegistryBinder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
        }

        protected void configure() {
            this.bind(this.metricRegistry).to(MetricRegistry.class);
        }
    }

    private static class ComponentLoggingListener
    implements ApplicationEventListener {
        private final DropwizardResourceConfig config;
        private List<Resource> resources = Collections.emptyList();
        private Set<Class<?>> providers = Collections.emptySet();

        ComponentLoggingListener(DropwizardResourceConfig config) {
            this.config = config;
        }

        public void onEvent(ApplicationEvent event) {
            if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                this.resources = event.getResourceModel().getResources();
                this.providers = event.getProviders();
                String resourceClasses = this.resources.stream().map(x -> x.getClass().getCanonicalName()).collect(Collectors.joining(", "));
                String providerClasses = this.providers.stream().map(Class::getCanonicalName).collect(Collectors.joining(", "));
                LOGGER.debug("resources = {}", (Object)resourceClasses);
                LOGGER.debug("providers = {}", (Object)providerClasses);
                LOGGER.info(this.getEndpointsInfo());
            }
        }

        private List<EndpointLogLine> logMethodLines(Resource resource, String contextPath) {
            ArrayList<EndpointLogLine> methodLines = new ArrayList<EndpointLogLine>();
            for (ResourceMethod method : resource.getAllMethods()) {
                if ("OPTIONS".equalsIgnoreCase(method.getHttpMethod())) continue;
                String path = ComponentLoggingListener.mergePaths(contextPath, resource.getPath());
                Class handler = method.getInvocable().getHandler().getHandlerClass();
                switch (method.getType()) {
                    case RESOURCE_METHOD: {
                        methodLines.add(new EndpointLogLine(method.getHttpMethod(), path, handler));
                        break;
                    }
                    case SUB_RESOURCE_LOCATOR: {
                        ResolvedType responseType = TYPE_RESOLVER.resolve(method.getInvocable().getResponseType(), new Type[0]);
                        Class erasedType = !responseType.getTypeBindings().isEmpty() ? responseType.getTypeBindings().getBoundType(0).getErasedType() : responseType.getErasedType();
                        Resource res = Resource.from((Class)erasedType);
                        if (res == null) {
                            methodLines.add(new EndpointLogLine(method.getHttpMethod(), path, handler));
                            break;
                        }
                        methodLines.addAll(this.logResourceLines(res, path));
                        break;
                    }
                }
            }
            return methodLines;
        }

        private static String mergePaths(@NotNull String context, String subPath) {
            if (subPath == null || subPath.isEmpty()) {
                return DropwizardResourceConfig.cleanUpPath(context);
            }
            StringBuilder path = new StringBuilder(context);
            if (!context.endsWith("/")) {
                path.append('/');
            }
            if (!"/".equals(subPath)) {
                int startIndex = subPath.startsWith("/") ? 1 : 0;
                int endIndex = subPath.endsWith("/") ? subPath.length() - 1 : subPath.length();
                path.append(subPath, startIndex, endIndex);
            }
            return DropwizardResourceConfig.cleanUpPath(path.toString());
        }

        private List<EndpointLogLine> logResourceLines(Resource resource, String contextPath) {
            ArrayList<EndpointLogLine> resourceLines = new ArrayList<EndpointLogLine>();
            for (Resource child : resource.getChildResources()) {
                resourceLines.addAll(this.logResourceLines(child, ComponentLoggingListener.mergePaths(contextPath, resource.getPath())));
            }
            resourceLines.addAll(this.logMethodLines(resource, contextPath));
            return resourceLines;
        }

        String getEndpointsInfo() {
            StringBuilder msg = new StringBuilder(1024);
            TreeSet<EndpointLogLine> endpointLogLines = new TreeSet<EndpointLogLine>(new EndpointComparator());
            String contextPath = this.config.getContextPath();
            String normalizedContextPath = contextPath.isEmpty() || contextPath.equals("/") ? "" : (contextPath.startsWith("/") ? contextPath : "/" + contextPath);
            String pattern = this.config.getUrlPattern().endsWith("/*") ? this.config.getUrlPattern().substring(0, this.config.getUrlPattern().length() - 1) : this.config.getUrlPattern();
            String path = ComponentLoggingListener.mergePaths(normalizedContextPath, pattern);
            msg.append("The following paths were found for the configured resources:");
            msg.append(NEWLINE).append(NEWLINE);
            for (Resource resource : this.resources) {
                endpointLogLines.addAll(this.logResourceLines(resource, path));
            }
            List providerLines = this.providers.stream().map(Resource::from).filter(Objects::nonNull).flatMap(res -> this.logResourceLines((Resource)res, path).stream()).collect(Collectors.toList());
            endpointLogLines.addAll(providerLines);
            if (!endpointLogLines.isEmpty()) {
                for (EndpointLogLine line : endpointLogLines) {
                    msg.append(line).append(NEWLINE);
                }
            } else {
                msg.append("    NONE").append(NEWLINE);
            }
            return msg.toString();
        }

        public @Nullable RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private static class EndpointComparator
    implements Comparator<EndpointLogLine>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EndpointComparator() {
        }

        @Override
        public int compare(EndpointLogLine endpointA, EndpointLogLine endpointB) {
            return Comparator.comparing(endpoint -> endpoint.basePath).thenComparing(endpoint -> endpoint.httpMethod, Comparator.nullsLast(Comparator.naturalOrder())).compare(endpointA, endpointB);
        }
    }

    private static class EndpointLogLine {
        private final String httpMethod;
        private final String basePath;
        private final Class<?> klass;

        EndpointLogLine(String httpMethod, String basePath, Class<?> klass) {
            this.basePath = basePath;
            this.klass = klass;
            this.httpMethod = httpMethod;
        }

        public String toString() {
            String method = this.httpMethod == null ? "UNKNOWN" : this.httpMethod;
            return String.format("    %-7s %s (%s)", method, this.basePath, this.klass.getCanonicalName());
        }
    }

    public static class SpecificBinder
    extends AbstractBinder {
        private Object object;
        private Class<?> clazz;

        public SpecificBinder(Object object, Class<?> clazz) {
            this.object = object;
            this.clazz = clazz;
        }

        public void configure() {
            this.bind(this.object).to(this.clazz);
        }
    }
}

