/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorMessage {
    private final int code;
    private final String message;
    private final @Nullable String details;

    public ErrorMessage(String message) {
        this(500, message);
    }

    public ErrorMessage(int code, String message) {
        this(code, message, null);
    }

    @JsonCreator
    public ErrorMessage(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @JsonProperty(value="details") @Nullable String details) {
        this.code = code;
        this.message = message;
        this.details = details;
    }

    @JsonProperty(value="code")
    public Integer getCode() {
        return this.code;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="details")
    public @Nullable String getDetails() {
        return this.details;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.details);
    }

    public String toString() {
        return "ErrorMessage{code=" + this.code + ", message='" + this.message + "', details='" + this.details + "'}";
    }
}

