/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;

public class ContextRoutingHandler
extends AbstractHandler {
    private final Trie<Handler> handlers = new ArrayTernaryTrie(false);

    public ContextRoutingHandler(Map<String, ? extends Handler> handlers) {
        for (Map.Entry<String, ? extends Handler> entry : handlers.entrySet()) {
            if (!this.handlers.put(entry.getKey(), (Object)entry.getValue())) {
                throw new IllegalStateException("Too many handlers");
            }
            this.addBean(entry.getValue());
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = (Handler)this.handlers.getBest(baseRequest.getRequestURI());
        if (handler != null) {
            handler.handle(target, baseRequest, request, response);
        }
    }
}

