/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.DataSizeUnit;
import io.dropwizard.validation.MaxDataSize;
import io.dropwizard.validation.MinDataSize;
import jakarta.validation.Constraint;
import jakarta.validation.OverridesAttribute;
import jakarta.validation.Payload;
import jakarta.validation.ReportAsSingleViolation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Constraint(validatedBy={})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
@Retention(value=RetentionPolicy.RUNTIME)
@MinDataSize(value=0L)
@MaxDataSize(value=0x7FFFFFFFFFFFFFFFL, unit=DataSizeUnit.PEBIBYTES)
@ReportAsSingleViolation
public @interface DataSizeRange {
    @OverridesAttribute(constraint=MinDataSize.class, name="value")
    public long min() default 0L;

    @OverridesAttribute(constraint=MaxDataSize.class, name="value")
    public long max() default 0x7FFFFFFFFFFFFFFFL;

    @OverridesAttribute.List(value={@OverridesAttribute(constraint=MinDataSize.class, name="unit"), @OverridesAttribute(constraint=MaxDataSize.class, name="unit")})
    public DataSizeUnit unit() default DataSizeUnit.BYTES;

    public String message() default "must be between {min} {unit} and {max} {unit}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public DataSizeRange[] value();
    }
}

