/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceGlobFilter;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.SourcePathResolver;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProjectInputResolver {
    private static final Logger log = LoggerFactory.getLogger(ProjectInputResolver.class);
    private final MavenArtifactPathResolver artifactPathResolver;
    private final SourcePathResolver sourceResolver;

    @Inject
    public ProjectInputResolver(MavenArtifactPathResolver artifactPathResolver, SourcePathResolver sourceResolver) {
        this.artifactPathResolver = artifactPathResolver;
        this.sourceResolver = sourceResolver;
    }

    public ProjectInputListing resolveProjectInputs(GenerationRequest request) throws ResolutionException {
        return ImmutableProjectInputListing.builder().compilableSources(this.resolveCompilableSources(request)).dependencySources(this.resolveDependencySources(request)).build();
    }

    private Collection<SourceListing> resolveCompilableSources(GenerationRequest request) throws ResolutionException {
        log.debug("Discovering all compilable protobuf source files");
        SourceGlobFilter filter = new SourceGlobFilter(request.getIncludes(), request.getExcludes());
        Collection<SourceListing> sourcePathsListings = this.sourceResolver.resolveSources(request.getSourceRoots(), filter);
        List<Path> sourceDependencies = this.artifactPathResolver.resolveDependencies(request.getSourceDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), false, request.isFailOnInvalidDependencies());
        Collection<SourceListing> sourceDependencyListings = this.sourceResolver.resolveSources(sourceDependencies, filter);
        return Stream.concat(sourcePathsListings.stream(), sourceDependencyListings.stream()).collect(Collectors.toUnmodifiableList());
    }

    private Collection<SourceListing> resolveDependencySources(GenerationRequest request) throws ResolutionException {
        List<Path> artifactPaths = this.artifactPathResolver.resolveDependencies(request.getImportDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), !request.isIgnoreProjectDependencies(), request.isFailOnInvalidDependencies());
        List<Path> importPaths = Stream.concat(request.getImportPaths().stream(), artifactPaths.stream()).collect(Collectors.toUnmodifiableList());
        SourceGlobFilter filter = new SourceGlobFilter(List.of(), List.of());
        return this.sourceResolver.resolveSources(importPaths, filter);
    }
}

