/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherMavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.generation.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.Digests;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class JvmPluginResolver {
    private static final Set<String> ALLOWED_SCOPES = Set.of("compile", "runtime", "system");
    private static final Logger log = LoggerFactory.getLogger(BinaryPluginResolver.class);
    private final HostSystem hostSystem;
    private final AetherMavenArtifactPathResolver artifactPathResolver;
    private final TemporarySpace temporarySpace;

    @Inject
    public JvmPluginResolver(HostSystem hostSystem, AetherMavenArtifactPathResolver artifactPathResolver, TemporarySpace temporarySpace) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.temporarySpace = temporarySpace;
    }

    public Collection<ResolvedProtocPlugin> resolveMavenPlugins(Collection<? extends MavenProtocPlugin> plugins) throws IOException, ResolutionException {
        ArrayList<ResolvedProtocPlugin> resolvedPlugins = new ArrayList<ResolvedProtocPlugin>();
        for (MavenProtocPlugin mavenProtocPlugin : plugins) {
            if (mavenProtocPlugin.isSkip()) {
                log.info("Skipping plugin {}", (Object)mavenProtocPlugin);
                continue;
            }
            resolvedPlugins.add(this.resolve(mavenProtocPlugin));
        }
        return resolvedPlugins;
    }

    private ResolvedProtocPlugin resolve(MavenProtocPlugin plugin) throws IOException, ResolutionException {
        log.debug("Resolving JVM-based Maven protoc plugin {} and generating OS-specific boostrap scripts", (Object)plugin);
        String pluginId = this.pluginIdDigest(plugin);
        List<String> argLine = this.resolveAndBuildArgLine(plugin);
        Path scriptPath = this.hostSystem.isProbablyWindows() ? this.writeWindowsBatchScript(pluginId, argLine) : this.writeShellScript(pluginId, argLine);
        return ImmutableResolvedProtocPlugin.builder().id(pluginId).path(scriptPath).options(plugin.getOptions()).order(plugin.getOrder()).build();
    }

    private List<String> resolveAndBuildArgLine(MavenProtocPlugin plugin) throws ResolutionException {
        Iterator<Path> dependencyIterator = this.artifactPathResolver.resolveDependencies(List.of(plugin), DependencyResolutionDepth.TRANSITIVE, ALLOWED_SCOPES, false, true).iterator();
        Path pluginPath = dependencyIterator.next();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.hostSystem.getJavaExecutablePath().toString());
        if (dependencyIterator.hasNext()) {
            args.add("-classpath");
            args.add(this.buildClasspath(dependencyIterator));
        }
        args.add("-jar");
        args.add(pluginPath.toString());
        return args;
    }

    private String buildClasspath(Iterator<Path> paths) {
        StringBuilder sb = new StringBuilder().append(paths.next());
        while (paths.hasNext()) {
            sb.append(":").append(paths.next());
        }
        return sb.toString();
    }

    private String pluginIdDigest(MavenProtocPlugin plugin) {
        return Digests.sha1(plugin.toString());
    }

    private Path resolvePluginScriptPath() {
        return this.temporarySpace.createTemporarySpace("plugins", "jvm");
    }

    private Path writeWindowsBatchScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".bat");
        String script = String.join((CharSequence)"\r\n", "@echo off", "", ":: ##################################################", ":: ### Generated by ascopes/protobuf-maven-plugin ###", ":: ###   Users should not invoke this script      ###", ":: ###   directly, unless they know what they are ###", ":: ###   doing.                                   ###", ":: ##################################################", "", Shlex.quoteBatchArgs(argLine), "");
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        return fullScriptPath;
    }

    private Path writeShellScript(String pluginId, List<String> argLine) throws IOException {
        Path fullScriptPath = this.resolvePluginScriptPath().resolve(pluginId + ".sh");
        String script = String.join((CharSequence)"\n", "#!/usr/bin/env sh", "", "##################################################", "### Generated by ascopes/protobuf-maven-plugin ###", "###   Users should not invoke this script      ###", "###   directly unless they know what they are  ###", "###   doing.                                   ###", "##################################################", "", "set -eu", "", Shlex.quoteShellArgs(argLine), "");
        Files.writeString(fullScriptPath, (CharSequence)script, StandardCharsets.UTF_8, new OpenOption[0]);
        FileUtils.makeExecutable(fullScriptPath);
        return fullScriptPath;
    }
}

