/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.Left;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

final class Right<L, R>
extends Either<L, R> {
    private final R value;

    Right(R value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public Optional<L> getLeft() {
        return Optional.empty();
    }

    @Override
    public boolean isLeft() {
        return false;
    }

    @Override
    public Optional<R> getRight() {
        return Optional.of(this.value);
    }

    @Override
    public <R2> Either<L, R2> map(Function<? super R, ? extends R2> mapper) {
        return new Right<L, R2>(mapper.apply(this.value));
    }

    @Override
    public <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<? extends L, ? extends R2>> mapper) {
        Either<? extends L, ? extends R2> result = mapper.apply(this.value);
        return result;
    }

    @Override
    public Either<L, R> filter(Function<? super R, Optional<? extends L>> predicate) {
        Optional<L> test = predicate.apply(this.value);
        if (test.isEmpty()) {
            return this;
        }
        return new Left(test.orElseThrow());
    }

    @Override
    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> mapper) {
        Right result = this;
        return result;
    }

    @Override
    public <L2> Either<L2, R> flatMapLeft(Function<? super L, ? extends Either<? extends L2, ? extends R>> mapper) {
        Right result = this;
        return result;
    }

    @Override
    public Either<L, R> filterLeft(Function<? super L, Optional<? extends R>> predicate) {
        return this;
    }

    @Override
    public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
        return rightMapper.apply(this.value);
    }

    @Override
    public void ifLeftOrElse(Consumer<? super L> leftAction, Consumer<? super R> rightAction) {
        rightAction.accept(this.value);
    }

    @Override
    public <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> exceptionSupplier) {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("Right[%s]", this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Right)) {
            return false;
        }
        Right other = (Right)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

