/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import io.github.kbuntrock.configuration.Operation;
import io.github.kbuntrock.configuration.Tag;
import io.github.kbuntrock.configuration.library.Library;
import io.github.kbuntrock.configuration.library.TagAnnotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class CommonApiConfiguration {
    public static String SEPARATOR_CLASS_METHOD = "#";
    public static String DEFAULT_OPERATION_ID = "{class_name}.{method_name}";
    public static String DEFAULT_LIBRARY = Library.SPRING_MVC.name();
    public static List<String> DEFAULT_TAG_ANNOTATIONS = new ArrayList<String>();
    @Parameter
    protected List<String> locations;
    @Parameter
    protected Tag tag = new Tag();
    @Parameter
    protected Operation operation = new Operation();
    @Parameter
    protected Boolean attachArtifact;
    @Parameter
    protected String defaultSuccessfulOperationDescription;
    @Parameter
    protected Boolean defaultProduceConsumeGuessing;
    @Parameter
    protected Boolean pathEnhancement;
    @Parameter
    protected String pathPrefix;
    @Parameter(defaultValue="yaml")
    protected String fileFormat;
    @Parameter
    protected Boolean loopbackOperationName;
    @Parameter
    protected Boolean enumListDescriptionEnabled;
    @Parameter
    protected Boolean enumNameExtensionEnabled;
    @Parameter
    protected String enumNameExtensionValue;
    @Parameter
    protected Boolean enumDescriptionExtensionEnabled;
    @Parameter
    protected String enumDescriptionExtensionValue;
    @Parameter
    protected Boolean defaultNonNullableFields;
    @Parameter
    protected List<String> nonNullableAnnotation;
    @Parameter
    protected List<String> nullableAnnotation;
    @Parameter
    protected String operationId;
    @Parameter
    protected String freeFields;
    @Parameter
    protected String library;
    @Parameter
    protected List<String> tagAnnotations = new ArrayList<String>();
    @Parameter(required=true)
    protected List<String> whiteList;
    @Parameter(required=true)
    protected List<String> blackList;
    @Parameter
    protected List<String> extraSchemaClasses = new ArrayList<String>();
    @Parameter
    protected String customResponseTypeAnnotation;
    @Parameter
    protected String defaultErrors;
    @Parameter
    protected String openapiModels;
    @Parameter
    protected String modelsAssociations;
    @Parameter
    protected List<String> nonDocumentableParameterClasses = new ArrayList<String>();

    public CommonApiConfiguration() {
    }

    public CommonApiConfiguration(CommonApiConfiguration commonApiConfiguration) {
        if (commonApiConfiguration.locations != null) {
            this.locations = new ArrayList<String>();
            this.locations.addAll(commonApiConfiguration.locations);
        }
        this.tag = new Tag(commonApiConfiguration.tag);
        this.operation = new Operation(commonApiConfiguration.operation);
        this.attachArtifact = commonApiConfiguration.attachArtifact;
        this.defaultSuccessfulOperationDescription = commonApiConfiguration.defaultSuccessfulOperationDescription;
        this.defaultProduceConsumeGuessing = commonApiConfiguration.defaultProduceConsumeGuessing;
        this.pathEnhancement = commonApiConfiguration.pathEnhancement;
        this.pathPrefix = commonApiConfiguration.pathPrefix;
        this.fileFormat = commonApiConfiguration.fileFormat;
        this.loopbackOperationName = commonApiConfiguration.loopbackOperationName;
        this.enumListDescriptionEnabled = commonApiConfiguration.enumListDescriptionEnabled;
        this.enumNameExtensionEnabled = commonApiConfiguration.enumNameExtensionEnabled;
        this.enumNameExtensionValue = commonApiConfiguration.enumNameExtensionValue;
        this.enumDescriptionExtensionEnabled = commonApiConfiguration.enumDescriptionExtensionEnabled;
        this.enumDescriptionExtensionValue = commonApiConfiguration.enumDescriptionExtensionValue;
        this.operationId = commonApiConfiguration.operationId;
        this.freeFields = commonApiConfiguration.freeFields;
        this.library = commonApiConfiguration.library;
        this.customResponseTypeAnnotation = commonApiConfiguration.customResponseTypeAnnotation;
        this.defaultErrors = commonApiConfiguration.defaultErrors;
        this.openapiModels = commonApiConfiguration.openapiModels;
        this.modelsAssociations = commonApiConfiguration.modelsAssociations;
        this.defaultNonNullableFields = commonApiConfiguration.defaultNonNullableFields;
        this.nonNullableAnnotation = commonApiConfiguration.nonNullableAnnotation;
        this.nullableAnnotation = commonApiConfiguration.nullableAnnotation;
        for (String tagAnnotation : commonApiConfiguration.tagAnnotations) {
            this.tagAnnotations.add(tagAnnotation);
        }
        if (commonApiConfiguration.whiteList != null) {
            this.whiteList = new ArrayList<String>();
            this.whiteList.addAll(commonApiConfiguration.whiteList);
        }
        if (commonApiConfiguration.blackList != null) {
            this.blackList = new ArrayList<String>();
            this.blackList.addAll(commonApiConfiguration.blackList);
        }
        if (commonApiConfiguration.nonNullableAnnotation != null) {
            this.nonNullableAnnotation = new ArrayList<String>();
            this.nonNullableAnnotation.addAll(commonApiConfiguration.nonNullableAnnotation);
        }
        if (commonApiConfiguration.nullableAnnotation != null) {
            this.nullableAnnotation = new ArrayList<String>();
            this.nullableAnnotation.addAll(commonApiConfiguration.nullableAnnotation);
        }
        if (!commonApiConfiguration.extraSchemaClasses.isEmpty()) {
            this.extraSchemaClasses.addAll(commonApiConfiguration.extraSchemaClasses);
        }
        for (String nonDocumentableParameterClass : commonApiConfiguration.nonDocumentableParameterClasses) {
            this.nonDocumentableParameterClasses.add(nonDocumentableParameterClass);
        }
    }

    public void initDefaultValues() {
        if (this.library == null) {
            this.library = DEFAULT_LIBRARY;
        }
        if (this.tagAnnotations.isEmpty()) {
            if (Library.SPRING_MVC.name().equals(this.library)) {
                this.tagAnnotations.add(TagAnnotation.SPRING_REST_CONTROLLER.getAnnotationClassName());
            } else if (Library.JAVAX_RS.name().equals(this.library)) {
                this.tagAnnotations.add(TagAnnotation.JAVAX_RS_PATH.getAnnotationClassName());
            } else {
                this.tagAnnotations.add(TagAnnotation.JAKARTA_RS_PATH.getAnnotationClassName());
            }
        }
        if (this.operationId == null) {
            this.operationId = DEFAULT_OPERATION_ID;
        }
        if (this.loopbackOperationName == null) {
            this.loopbackOperationName = true;
        }
        if (this.enumListDescriptionEnabled == null) {
            this.enumListDescriptionEnabled = true;
        }
        if (this.enumNameExtensionEnabled == null) {
            this.enumNameExtensionEnabled = true;
        }
        if (this.enumNameExtensionValue == null) {
            this.enumNameExtensionValue = "x-enum-varnames";
        }
        if (this.enumDescriptionExtensionEnabled == null) {
            this.enumDescriptionExtensionEnabled = true;
        }
        if (this.enumDescriptionExtensionValue == null) {
            this.enumDescriptionExtensionValue = "x-enum-descriptions";
        }
        if (this.pathEnhancement == null) {
            this.pathEnhancement = true;
        }
        if (this.pathPrefix == null) {
            this.pathPrefix = "";
        }
        if (this.defaultProduceConsumeGuessing == null) {
            this.defaultProduceConsumeGuessing = true;
        }
        if (this.defaultSuccessfulOperationDescription == null) {
            this.defaultSuccessfulOperationDescription = "successful operation";
        }
        if (this.attachArtifact == null) {
            this.attachArtifact = true;
        }
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isAttachArtifact() {
        return this.attachArtifact;
    }

    public void setAttachArtifact(boolean attachArtifact) {
        this.attachArtifact = attachArtifact;
    }

    public boolean isDefaultProduceConsumeGuessing() {
        return this.defaultProduceConsumeGuessing;
    }

    public void setDefaultProduceConsumeGuessing(boolean defaultProduceConsumeGuessing) {
        this.defaultProduceConsumeGuessing = defaultProduceConsumeGuessing;
    }

    public boolean getPathEnhancement() {
        return this.pathEnhancement;
    }

    public void setPathEnhancement(boolean pathEnhancement) {
        this.pathEnhancement = pathEnhancement;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getDefaultSuccessfulOperationDescription() {
        return this.defaultSuccessfulOperationDescription;
    }

    public void setDefaultSuccessfulOperationDescription(String defaultSuccessfulOperationDescription) {
        this.defaultSuccessfulOperationDescription = defaultSuccessfulOperationDescription;
    }

    public boolean isLoopbackOperationName() {
        return this.loopbackOperationName;
    }

    public void setLoopbackOperationName(boolean loopbackOperationName) {
        this.loopbackOperationName = loopbackOperationName;
    }

    public Boolean getEnumListDescriptionEnabled() {
        return this.enumListDescriptionEnabled;
    }

    public void setEnumListDescriptionEnabled(Boolean enumListDescriptionEnabled) {
        this.enumListDescriptionEnabled = enumListDescriptionEnabled;
    }

    public Boolean getEnumNameExtensionEnabled() {
        return this.enumNameExtensionEnabled;
    }

    public void setEnumNameExtensionEnabled(Boolean enumNameExtensionEnabled) {
        this.enumNameExtensionEnabled = enumNameExtensionEnabled;
    }

    public String getEnumNameExtensionValue() {
        return this.enumNameExtensionValue;
    }

    public void setEnumNameExtensionValue(String enumNameExtensionValue) {
        this.enumNameExtensionValue = enumNameExtensionValue;
    }

    public Boolean getEnumDescriptionExtensionEnabled() {
        return this.enumDescriptionExtensionEnabled;
    }

    public void setEnumDescriptionExtensionEnabled(Boolean enumDescriptionExtensionEnabled) {
        this.enumDescriptionExtensionEnabled = enumDescriptionExtensionEnabled;
    }

    public String getEnumDescriptionExtensionValue() {
        return this.enumDescriptionExtensionValue;
    }

    public void setEnumDescriptionExtensionValue(String enumDescriptionExtensionValue) {
        this.enumDescriptionExtensionValue = enumDescriptionExtensionValue;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getFreeFields() {
        return this.freeFields;
    }

    public void setFreeFields(String freeFields) {
        this.freeFields = freeFields;
    }

    public Library getLibrary() {
        return Library.getByName(this.library);
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public List<String> getTagAnnotations() {
        return this.tagAnnotations;
    }

    public void setTagAnnotations(List<String> tagAnnotations) {
        this.tagAnnotations = tagAnnotations;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public List<String> getBlackList() {
        return this.blackList;
    }

    public void setBlackList(List<String> blackList) {
        this.blackList = blackList;
    }

    public List<String> getExtraSchemaClasses() {
        return this.extraSchemaClasses;
    }

    public void setExtraSchemaClasses(List<String> extraSchemaClasses) {
        this.extraSchemaClasses = extraSchemaClasses;
    }

    public String getCustomResponseTypeAnnotation() {
        return this.customResponseTypeAnnotation;
    }

    public void setCustomResponseTypeAnnotation(String customResponseTypeAnnotation) {
        this.customResponseTypeAnnotation = customResponseTypeAnnotation;
    }

    public String getDefaultErrors() {
        return this.defaultErrors;
    }

    public void setDefaultErrors(String defaultErrors) {
        this.defaultErrors = defaultErrors;
    }

    public String getOpenapiModels() {
        return this.openapiModels;
    }

    public void setOpenapiModels(String openapiModels) {
        this.openapiModels = openapiModels;
    }

    public String getModelsAssociations() {
        return this.modelsAssociations;
    }

    public void setModelsAssociations(String modelsAssociations) {
        this.modelsAssociations = modelsAssociations;
    }

    public Boolean getDefaultNonNullableFields() {
        return this.defaultNonNullableFields;
    }

    public void setDefaultNonNullableFields(Boolean defaultNonNullableFields) {
        this.defaultNonNullableFields = defaultNonNullableFields;
    }

    public List<String> getNonNullableAnnotation() {
        return this.nonNullableAnnotation;
    }

    public void setNonNullableAnnotation(List<String> nonNullableAnnotation) {
        this.nonNullableAnnotation = nonNullableAnnotation;
    }

    public List<String> getNullableAnnotation() {
        return this.nullableAnnotation;
    }

    public void setNullableAnnotation(List<String> nullableAnnotation) {
        this.nullableAnnotation = nullableAnnotation;
    }

    public List<String> getNonDocumentableParameterClasses() {
        return this.nonDocumentableParameterClasses;
    }

    public void setNonDocumentableParameterClasses(List<String> nonDocumentableParameterClasses) {
        this.nonDocumentableParameterClasses = nonDocumentableParameterClasses;
    }

    static {
        DEFAULT_TAG_ANNOTATIONS.add(TagAnnotation.SPRING_REST_CONTROLLER.getAnnotationClassName());
    }
}

