/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import java.util.Collection;
import javax.lang.model.element.Modifier;

public class SpringAdapterMapperGenerator
extends AbstractAdapterMapperGenerator {
    @Override
    protected TypeSpec createTypeSpec(Collection<AbstractAdapterMethodMetadata> adapterMethods, String adapterClassName) {
        TypeSpec.Builder adapterBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)this.adapterPackage(), (String)adapterClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0]));
        adapterMethods.stream().map(AbstractAdapterMethodMetadata::getMapper).distinct().forEach(mapper -> adapterBuilder.addField(this.buildMapperField((ClassName)mapper)).addMethod(this.buildMapperSetterMethod((ClassName)mapper)));
        adapterMethods.forEach(adapterMethod -> adapterBuilder.addMethod(this.buildProxyMethod((AbstractAdapterMethodMetadata)adapterMethod)));
        return adapterBuilder.build();
    }

    private FieldSpec buildMapperField(ClassName mapper) {
        return FieldSpec.builder((TypeName)mapper, (String)this.firstWordToLower(mapper.simpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private String firstWordToLower(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    private MethodSpec buildProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata) {
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)adapterMethodMetadata.getSource(), (String)this.firstWordToLower(adapterMethodMetadata.getSource().simpleName()), (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)adapterMethodMetadata.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).returns((TypeName)adapterMethodMetadata.getReturn()).addStatement("return $N.$N($N)", new Object[]{this.firstWordToLower(adapterMethodMetadata.getMapper().simpleName()), adapterMethodMetadata.getMapperMethodName(), this.firstWordToLower(adapterMethodMetadata.getSource().simpleName())}).build();
    }

    private MethodSpec buildMapperSetterMethod(ClassName mapper) {
        ParameterSpec parameterSpec = this.buildMapperSetterParameter(mapper);
        return MethodSpec.methodBuilder((String)("set" + mapper.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Autowired", (String[])new String[0])).build()).addStatement("this.$N = $N", new Object[]{this.buildMapperField(mapper), parameterSpec}).build();
    }

    private ParameterSpec buildMapperSetterParameter(ClassName mapper) {
        return ParameterSpec.builder((TypeName)mapper, (String)this.firstWordToLower(mapper.simpleName()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.context.annotation", (String)"Lazy", (String[])new String[0])).build()).build();
    }
}

