/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.HibernateSupport;
import io.github.perplexhub.rsql.JoinUtils;
import io.github.perplexhub.rsql.PathUtils;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLCustomPredicateInput;
import io.github.perplexhub.rsql.RSQLException;
import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPASupport;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.ResolvedExpression;
import io.github.perplexhub.rsql.Selector;
import io.github.perplexhub.rsql.UnknownPropertyException;
import io.github.perplexhub.rsql.jsonb.JsonbSupport;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.query.criteria.JpaExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSQLJPAPredicateConverter
extends RSQLVisitorBase<Predicate, From> {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPAPredicateConverter.class);
    private final CriteriaBuilder builder;
    private final Map<String, Path> cachedJoins = new HashMap<String, Path>();
    private final Map<String, String> propertyPathMapper;
    private final Map<ComparisonOperator, RSQLCustomPredicate<?>> customPredicates;
    private final Map<String, JoinType> joinHints;
    private final Collection<String> procedureWhiteList;
    private final Collection<String> procedureBlackList;
    private final boolean strictEquality;
    private final Character likeEscapeCharacter;

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper) {
        this(builder, propertyPathMapper, null, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates) {
        this(builder, propertyPathMapper, customPredicates, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints) {
        this(builder, propertyPathMapper, customPredicates, joinHints, null, null, false, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, Collection<String> procedureWhiteList, Collection<String> procedureBlackList) {
        this(builder, propertyPathMapper, customPredicates, joinHints, procedureWhiteList, procedureBlackList, false, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, Collection<String> proceduresWhiteList, Collection<String> proceduresBlackList, boolean strictEquality, Character likeEscapeCharacter) {
        this.builder = builder;
        this.propertyPathMapper = propertyPathMapper != null ? propertyPathMapper : Collections.emptyMap();
        this.customPredicates = customPredicates != null ? customPredicates.stream().collect(Collectors.toMap(RSQLCustomPredicate::getOperator, Function.identity(), (a, b) -> a)) : Collections.emptyMap();
        this.joinHints = joinHints != null ? joinHints : Collections.emptyMap();
        this.procedureWhiteList = proceduresWhiteList != null ? proceduresWhiteList : Collections.emptyList();
        this.procedureBlackList = proceduresBlackList != null ? proceduresBlackList : Collections.emptyList();
        this.strictEquality = strictEquality;
        this.likeEscapeCharacter = likeEscapeCharacter;
    }

    RSQLJPAContext findPropertyPath(String propertyPath, Path startRoot) {
        return this.findPropertyPathInternal(propertyPath, startRoot, true);
    }

    private RSQLJPAContext findPropertyPathInternal(String propertyPath, Path startRoot, boolean firstTry) {
        Class type = startRoot.getJavaType();
        ManagedType classMetadata = this.getManagedType(type);
        ManagedType previousClassMetadata = null;
        Path<?> root = startRoot;
        Attribute attribute = null;
        String resolvedPropertyPath = firstTry ? this.mapPropertyPath(propertyPath) : propertyPath;
        String[] properties = this.mapPropertyPath(resolvedPropertyPath).split("\\.");
        int propertiesLength = properties.length;
        for (int i = 0; i < propertiesLength; ++i) {
            String property = properties[i];
            String mappedProperty = this.mapProperty(property, classMetadata.getJavaType());
            if (!mappedProperty.equals(property)) {
                RSQLJPAContext context = this.findPropertyPathInternal(mappedProperty, (Path)root, firstTry);
                root = context.getPath();
                attribute = context.getAttribute();
                classMetadata = context.getManagedType();
                continue;
            }
            if (!this.hasPropertyName(mappedProperty, classMetadata)) {
                Optional mayBeJSonPath = PathUtils.findMappingOnBeginning((String)propertyPath, this.propertyPathMapper);
                if (firstTry && mayBeJSonPath.isPresent()) {
                    return this.findPropertyPathInternal((String)mayBeJSonPath.get(), startRoot, false);
                }
                throw new UnknownPropertyException(mappedProperty, classMetadata.getJavaType());
            }
            if (this.isAssociationType(mappedProperty, classMetadata) && !property.equals(resolvedPropertyPath)) {
                Class associationType;
                boolean isOneToAssociationType = this.isOneToOneAssociationType(mappedProperty, classMetadata) || this.isOneToManyAssociationType(mappedProperty, classMetadata);
                type = associationType = this.findPropertyType(mappedProperty, classMetadata);
                String previousClass = classMetadata.getJavaType().getName();
                previousClassMetadata = classMetadata;
                classMetadata = this.getManagedType(associationType);
                String keyJoin = this.getKeyJoin(root, mappedProperty);
                if (isOneToAssociationType) {
                    if (this.joinHints.containsKey(keyJoin)) {
                        log.debug("Create a join between [{}] and [{}] using key [{}] with supplied hints", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                        root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                        continue;
                    }
                    log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                    root = this.join(keyJoin, root, mappedProperty, JoinType.LEFT);
                    continue;
                }
                String lookAheadProperty = i < propertiesLength - 1 ? properties[i + 1] : null;
                boolean lookAheadPropertyIsId = false;
                if (!this.isManyToManyAssociationType(mappedProperty, previousClassMetadata) && classMetadata instanceof IdentifiableType && lookAheadProperty != null) {
                    IdentifiableType identifiableType = (IdentifiableType)classMetadata;
                    SingularAttribute id = identifiableType.getId(identifiableType.getIdType().getJavaType());
                    if (identifiableType.hasSingleIdAttribute() && id.isId() && id.getName().equals(lookAheadProperty)) {
                        lookAheadPropertyIsId = true;
                    }
                }
                if (lookAheadPropertyIsId || lookAheadProperty == null) {
                    log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
                    root = root.get(mappedProperty);
                    continue;
                }
                log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                continue;
            }
            if (this.isElementCollectionType(mappedProperty, classMetadata)) {
                String previousClass = classMetadata.getJavaType().getName();
                attribute = RSQLVisitorBase.getAttribute((String)property, classMetadata);
                classMetadata = this.getManagedElementCollectionType(mappedProperty, classMetadata);
                String keyJoin = this.getKeyJoin(root, mappedProperty);
                log.debug("Create a element collection join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty, this.joinHints.get(keyJoin));
                continue;
            }
            if (JsonbSupport.isJsonType(mappedProperty, classMetadata)) {
                root = root.get(mappedProperty);
                attribute = RSQLVisitorBase.getAttribute((String)mappedProperty, classMetadata);
                break;
            }
            log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
            root = root.get(mappedProperty);
            if (this.isEmbeddedType(mappedProperty, classMetadata)) {
                Class embeddedType;
                type = embeddedType = this.findPropertyType(mappedProperty, classMetadata);
                classMetadata = this.getManagedType(embeddedType);
                continue;
            }
            attribute = RSQLVisitorBase.getAttribute((String)property, (ManagedType)classMetadata);
        }
        if (attribute != null) {
            this.accessControl(type, attribute.getName());
        }
        return RSQLJPAContext.of(root, attribute, classMetadata);
    }

    private String getKeyJoin(Path<?> root, String mappedProperty) {
        return root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty) {
        return this.join(keyJoin, root, mappedProperty, null);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty, JoinType joinType) {
        log.debug("join(keyJoin:{},root:{},mappedProperty:{},joinType:{})", new Object[]{keyJoin, root, mappedProperty, joinType});
        if (this.cachedJoins.containsKey(keyJoin)) {
            root = this.cachedJoins.get(keyJoin);
        } else {
            root = JoinUtils.getOrCreateJoin((From)root, mappedProperty, joinType);
            this.cachedJoins.put(keyJoin, (Path)root);
        }
        return root;
    }

    public Predicate visit(ComparisonNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        ComparisonOperator op = node.getOperator();
        if (this.customPredicates.containsKey(op)) {
            RSQLCustomPredicate<?> customPredicate = this.customPredicates.get(op);
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                arguments.add(this.convert(argument, customPredicate.getType()));
            }
            RSQLJPAContext holder = this.findPropertyPath(node.getSelector(), (Path)root);
            return (Predicate)customPredicate.getConverter().apply(RSQLCustomPredicateInput.of((CriteriaBuilder)this.builder, holder.getPath(), holder.getAttribute(), arguments, (From)root));
        }
        Selector selector = Selector.selectorOf(node.getSelector(), this.builder);
        Selector.assertWhiteListed(selector, this.procedureWhiteList);
        Selector.assertNotBlackListed(selector, this.procedureBlackList);
        ResolvedExpression resolvedExpression = this.resolveExpression(node, root, selector);
        log.debug("Resolved expression: {}", (Object)resolvedExpression);
        if (resolvedExpression instanceof ResolvedExpression.JsonbPathExpression) {
            ResolvedExpression.JsonbPathExpression jsonbPathExpression = (ResolvedExpression.JsonbPathExpression)resolvedExpression;
            return this.jsonPredicate(jsonbPathExpression);
        }
        if (resolvedExpression instanceof ResolvedExpression.PathExpression) {
            ResolvedExpression.PathExpression pathExpression = (ResolvedExpression.PathExpression)resolvedExpression;
            return this.expressionPredicate(node, pathExpression);
        }
        throw new IllegalArgumentException("Unknown resolved expression type: " + String.valueOf(resolvedExpression.getClass()));
    }

    private ResolvedExpression resolveExpression(ComparisonNode node, From root, Selector selector) {
        if (selector instanceof Selector.SingleColumnSelector) {
            Class type;
            Selector.SingleColumnSelector singleColumnSelector = (Selector.SingleColumnSelector)selector;
            RSQLJPAContext holder = this.findPropertyPath(singleColumnSelector.column(), (Path)root);
            Attribute<?, ?> attribute = holder.getAttribute();
            Path<?> path = holder.getPath();
            Class clazz = type = path.getJavaType() != null ? path.getJavaType() : attribute.getJavaType();
            if (JsonbSupport.isJsonType(attribute)) {
                Expression expression;
                String jsonSelector = PathUtils.expectBestMapping((String)node.getSelector(), this.propertyPathMapper);
                String jsonbPath = JsonbSupport.jsonPathOfSelector(attribute, jsonSelector);
                if (jsonbPath.contains(".")) {
                    ComparisonNode jsonbNode = node.withSelector(jsonbPath);
                    return JsonbSupport.jsonbPathExistsExpression(this.builder, jsonbNode, path);
                }
                if (path instanceof JpaExpression) {
                    JpaExpression jpaExpression = (JpaExpression)path;
                    expression = jpaExpression.cast(String.class);
                } else {
                    expression = path.as(String.class);
                }
                return ResolvedExpression.ofPath(expression, String.class);
            }
            if (attribute != null && attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                type = RSQLJPAPredicateConverter.getElementCollectionGenericType((Class)type, attribute);
            }
            if (type.isPrimitive()) {
                type = (Class)primitiveToWrapper.get(type);
            } else if (RSQLJPASupport.getValueTypeMap().containsKey(type)) {
                type = (Class)RSQLJPASupport.getValueTypeMap().get(type);
            }
            return ResolvedExpression.ofPath(holder.getPath(), type);
        }
        if (selector instanceof Selector.FunctionSelector) {
            Expression<?> expression = selector.getExpression((column, criteriaBuilder) -> this.findPropertyPath((String)column, (Path)root).getPath());
            return ResolvedExpression.ofPath(expression, Object.class);
        }
        throw new IllegalArgumentException("Unknown selector type: " + String.valueOf(selector.getClass()));
    }

    private Predicate jsonPredicate(ResolvedExpression.JsonbPathExpression jsonbPathExpression) {
        if (jsonbPathExpression.inverted()) {
            return this.builder.isFalse(jsonbPathExpression.expression());
        }
        return this.builder.isTrue(jsonbPathExpression.expression());
    }

    private Predicate expressionPredicate(ComparisonNode node, ResolvedExpression.PathExpression resolvedExpression) {
        Expression<?> expression = resolvedExpression.expression();
        Class<?> type = resolvedExpression.type();
        ComparisonOperator op = node.getOperator();
        List arguments = node.getArguments();
        if (arguments.size() > 1) {
            Comparable comp2;
            Comparable comp1;
            Object e;
            ArrayList<Object> listObject = new ArrayList<Object>();
            for (String argument : arguments) {
                listObject.add(this.convert(argument, type));
            }
            if (op.equals((Object)RSQLOperators.IN)) {
                return expression.in(listObject);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return expression.in(listObject).not();
            }
            if (op.equals((Object)RSQLOperators.BETWEEN) && (e = listObject.get(0)) instanceof Comparable) {
                comp1 = (Comparable)e;
                e = listObject.get(1);
                if (e instanceof Comparable) {
                    comp2 = (Comparable)e;
                    return this.builder.between(expression, comp1, comp2);
                }
            }
            if (op.equals((Object)RSQLOperators.NOT_BETWEEN) && (e = listObject.get(0)) instanceof Comparable) {
                comp1 = (Comparable)e;
                e = listObject.get(1);
                if (e instanceof Comparable) {
                    comp2 = (Comparable)e;
                    return this.builder.between(expression, comp1, comp2).not();
                }
            }
        } else {
            if (op.equals((Object)RSQLOperators.IS_NULL)) {
                return this.builder.isNull(expression);
            }
            if (op.equals((Object)RSQLOperators.NOT_NULL)) {
                return this.builder.isNotNull(expression);
            }
            Object argument = this.convert((String)arguments.get(0), type);
            if (op.equals((Object)RSQLOperators.IN)) {
                return this.builder.equal(expression, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return this.builder.notEqual(expression, argument);
            }
            if (op.equals((Object)RSQLOperators.LIKE)) {
                return this.likePredicate(expression, argument, false);
            }
            if (op.equals((Object)RSQLOperators.NOT_LIKE)) {
                return this.likePredicate(expression, argument, false).not();
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE)) {
                return this.builder.equal(this.builder.upper(expression), (Object)argument.toString().toUpperCase());
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_LIKE)) {
                return this.likePredicate(expression, argument, true);
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) {
                return this.likePredicate(expression, argument, true).not();
            }
            if (op.equals((Object)RSQLOperators.EQUAL)) {
                return this.equalPredicate(expression, type, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL)) {
                return this.equalPredicate(expression, type, argument).not();
            }
            if (!Comparable.class.isAssignableFrom(type)) {
                log.error("Operator {} can be used only for Comparables", (Object)op);
                throw new RSQLException(String.format("Operator %s can be used only for Comparables", op));
            }
            Comparable comparable = (Comparable)argument;
            if (op.equals((Object)RSQLOperators.GREATER_THAN)) {
                return this.builder.greaterThan(expression, comparable);
            }
            if (op.equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                return this.builder.greaterThanOrEqualTo(expression, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN)) {
                return this.builder.lessThan(expression, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                return this.builder.lessThanOrEqualTo(expression, comparable);
            }
        }
        log.error("Unknown operator: {}", (Object)op);
        throw new RSQLException("Unknown operator: " + String.valueOf(op));
    }

    private Predicate likePredicate(Expression attributePath, String likeExpression, CriteriaBuilder builder) {
        return Optional.ofNullable(this.likeEscapeCharacter).map(character -> builder.like(attributePath, likeExpression, character.charValue())).orElseGet(() -> builder.like(attributePath, likeExpression));
    }

    private Predicate likePredicate(Expression<?> expression, Object argument, boolean ignoreCase) {
        String argToUse = String.valueOf(argument);
        Expression strExpression = expression.as(String.class);
        if (ignoreCase) {
            if (HibernateSupport.isHibernateCriteriaBuilder(this.builder)) {
                return HibernateSupport.ilike(this.builder, (Expression<String>)strExpression, argToUse, this.likeEscapeCharacter);
            }
            return this.likePredicate(this.builder.upper(strExpression), "%" + argToUse.toUpperCase(Locale.ROOT) + "%", this.builder);
        }
        return this.likePredicate(strExpression, "%" + argToUse + "%", this.builder);
    }

    private Predicate equalPredicate(Expression expr, Class type, Object argument) {
        if (type.equals(String.class)) {
            String argStr = argument.toString();
            if (this.strictEquality) {
                return this.builder.equal(expr, argument);
            }
            if (argStr.contains("*") && argStr.contains("^")) {
                return this.likePredicate(this.builder.upper(expr), argStr.replace('*', '%').replace("^", "").toUpperCase(), this.builder);
            }
            if (argStr.contains("*")) {
                return this.likePredicate(expr, argStr.replace('*', '%'), this.builder);
            }
            if (argStr.contains("^")) {
                return this.builder.equal(this.builder.upper(expr), (Object)argStr.replace("^", "").toUpperCase());
            }
            return this.builder.equal(expr, argument);
        }
        if (argument == null) {
            return this.builder.isNull(expr);
        }
        return this.builder.equal(expr, argument);
    }

    public Predicate visit(AndNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return this.visitChildren((LogicalNode)node, root, (arg_0, arg_1) -> ((CriteriaBuilder)this.builder).and(arg_0, arg_1));
    }

    public Predicate visit(OrNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return this.visitChildren((LogicalNode)node, root, (arg_0, arg_1) -> ((CriteriaBuilder)this.builder).or(arg_0, arg_1));
    }

    private Predicate visitChildren(LogicalNode node, From root, BiFunction<Predicate, Predicate, Predicate> reducer) {
        Predicate result = null;
        for (Node child : node) {
            result = result != null ? reducer.apply(result, (Predicate)child.accept((RSQLVisitor)this, (Object)root)) : (Predicate)child.accept((RSQLVisitor)this, (Object)root);
        }
        return result;
    }

    public Map<String, String> getPropertyPathMapper() {
        return this.propertyPathMapper;
    }

    public Map<ComparisonOperator, RSQLCustomPredicate<?>> getCustomPredicates() {
        return this.customPredicates;
    }

    public Map<String, JoinType> getJoinHints() {
        return this.joinHints;
    }
}

