/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circularbuffer;

import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public class ConcurrentEvictingQueue<E>
extends AbstractQueue<E> {
    private static final String ILLEGAL_CAPACITY = "Capacity must be bigger than 0";
    private static final String ILLEGAL_ELEMENT = "Element must not be null";
    private static final String ILLEGAL_DESTINATION_ARRAY = "Destination array must not be null";
    private static final Object[] DEFAULT_DESTINATION = new Object[0];
    private static final int RETRIES = 5;
    private final int maxSize;
    private final StampedLock stampedLock;
    private volatile int size;
    private Object[] ringBuffer;
    private int headIndex;
    private int tailIndex;
    private int modificationsCount;

    public ConcurrentEvictingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException(ILLEGAL_CAPACITY);
        }
        this.maxSize = capacity;
        this.ringBuffer = new Object[capacity];
        this.size = 0;
        this.headIndex = 0;
        this.tailIndex = 0;
        this.modificationsCount = 0;
        this.stampedLock = new StampedLock();
    }

    @Override
    public Iterator<E> iterator() {
        return this.readConcurrently(() -> new Iter(this.headIndex, this.modificationsCount));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e, ILLEGAL_ELEMENT);
        Supplier<Boolean> offerElement = () -> {
            if (this.size == 0) {
                this.ringBuffer[this.tailIndex] = e;
                ++this.modificationsCount;
                ++this.size;
            } else if (this.size == this.maxSize) {
                this.headIndex = this.nextIndex(this.headIndex);
                this.tailIndex = this.nextIndex(this.tailIndex);
                this.ringBuffer[this.tailIndex] = e;
                ++this.modificationsCount;
            } else {
                this.tailIndex = this.nextIndex(this.tailIndex);
                this.ringBuffer[this.tailIndex] = e;
                ++this.size;
                ++this.modificationsCount;
            }
            return true;
        };
        return this.writeConcurrently(offerElement);
    }

    @Override
    public E poll() {
        Supplier<Object> pollElement = () -> {
            if (this.size == 0) {
                return null;
            }
            Object result = this.ringBuffer[this.headIndex];
            this.ringBuffer[this.headIndex] = null;
            if (this.size != 1) {
                this.headIndex = this.nextIndex(this.headIndex);
            }
            --this.size;
            ++this.modificationsCount;
            return result;
        };
        return (E)this.writeConcurrently(pollElement);
    }

    @Override
    public E peek() {
        return (E)this.readConcurrently(() -> {
            if (this.size == 0) {
                return null;
            }
            return this.ringBuffer[this.headIndex];
        });
    }

    @Override
    public void clear() {
        Supplier<Object> clearStrategy = () -> {
            if (this.size == 0) {
                return null;
            }
            Arrays.fill(this.ringBuffer, null);
            this.size = 0;
            this.headIndex = 0;
            this.tailIndex = 0;
            ++this.modificationsCount;
            return null;
        };
        this.writeConcurrently(clearStrategy);
    }

    @Override
    public Object[] toArray() {
        if (this.size == 0) {
            return new Object[0];
        }
        Object[] destination = this.toArray(DEFAULT_DESTINATION);
        return destination;
    }

    @Override
    public <T> T[] toArray(T[] destination) {
        Objects.requireNonNull(destination, ILLEGAL_DESTINATION_ARRAY);
        Supplier<Object[]> copyRingBuffer = () -> {
            if (this.size == 0) {
                return destination;
            }
            Object[] result = destination;
            if (destination.length < this.size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.size);
            }
            if (this.headIndex <= this.tailIndex) {
                System.arraycopy(this.ringBuffer, this.headIndex, result, 0, this.size);
            } else {
                int toTheEnd = this.ringBuffer.length - this.headIndex;
                System.arraycopy(this.ringBuffer, this.headIndex, result, 0, toTheEnd);
                System.arraycopy(this.ringBuffer, 0, result, toTheEnd, this.tailIndex + 1);
            }
            return result;
        };
        return this.readConcurrentlyWithoutSpin(copyRingBuffer);
    }

    private int nextIndex(int ringIndex) {
        return (ringIndex + 1) % this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readConcurrently(Supplier<T> readSupplier) {
        T result;
        long stamp;
        for (int i = 0; i < 5; ++i) {
            stamp = this.stampedLock.tryOptimisticRead();
            if (stamp == 0L) continue;
            result = readSupplier.get();
            if (!this.stampedLock.validate(stamp)) continue;
            return result;
        }
        stamp = this.stampedLock.readLock();
        try {
            result = readSupplier.get();
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readConcurrentlyWithoutSpin(Supplier<T> readSupplier) {
        T result;
        long stamp = this.stampedLock.readLock();
        try {
            result = readSupplier.get();
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T writeConcurrently(Supplier<T> writeSupplier) {
        T result;
        long stamp = this.stampedLock.writeLock();
        try {
            result = writeSupplier.get();
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
        return result;
    }

    private class Iter
    implements Iterator<E> {
        private int visitedCount = 0;
        private int cursor;
        private int expectedModificationsCount;

        Iter(int headIndex, int modificationsCount) {
            this.cursor = headIndex;
            this.expectedModificationsCount = modificationsCount;
        }

        @Override
        public boolean hasNext() {
            return this.visitedCount < ConcurrentEvictingQueue.this.size;
        }

        @Override
        public E next() {
            Supplier<Object> nextElement = () -> {
                this.checkForModification();
                if (this.visitedCount >= ConcurrentEvictingQueue.this.size) {
                    throw new NoSuchElementException();
                }
                Object item = ConcurrentEvictingQueue.this.ringBuffer[this.cursor];
                this.cursor = ConcurrentEvictingQueue.this.nextIndex(this.cursor);
                ++this.visitedCount;
                return item;
            };
            return ConcurrentEvictingQueue.this.readConcurrently(nextElement);
        }

        private void checkForModification() {
            if (ConcurrentEvictingQueue.this.modificationsCount != this.expectedModificationsCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

