/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventDTO;
import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="ratelimiterevents")
public class RateLimiterEventsEndpoint {
    private final EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry;

    public RateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getAllRateLimiterEvents() {
        return new RateLimiterEventsEndpointResponse(this.eventsConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterName(@Selector String name) {
        return new RateLimiterEventsEndpointResponse(this.getRateLimiterEvents(name).stream().map(RateLimiterEventDTO::createRateLimiterEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterNameAndEventType(@Selector String name, @Selector String eventType) {
        RateLimiterEvent.Type targetType = RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        return new RateLimiterEventsEndpointResponse(this.getRateLimiterEvents(name).stream().filter(event -> event.getEventType() == targetType).map(RateLimiterEventDTO::createRateLimiterEventDTO).collect(Collectors.toList()));
    }

    private List<RateLimiterEvent> getRateLimiterEvents(String name) {
        CircularEventConsumer eventConsumer = this.eventsConsumerRegistry.getEventConsumer(name);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEventsStream().filter(event -> event.getRateLimiterName().equals(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

