/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui.builder.example;

import io.github.smiley4.ktorswaggerui.builder.example.ExampleContext;
import io.github.smiley4.ktorswaggerui.builder.route.RouteMeta;
import io.github.smiley4.ktorswaggerui.data.ExampleConfigData;
import io.github.smiley4.ktorswaggerui.data.ExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.OpenApiBaseBodyData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestParameterData;
import io.github.smiley4.ktorswaggerui.data.OpenApiResponseData;
import io.github.smiley4.ktorswaggerui.data.OpenApiSimpleBodyData;
import io.github.smiley4.ktorswaggerui.data.RefExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.SwaggerExampleDescriptor;
import io.github.smiley4.ktorswaggerui.data.TypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.ValueExampleDescriptor;
import io.swagger.v3.oas.models.examples.Example;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001BM\u0012D\u0010\u0002\u001a@\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0003j\u0004\u0018\u0001`\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J(\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u001d0\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001a\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100#H\u0016RL\u0010\u0002\u001a@\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0003j\u0004\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl;", "Lio/github/smiley4/ktorswaggerui/builder/example/ExampleContext;", "encoder", "Lkotlin/Function2;", "Lio/github/smiley4/ktorswaggerui/data/TypeDescriptor;", "Lkotlin/ParameterName;", "name", "type", "", "example", "Lio/github/smiley4/ktorswaggerui/data/ExampleEncoder;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "rootExamples", "", "Lio/github/smiley4/ktorswaggerui/data/ExampleDescriptor;", "Lio/swagger/v3/oas/models/examples/Example;", "componentExamples", "", "addShared", "", "config", "Lio/github/smiley4/ktorswaggerui/data/ExampleConfigData;", "add", "routes", "", "Lio/github/smiley4/ktorswaggerui/builder/route/RouteMeta;", "collectExampleDescriptors", "", "Lkotlin/Pair;", "generateExample", "exampleDescriptor", "getExample", "descriptor", "getComponentSection", "", "ktor-swagger-ui"})
@SourceDebugExtension(value={"SMAP\nExampleContextImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExampleContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n216#2,2:104\n1863#3,2:106\n1863#3,2:108\n774#3:110\n865#3,2:111\n1863#3:113\n1863#3:114\n1864#3:116\n1557#3:117\n1628#3,3:118\n1863#3:121\n1557#3:122\n1628#3,3:123\n1864#3:126\n1864#3:127\n1#4:115\n*S KotlinDebug\n*F\n+ 1 ExampleContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/example/ExampleContextImpl\n*L\n20#1:104,2\n25#1:106,2\n37#1:108,2\n50#1:110\n50#1:111,2\n51#1:113\n53#1:114\n53#1:116\n58#1:117\n58#1:118,3\n62#1:121\n65#1:122\n65#1:123,3\n62#1:126\n51#1:127\n*E\n"})
public final class ExampleContextImpl
implements ExampleContext {
    @Nullable
    private final Function2<TypeDescriptor, Object, Object> encoder;
    @NotNull
    private final Map<ExampleDescriptor, Example> rootExamples;
    @NotNull
    private final Map<String, Example> componentExamples;

    public ExampleContextImpl(@Nullable Function2<? super TypeDescriptor, Object, ? extends Object> encoder) {
        this.encoder = encoder;
        this.rootExamples = new LinkedHashMap();
        this.componentExamples = new LinkedHashMap();
    }

    public final void addShared(@NotNull ExampleConfigData config) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Map<String, ExampleDescriptor> $this$forEach$iv = config.getSharedExamples();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ExampleDescriptor>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ExampleDescriptor> element$iv;
                Map.Entry<String, ExampleDescriptor> entry = element$iv = iterator.next();
                boolean bl = false;
                ExampleDescriptor exampleDescriptor = entry.getValue();
                Example example = this.generateExample(exampleDescriptor, null);
                this.componentExamples.put(exampleDescriptor.getName(), example);
            }
            OpenApiSimpleBodyData openApiSimpleBodyData = config.getSecurityExamples();
            if (openApiSimpleBodyData == null) break block2;
            OpenApiSimpleBodyData it = openApiSimpleBodyData;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getExamples();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ExampleDescriptor exampleDescriptor = (ExampleDescriptor)element$iv;
                boolean bl2 = false;
                Example example = this.generateExample(exampleDescriptor, it.getType());
                this.rootExamples.put(exampleDescriptor, example);
            }
        }
    }

    public final void add(@NotNull Collection<RouteMeta> routes) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Iterable $this$forEach$iv = this.collectExampleDescriptors(routes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ExampleDescriptor exampleDescriptor = (ExampleDescriptor)pair.component1();
            TypeDescriptor typeDescriptor = (TypeDescriptor)pair.component2();
            Example example = this.generateExample(exampleDescriptor, typeDescriptor);
            this.rootExamples.put(exampleDescriptor, example);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<ExampleDescriptor, TypeDescriptor>> collectExampleDescriptors(Collection<RouteMeta> routes) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        List $this$collectExampleDescriptors_u24lambda_u2414 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = routes;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RouteMeta it = (RouteMeta)element$iv$iv;
            boolean bl2 = false;
            if (!(!it.getDocumentation().getHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExampleDescriptor it;
            Object parameter;
            Object element$iv$iv;
            RouteMeta route = (RouteMeta)element$iv;
            boolean bl3 = false;
            Object request = element$iv$iv = route.getDocumentation().getRequest();
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = ((OpenApiRequestData)request).getParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ExampleDescriptor exampleDescriptor;
                parameter = (OpenApiRequestParameterData)element$iv2;
                boolean bl5 = false;
                if (((OpenApiRequestParameterData)parameter).getExample() == null) continue;
                it = exampleDescriptor;
                boolean bl6 = false;
                $this$collectExampleDescriptors_u24lambda_u2414.add(TuplesKt.to((Object)it, (Object)((OpenApiRequestParameterData)parameter).getType()));
            }
            if (((OpenApiRequestData)request).getBody() != null) {
                OpenApiBaseBodyData body2 = $i$f$forEach2;
                boolean bl7 = false;
                if (body2 instanceof OpenApiSimpleBodyData) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    parameter = ((OpenApiSimpleBodyData)body2).getExamples();
                    List bl5 = $this$collectExampleDescriptors_u24lambda_u2414;
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        ExampleDescriptor exampleDescriptor = (ExampleDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl8 = false;
                        collection.add(TuplesKt.to((Object)it2, (Object)((OpenApiSimpleBodyData)body2).getType()));
                    }
                    bl5.addAll((List)destination$iv$iv2);
                }
            }
            Iterable $this$forEach$iv3 = route.getDocumentation().getResponses();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                OpenApiBaseBodyData openApiBaseBodyData;
                OpenApiResponseData response = (OpenApiResponseData)element$iv3;
                boolean bl9 = false;
                if (response.getBody() == null) continue;
                OpenApiBaseBodyData body3 = openApiBaseBodyData;
                boolean bl10 = false;
                if (!(body3 instanceof OpenApiSimpleBodyData)) continue;
                Iterable $i$f$map = ((OpenApiSimpleBodyData)body3).getExamples();
                List list2 = $this$collectExampleDescriptors_u24lambda_u2414;
                boolean $i$f$map2 = false;
                void $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    ExampleDescriptor bl8 = (ExampleDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl11 = false;
                    collection.add(TuplesKt.to((Object)it3, (Object)((OpenApiSimpleBodyData)body3).getType()));
                }
                list2.addAll((List)destination$iv$iv3);
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final Example generateExample(ExampleDescriptor exampleDescriptor, TypeDescriptor type) {
        Example example;
        ExampleDescriptor exampleDescriptor2 = exampleDescriptor;
        if (exampleDescriptor2 instanceof ValueExampleDescriptor) {
            Example example2;
            Example it = example2 = new Example();
            boolean bl = false;
            it.setValue(this.encoder != null ? this.encoder.invoke((Object)type, ((ValueExampleDescriptor)exampleDescriptor).getValue()) : ((ValueExampleDescriptor)exampleDescriptor).getValue());
            it.setSummary(((ValueExampleDescriptor)exampleDescriptor).getSummary());
            it.setDescription(((ValueExampleDescriptor)exampleDescriptor).getDescription());
            example = example2;
        } else if (exampleDescriptor2 instanceof RefExampleDescriptor) {
            Example example3;
            Example it = example3 = new Example();
            boolean bl = false;
            it.set$ref("#/components/examples/" + ((RefExampleDescriptor)exampleDescriptor).getRefName());
            example = example3;
        } else if (exampleDescriptor2 instanceof SwaggerExampleDescriptor) {
            example = ((SwaggerExampleDescriptor)exampleDescriptor).getExample();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return example;
    }

    @Override
    @NotNull
    public Example getExample(@NotNull ExampleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Example example = this.rootExamples.get(descriptor);
        if (example == null) {
            throw new NoSuchElementException("no root-example for given example-descriptor");
        }
        return example;
    }

    @Override
    @NotNull
    public Map<String, Example> getComponentSection() {
        return this.componentExamples;
    }
}

