/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui.builder.openapi;

import io.github.smiley4.ktorswaggerui.builder.openapi.ResponseBuilder;
import io.github.smiley4.ktorswaggerui.data.OpenApiResponseData;
import io.github.smiley4.ktorswaggerui.data.PluginConfigData;
import io.ktor.http.HttpStatusCode;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/smiley4/ktorswaggerui/builder/openapi/ResponsesBuilder;", "", "responseBuilder", "Lio/github/smiley4/ktorswaggerui/builder/openapi/ResponseBuilder;", "config", "Lio/github/smiley4/ktorswaggerui/data/PluginConfigData;", "<init>", "(Lio/github/smiley4/ktorswaggerui/builder/openapi/ResponseBuilder;Lio/github/smiley4/ktorswaggerui/data/PluginConfigData;)V", "build", "Lio/swagger/v3/oas/models/responses/ApiResponses;", "responses", "", "Lio/github/smiley4/ktorswaggerui/data/OpenApiResponseData;", "isProtected", "", "shouldAddUnauthorized", "ktor-swagger-ui"})
@SourceDebugExtension(value={"SMAP\nResponsesBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponsesBuilder.kt\nio/github/smiley4/ktorswaggerui/builder/openapi/ResponsesBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1557#2:38\n1628#2,3:39\n1863#2,2:42\n1782#2,4:45\n1#3:44\n*S KotlinDebug\n*F\n+ 1 ResponsesBuilder.kt\nio/github/smiley4/ktorswaggerui/builder/openapi/ResponsesBuilder\n*L\n20#1:38\n20#1:39,3\n21#1:42,2\n33#1:45,4\n*E\n"})
public final class ResponsesBuilder {
    @NotNull
    private final ResponseBuilder responseBuilder;
    @NotNull
    private final PluginConfigData config;

    public ResponsesBuilder(@NotNull ResponseBuilder responseBuilder, @NotNull PluginConfigData config) {
        Intrinsics.checkNotNullParameter((Object)responseBuilder, (String)"responseBuilder");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.responseBuilder = responseBuilder;
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ApiResponses build(@NotNull List<OpenApiResponseData> responses, boolean isProtected) {
        ApiResponses apiResponses;
        block3: {
            void $this$forEach$iv;
            ApiResponse response;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(responses, (String)"responses");
            ApiResponses it = apiResponses = new ApiResponses();
            boolean bl = false;
            Object object = responses;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OpenApiResponseData openApiResponseData = (OpenApiResponseData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.responseBuilder.build((OpenApiResponseData)response));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                Pair $i$f$mapTo2 = (Pair)element$iv;
                boolean bl3 = false;
                String name = (String)$i$f$mapTo2.component1();
                response = (ApiResponse)$i$f$mapTo2.component2();
                it.addApiResponse(name, response);
            }
            if (!this.shouldAddUnauthorized(responses, isProtected) || (object = this.config.getSecurityConfig().getDefaultUnauthorizedResponse()) == null) break block3;
            Object response2 = object;
            boolean bl4 = false;
            Pair<String, ApiResponse> pair = this.responseBuilder.build((OpenApiResponseData)response2);
            if (pair != null) {
                Iterator iterator2 = iterator = pair;
                boolean bl5 = false;
                String name = (String)iterator2.component1();
                ApiResponse response3 = (ApiResponse)iterator2.component2();
                it.addApiResponse(name, response3);
            }
        }
        return apiResponses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAddUnauthorized(List<OpenApiResponseData> responses, boolean isProtected) {
        String unauthorizedCode = String.valueOf(HttpStatusCode.Companion.getUnauthorized().getValue());
        if (this.config.getSecurityConfig().getDefaultUnauthorizedResponse() == null) return false;
        if (!isProtected) return false;
        Iterable $this$count$iv = responses;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            return true;
        }
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            OpenApiResponseData it = (OpenApiResponseData)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getStatusCode(), (Object)unauthorizedCode) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n = count$iv;
        if (n != 0) return false;
        return true;
    }
}

