/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.ktorswaggerui.builder.schema;

import io.github.smiley4.ktorswaggerui.builder.route.RouteMeta;
import io.github.smiley4.ktorswaggerui.builder.schema.SchemaContext;
import io.github.smiley4.ktorswaggerui.data.AnyOfTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.ArrayTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.EmptyTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.KTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.OpenApiBaseBodyData;
import io.github.smiley4.ktorswaggerui.data.OpenApiHeaderData;
import io.github.smiley4.ktorswaggerui.data.OpenApiMultipartBodyData;
import io.github.smiley4.ktorswaggerui.data.OpenApiMultipartPartData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestData;
import io.github.smiley4.ktorswaggerui.data.OpenApiRequestParameterData;
import io.github.smiley4.ktorswaggerui.data.OpenApiResponseData;
import io.github.smiley4.ktorswaggerui.data.OpenApiSimpleBodyData;
import io.github.smiley4.ktorswaggerui.data.RefTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.SchemaConfigData;
import io.github.smiley4.ktorswaggerui.data.SwaggerTypeDescriptor;
import io.github.smiley4.ktorswaggerui.data.TypeDescriptor;
import io.github.smiley4.schemakenerator.core.data.BaseTypeData;
import io.github.smiley4.schemakenerator.core.data.WildcardTypeData;
import io.github.smiley4.schemakenerator.swagger.data.CompiledSwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u0014\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/smiley4/ktorswaggerui/builder/schema/SchemaContextImpl;", "Lio/github/smiley4/ktorswaggerui/builder/schema/SchemaContext;", "schemaConfig", "Lio/github/smiley4/ktorswaggerui/data/SchemaConfigData;", "<init>", "(Lio/github/smiley4/ktorswaggerui/data/SchemaConfigData;)V", "rootSchemas", "", "Lio/github/smiley4/ktorswaggerui/data/TypeDescriptor;", "Lio/swagger/v3/oas/models/media/Schema;", "componentSchemas", "", "addGlobal", "", "config", "add", "routes", "", "Lio/github/smiley4/ktorswaggerui/builder/route/RouteMeta;", "generateSchema", "Lio/github/smiley4/schemakenerator/swagger/data/CompiledSwaggerSchema;", "typeDescriptor", "type", "Lkotlin/reflect/KType;", "collectTypeDescriptor", "", "getSchema", "getComponentSection", "", "ktor-swagger-ui"})
@SourceDebugExtension(value={"SMAP\nSchemaContextImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/schema/SchemaContextImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1863#2:162\n1864#2:165\n1863#2:170\n1864#2:173\n1557#2:174\n1628#2,3:175\n1557#2:178\n1628#2,3:179\n1863#2,2:182\n774#2:184\n865#2,2:185\n1863#2:187\n1863#2,2:188\n1863#2:190\n1864#2:194\n1863#2:195\n1863#2,2:198\n1864#2:200\n1864#2:201\n216#3,2:163\n216#3:166\n216#3,2:167\n217#3:169\n216#3,2:171\n216#3:191\n217#3:193\n216#3,2:196\n1#4:192\n*S KotlinDebug\n*F\n+ 1 SchemaContextImpl.kt\nio/github/smiley4/ktorswaggerui/builder/schema/SchemaContextImpl\n*L\n17#1:162\n17#1:165\n34#1:170\n34#1:173\n70#1:174\n70#1:175,3\n74#1:178\n74#1:179,3\n79#1:182,2\n109#1:184\n109#1:185,2\n110#1:187\n112#1:188,2\n121#1:190\n121#1:194\n131#1:195\n141#1:198,2\n131#1:200\n110#1:201\n20#1:163,2\n24#1:166\n27#1:167,2\n24#1:169\n37#1:171,2\n123#1:191\n123#1:193\n132#1:196,2\n*E\n"})
public final class SchemaContextImpl
implements SchemaContext {
    @NotNull
    private final SchemaConfigData schemaConfig;
    @NotNull
    private final Map<TypeDescriptor, Schema<?>> rootSchemas;
    @NotNull
    private final Map<String, Schema<?>> componentSchemas;

    public SchemaContextImpl(@NotNull SchemaConfigData schemaConfig) {
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        this.schemaConfig = schemaConfig;
        this.rootSchemas = new LinkedHashMap();
        this.componentSchemas = new LinkedHashMap();
    }

    public final void addGlobal(@NotNull SchemaConfigData config) {
        Object object;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object $this$forEach$iv = config.getSecuritySchemas();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            TypeDescriptor typeDescriptor = (TypeDescriptor)element$iv;
            boolean bl = false;
            CompiledSwaggerSchema schema = this.generateSchema(typeDescriptor);
            this.rootSchemas.put(typeDescriptor, schema.getSwagger());
            Map $this$forEach$iv2 = schema.getComponentSchemas();
            boolean $i$f$forEach2 = false;
            for (Map.Entry element$iv2 : $this$forEach$iv2.entrySet()) {
                object = element$iv2;
                boolean bl2 = false;
                String k = (String)object.getKey();
                Schema v = (Schema)object.getValue();
                this.componentSchemas.put(k, v);
            }
        }
        $this$forEach$iv = config.getSchemas();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String schemaId = (String)object2.getKey();
            TypeDescriptor typeDescriptor = (TypeDescriptor)object2.getValue();
            CompiledSwaggerSchema schema = this.generateSchema(typeDescriptor);
            this.componentSchemas.put(schemaId, schema.getSwagger());
            Map $this$forEach$iv3 = schema.getComponentSchemas();
            boolean $i$f$forEach3 = false;
            object = $this$forEach$iv3.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = (Map.Entry)object.next();
                boolean bl3 = false;
                String k = (String)entry.getKey();
                Schema v = (Schema)entry.getValue();
                this.componentSchemas.put(k, v);
            }
        }
    }

    public final void add(@NotNull Collection<RouteMeta> routes) {
        Intrinsics.checkNotNullParameter(routes, (String)"routes");
        Iterable $this$forEach$iv = this.collectTypeDescriptor(routes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeDescriptor typeDescriptor = (TypeDescriptor)element$iv;
            boolean bl = false;
            CompiledSwaggerSchema schema = this.generateSchema(typeDescriptor);
            this.rootSchemas.put(typeDescriptor, schema.getSwagger());
            Map $this$forEach$iv2 = schema.getComponentSchemas();
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator.next();
                boolean bl2 = false;
                String k = (String)entry.getKey();
                Schema v = (Schema)entry.getValue();
                this.componentSchemas.put(k, v);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompiledSwaggerSchema generateSchema(TypeDescriptor typeDescriptor) {
        CompiledSwaggerSchema compiledSwaggerSchema;
        TypeDescriptor typeDescriptor2 = typeDescriptor;
        if (typeDescriptor2 instanceof KTypeDescriptor) {
            if (this.schemaConfig.getOverwrite().containsKey(((KTypeDescriptor)typeDescriptor).getType())) {
                TypeDescriptor typeDescriptor3 = this.schemaConfig.getOverwrite().get(((KTypeDescriptor)typeDescriptor).getType());
                Intrinsics.checkNotNull((Object)typeDescriptor3);
                compiledSwaggerSchema = this.generateSchema(typeDescriptor3);
            } else {
                compiledSwaggerSchema = this.generateSchema(((KTypeDescriptor)typeDescriptor).getType());
            }
        } else if (typeDescriptor2 instanceof SwaggerTypeDescriptor) {
            compiledSwaggerSchema = new CompiledSwaggerSchema((BaseTypeData)new WildcardTypeData(), ((SwaggerTypeDescriptor)typeDescriptor).getSchema(), MapsKt.emptyMap());
        } else if (typeDescriptor2 instanceof ArrayTypeDescriptor) {
            CompiledSwaggerSchema itemSchema = this.generateSchema(((ArrayTypeDescriptor)typeDescriptor).getType());
            compiledSwaggerSchema = new CompiledSwaggerSchema((BaseTypeData)new WildcardTypeData(), SwaggerSchemaUtils.arraySchema$default((SwaggerSchemaUtils)new SwaggerSchemaUtils(), (Schema)itemSchema.getSwagger(), (boolean)false, (int)2, null), itemSchema.getComponentSchemas());
        } else if (typeDescriptor2 instanceof AnyOfTypeDescriptor) {
            Map map;
            Collection<Schema> collection;
            CompiledSwaggerSchema it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((AnyOfTypeDescriptor)typeDescriptor).getTypes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TypeDescriptor typeDescriptor4 = (TypeDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.generateSchema((TypeDescriptor)it));
            }
            List optionSchemas = (List)destination$iv$iv;
            $this$map$iv = optionSchemas;
            SwaggerSchemaUtils swaggerSchemaUtils = new SwaggerSchemaUtils();
            BaseTypeData baseTypeData = (BaseTypeData)new WildcardTypeData();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (CompiledSwaggerSchema)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSwagger());
            }
            collection = (List)destination$iv$iv;
            Map $i$f$map2 = map = MapsKt.createMapBuilder();
            swaggerSchemaUtils = swaggerSchemaUtils.subtypesSchema((List)collection, null, MapsKt.emptyMap());
            boolean bl = false;
            Iterable $this$forEach$iv = optionSchemas;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$generateSchema_u24lambda_u249;
                CompiledSwaggerSchema optionSchema = (CompiledSwaggerSchema)element$iv;
                boolean bl2 = false;
                $this$generateSchema_u24lambda_u249.putAll(optionSchema.getComponentSchemas());
            }
            collection = Unit.INSTANCE;
            Map map2 = MapsKt.build((Map)map);
            SwaggerSchemaUtils swaggerSchemaUtils2 = swaggerSchemaUtils;
            BaseTypeData baseTypeData2 = baseTypeData;
            compiledSwaggerSchema = new CompiledSwaggerSchema(baseTypeData2, (Schema)swaggerSchemaUtils2, map2);
        } else if (typeDescriptor2 instanceof EmptyTypeDescriptor) {
            compiledSwaggerSchema = new CompiledSwaggerSchema((BaseTypeData)new WildcardTypeData(), new SwaggerSchemaUtils().anyObjectSchema(), MapsKt.emptyMap());
        } else if (typeDescriptor2 instanceof RefTypeDescriptor) {
            compiledSwaggerSchema = new CompiledSwaggerSchema((BaseTypeData)new WildcardTypeData(), new SwaggerSchemaUtils().referenceSchema(((RefTypeDescriptor)typeDescriptor).getSchemaId(), true), MapsKt.emptyMap());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compiledSwaggerSchema;
    }

    private final CompiledSwaggerSchema generateSchema(KType type) {
        return (CompiledSwaggerSchema)this.schemaConfig.getGenerator().invoke((Object)type);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeDescriptor> collectTypeDescriptor(Collection<RouteMeta> routes) {
        void $this$filterTo$iv$iv;
        List descriptors = new ArrayList();
        Iterable $this$filter$iv = routes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RouteMeta it = (RouteMeta)element$iv$iv;
            boolean bl = false;
            if (!(!it.getDocumentation().getHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object parameter;
            Object element$iv$iv;
            RouteMeta route = (RouteMeta)element$iv;
            boolean bl = false;
            Object request = element$iv$iv = route.getDocumentation().getRequest();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = ((OpenApiRequestData)request).getParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                parameter = (OpenApiRequestParameterData)element$iv2;
                boolean bl3 = false;
                descriptors.add(((OpenApiRequestParameterData)parameter).getType());
            }
            if (((OpenApiRequestData)request).getBody() != null) {
                OpenApiBaseBodyData body2 = $i$f$forEach2;
                boolean bl4 = false;
                parameter = body2;
                if (parameter instanceof OpenApiSimpleBodyData) {
                    descriptors.add(((OpenApiSimpleBodyData)body2).getType());
                } else if (parameter instanceof OpenApiMultipartBodyData) {
                    Iterable $this$forEach$iv3 = ((OpenApiMultipartBodyData)body2).getParts();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        OpenApiMultipartPartData part2 = (OpenApiMultipartPartData)element$iv3;
                        boolean bl5 = false;
                        descriptors.add(part2.getType());
                        Map<String, OpenApiHeaderData> $this$forEach$iv4 = part2.getHeaders();
                        boolean $i$f$forEach4 = false;
                        Iterator<Map.Entry<String, OpenApiHeaderData>> iterator = $this$forEach$iv4.entrySet().iterator();
                        while (iterator.hasNext()) {
                            TypeDescriptor typeDescriptor;
                            Map.Entry<String, OpenApiHeaderData> element$iv4;
                            Map.Entry<String, OpenApiHeaderData> entry = element$iv4 = iterator.next();
                            boolean bl6 = false;
                            OpenApiHeaderData header2 = entry.getValue();
                            if (header2.getType() == null) continue;
                            TypeDescriptor it = typeDescriptor;
                            boolean bl7 = false;
                            descriptors.add(it);
                        }
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable $this$forEach$iv5 = route.getDocumentation().getResponses();
            boolean $i$f$forEach5 = false;
            for (Object element$iv5 : $this$forEach$iv5) {
                OpenApiBaseBodyData openApiBaseBodyData;
                Iterator iterator;
                Object object;
                OpenApiResponseData response = (OpenApiResponseData)element$iv5;
                boolean bl8 = false;
                Map<String, OpenApiHeaderData> $this$forEach$iv6 = response.getHeaders();
                boolean $i$f$forEach6 = false;
                for (Map.Entry<String, OpenApiHeaderData> element$iv6 : $this$forEach$iv6.entrySet()) {
                    object = element$iv6;
                    boolean bl9 = false;
                    OpenApiHeaderData header3 = (OpenApiHeaderData)object.getValue();
                    if (header3.getType() == null) continue;
                    TypeDescriptor it = iterator;
                    boolean bl10 = false;
                    descriptors.add(it);
                }
                if (response.getBody() == null) continue;
                OpenApiBaseBodyData body3 = openApiBaseBodyData;
                boolean bl11 = false;
                object = body3;
                if (object instanceof OpenApiSimpleBodyData) {
                    descriptors.add(((OpenApiSimpleBodyData)body3).getType());
                    continue;
                }
                if (object instanceof OpenApiMultipartBodyData) {
                    Iterable $this$forEach$iv7 = ((OpenApiMultipartBodyData)body3).getParts();
                    boolean $i$f$forEach7 = false;
                    iterator = $this$forEach$iv7.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv7 = iterator.next();
                        OpenApiMultipartPartData part3 = (OpenApiMultipartPartData)element$iv7;
                        boolean bl12 = false;
                        descriptors.add(part3.getType());
                    }
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return descriptors;
    }

    @Override
    @NotNull
    public Schema<?> getSchema(@NotNull TypeDescriptor typeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)typeDescriptor, (String)"typeDescriptor");
        Schema<?> schema = this.rootSchemas.get(typeDescriptor);
        if (schema == null) {
            throw new NoSuchElementException("no root-schema for given type-descriptor");
        }
        return schema;
    }

    @Override
    @NotNull
    public Map<String, Schema<?>> getComponentSection() {
        return this.componentSchemas;
    }
}

