/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.swagger.steps;

import io.github.smiley4.schemakenerator.core.data.BaseTypeData;
import io.github.smiley4.schemakenerator.core.data.Bundle;
import io.github.smiley4.schemakenerator.core.data.BundleKt;
import io.github.smiley4.schemakenerator.core.data.TypeId;
import io.github.smiley4.schemakenerator.swagger.data.CompiledSwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.data.SwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaCompileUtils;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaUtils;
import io.github.smiley4.schemakenerator.swagger.steps.UtilsKt;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001BK\u0012B\u0010\u0002\u001a>\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013JR\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u001cH\u0002J@\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00162\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u001c2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0002J(\u0010\u001d\u001a\u00020\u001e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010\u0014*\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010$\u001a\u00020\tH\u0002RJ\u0010\u0002\u001a>\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileReferenceStep;", "", "pathBuilder", "Lkotlin/Function2;", "Lio/github/smiley4/schemakenerator/core/data/BaseTypeData;", "Lkotlin/ParameterName;", "name", "type", "", "Lio/github/smiley4/schemakenerator/core/data/TypeId;", "types", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "schemaUtils", "Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaUtils;", "compile", "Lio/github/smiley4/schemakenerator/swagger/data/CompiledSwaggerSchema;", "bundle", "Lio/github/smiley4/schemakenerator/core/data/Bundle;", "Lio/github/smiley4/schemakenerator/swagger/data/SwaggerSchema;", "resolve", "Lio/swagger/v3/oas/models/media/Schema;", "refObj", "schemaList", "", "typeDataMap", "components", "", "handleDiscriminatorMappings", "", "root", "swaggerSchema", "placeholder", "find", "", "id", "schema-kenerator-swagger"})
@SourceDebugExtension(value={"SMAP\nSwaggerSchemaCompileReferenceStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerSchemaCompileReferenceStep.kt\nio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileReferenceStep\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n216#2,2:111\n462#3:113\n412#3:114\n1246#4,4:115\n1#5:119\n*S KotlinDebug\n*F\n+ 1 SwaggerSchemaCompileReferenceStep.kt\nio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileReferenceStep\n*L\n89#1:111,2\n96#1:113\n96#1:114\n96#1:115,4\n*E\n"})
public final class SwaggerSchemaCompileReferenceStep {
    @NotNull
    private final Function2<BaseTypeData, Map<TypeId, ? extends BaseTypeData>, String> pathBuilder;
    @NotNull
    private final SwaggerSchemaUtils schemaUtils;

    public SwaggerSchemaCompileReferenceStep(@NotNull Function2<? super BaseTypeData, ? super Map<TypeId, ? extends BaseTypeData>, String> pathBuilder) {
        Intrinsics.checkNotNullParameter(pathBuilder, (String)"pathBuilder");
        this.pathBuilder = pathBuilder;
        this.schemaUtils = new SwaggerSchemaUtils();
    }

    @NotNull
    public final CompiledSwaggerSchema compile(@NotNull Bundle<SwaggerSchema> bundle) {
        Intrinsics.checkNotNullParameter(bundle, (String)"bundle");
        List schemaList = BundleKt.flatten(bundle);
        Map<TypeId, BaseTypeData> typeDataMap = UtilsKt.buildTypeDataMap(bundle);
        Map components = new LinkedHashMap();
        SwaggerSchemaCompileUtils.INSTANCE.copyTypeToTypes(schemaList);
        Schema root = SwaggerSchemaCompileUtils.resolveReferences$default(SwaggerSchemaCompileUtils.INSTANCE, ((SwaggerSchema)bundle.getData()).getSwagger(), 0, arg_0 -> SwaggerSchemaCompileReferenceStep.compile$lambda$0(this, schemaList, typeDataMap, components, arg_0), 2, null);
        this.handleDiscriminatorMappings(root, components, typeDataMap);
        return new CompiledSwaggerSchema(((SwaggerSchema)bundle.getData()).getTypeData(), root, components);
    }

    private final Schema<?> resolve(Schema<?> refObj, List<SwaggerSchema> schemaList, Map<TypeId, ? extends BaseTypeData> typeDataMap, Map<String, Schema<?>> components) {
        Schema<?> schema;
        String string = refObj.get$ref();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get$ref(...)");
        TypeId referencedId = TypeId.Companion.parse(string);
        SwaggerSchema referencedSchema = this.find((Collection<SwaggerSchema>)schemaList, referencedId);
        if (referencedSchema != null) {
            if (SwaggerSchemaCompileUtils.INSTANCE.shouldReference(referencedSchema.getSwagger())) {
                String refPath = (String)this.pathBuilder.invoke((Object)referencedSchema.getTypeData(), typeDataMap);
                if (!components.containsKey(refPath)) {
                    components.put(refPath, this.placeholder());
                    components.put(refPath, SwaggerSchemaCompileUtils.resolveReferences$default(SwaggerSchemaCompileUtils.INSTANCE, referencedSchema.getSwagger(), 0, arg_0 -> SwaggerSchemaCompileReferenceStep.resolve$lambda$1(this, schemaList, typeDataMap, components, arg_0), 2, null));
                }
                schema = Intrinsics.areEqual((Object)refObj.getNullable(), (Object)true) ? this.schemaUtils.referenceSchemaNullable(refPath, true) : this.schemaUtils.referenceSchema(refPath, true);
            } else {
                Schema<?> schema2;
                Schema<?> it = schema2 = SwaggerSchemaCompileUtils.INSTANCE.merge(refObj, referencedSchema.getSwagger());
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getNullable(), (Object)true)) {
                    it.setNullable(null);
                    Set set = SetsKt.setOf((Object)"null");
                    Set set2 = it.getTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getTypes(...)");
                    it.setTypes(SetsKt.plus((Set)set, (Iterable)set2));
                }
                if (Intrinsics.areEqual((Object)it.getNullable(), (Object)false)) {
                    it.setNullable(null);
                }
                schema = schema2;
            }
        } else {
            schema = refObj;
        }
        return schema;
    }

    private final void handleDiscriminatorMappings(Schema<?> root, Map<String, Schema<?>> components, Map<TypeId, ? extends BaseTypeData> typeDataMap) {
        this.handleDiscriminatorMappings(root, typeDataMap);
        Map<String, Schema<?>> $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Schema<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Schema<?>> element$iv;
            Map.Entry<String, Schema<?>> entry = element$iv = iterator.next();
            boolean bl = false;
            Schema<?> schema = entry.getValue();
            this.handleDiscriminatorMappings(schema, typeDataMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleDiscriminatorMappings(Schema<?> swaggerSchema, Map<TypeId, ? extends BaseTypeData> typeDataMap) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Discriminator discriminator = swaggerSchema.getDiscriminator();
        if ((discriminator != null ? discriminator.getMapping() : null) == null) {
            return;
        }
        Discriminator discriminator2 = swaggerSchema.getDiscriminator();
        Map map = swaggerSchema.getDiscriminator().getMapping();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMapping(...)");
        Map map2 = map;
        Discriminator discriminator3 = discriminator2;
        boolean $i$f$mapValues = false;
        void var5_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            BaseTypeData referencedType;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String target = (String)entry2.getValue();
            Intrinsics.checkNotNull((Object)target);
            TypeId referencedId = TypeId.Companion.parse(target);
            Intrinsics.checkNotNull((Object)typeDataMap.get(referencedId));
            String string = this.schemaUtils.componentReference((String)this.pathBuilder.invoke((Object)referencedType, typeDataMap));
            map4.put(k, string);
        }
        discriminator3.setMapping(destination$iv$iv);
    }

    private final Schema<Object> placeholder() {
        return new Schema();
    }

    private final SwaggerSchema find(Collection<SwaggerSchema> $this$find, TypeId id) {
        Object v0;
        block1: {
            Iterable iterable = $this$find;
            for (Object t : iterable) {
                SwaggerSchema it = (SwaggerSchema)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTypeData().getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Schema compile$lambda$0(SwaggerSchemaCompileReferenceStep this$0, List $schemaList, Map $typeDataMap, Map $components, Schema refObj) {
        Intrinsics.checkNotNullParameter((Object)refObj, (String)"refObj");
        return this$0.resolve(refObj, $schemaList, $typeDataMap, $components);
    }

    private static final Schema resolve$lambda$1(SwaggerSchemaCompileReferenceStep this$0, List $schemaList, Map $typeDataMap, Map $components, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.resolve(it, $schemaList, $typeDataMap, $components);
    }
}

