/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.baggage;

import io.jaegertracing.baggage.BaggageRestrictionManager;
import io.jaegertracing.baggage.BaggageRestrictionManagerProxy;
import io.jaegertracing.baggage.Restriction;
import io.jaegertracing.baggage.http.BaggageRestrictionResponse;
import io.jaegertracing.exceptions.BaggageRestrictionManagerException;
import io.jaegertracing.metrics.Metrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RemoteBaggageRestrictionManager
implements BaggageRestrictionManager {
    private static final int DEFAULT_REFRESH_INTERVAL_MS = 60000;
    private static final int DEFAULT_INITIAL_DELAY_MS = 0;
    private final String serviceName;
    private final BaggageRestrictionManagerProxy proxy;
    private final Timer pollTimer;
    private final Metrics metrics;
    private final boolean denyBaggageOnInitializationFailure;
    private volatile boolean initialized;
    private volatile Map<String, Restriction> restrictions = new HashMap<String, Restriction>();
    private final Restriction invalidRestriction;
    private final Restriction validRestriction;

    public RemoteBaggageRestrictionManager(String serviceName, BaggageRestrictionManagerProxy proxy, Metrics metrics, boolean denyBaggageOnInitializationFailure) {
        this(serviceName, proxy, metrics, denyBaggageOnInitializationFailure, 60000);
    }

    public RemoteBaggageRestrictionManager(String serviceName, BaggageRestrictionManagerProxy proxy, Metrics metrics, boolean denyBaggageOnInitializationFailure, int refreshIntervalMs) {
        this(serviceName, proxy, metrics, denyBaggageOnInitializationFailure, refreshIntervalMs, 0);
    }

    RemoteBaggageRestrictionManager(String serviceName, BaggageRestrictionManagerProxy proxy, Metrics metrics, boolean denyBaggageOnInitializationFailure, int refreshIntervalMs, int initialDelayMs) {
        this.serviceName = serviceName;
        this.proxy = proxy;
        this.metrics = metrics;
        this.denyBaggageOnInitializationFailure = denyBaggageOnInitializationFailure;
        this.initialized = false;
        this.invalidRestriction = Restriction.of(false, 0);
        this.validRestriction = Restriction.of(true, 2048);
        this.pollTimer = new Timer(true);
        this.pollTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteBaggageRestrictionManager.this.updateBaggageRestrictions();
            }
        }, initialDelayMs, (long)refreshIntervalMs);
    }

    public boolean isReady() {
        return this.initialized;
    }

    void updateBaggageRestrictions() {
        List<BaggageRestrictionResponse> response;
        try {
            response = this.proxy.getBaggageRestrictions(this.serviceName);
        }
        catch (BaggageRestrictionManagerException e) {
            this.metrics.baggageRestrictionsUpdateFailure.inc(1L);
            return;
        }
        this.updateBaggageRestrictions(response);
        this.metrics.baggageRestrictionsUpdateSuccess.inc(1L);
    }

    private void updateBaggageRestrictions(List<BaggageRestrictionResponse> restrictions) {
        HashMap<String, Restriction> baggageRestrictions = new HashMap<String, Restriction>();
        for (BaggageRestrictionResponse restriction : restrictions) {
            baggageRestrictions.put(restriction.getBaggageKey(), Restriction.of(true, restriction.getMaxValueLength()));
        }
        this.restrictions = baggageRestrictions;
        this.initialized = true;
    }

    public void close() {
        this.pollTimer.cancel();
    }

    @Override
    public Restriction getRestriction(String service, String key) {
        if (!this.initialized) {
            if (this.denyBaggageOnInitializationFailure) {
                return this.invalidRestriction;
            }
            return this.validRestriction;
        }
        Restriction restriction = this.restrictions.get(key);
        if (restriction != null) {
            return restriction;
        }
        return this.invalidRestriction;
    }
}

