/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.propagation;

import io.jaegertracing.SpanContext;
import io.jaegertracing.propagation.Codec;
import io.jaegertracing.propagation.HexCodec;
import io.opentracing.propagation.TextMap;
import java.util.Map;

public class B3TextMapCodec
implements Codec<TextMap> {
    protected static final String TRACE_ID_NAME = "X-B3-TraceId";
    protected static final String SPAN_ID_NAME = "X-B3-SpanId";
    protected static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    protected static final String SAMPLED_NAME = "X-B3-Sampled";
    protected static final String FLAGS_NAME = "X-B3-Flags";
    protected static final byte SAMPLED_FLAG = 1;
    protected static final byte DEBUG_FLAG = 2;

    @Override
    public void inject(SpanContext spanContext, TextMap carrier) {
        carrier.put(TRACE_ID_NAME, HexCodec.toLowerHex(spanContext.getTraceId()));
        if (spanContext.getParentId() != 0L) {
            carrier.put(PARENT_SPAN_ID_NAME, HexCodec.toLowerHex(spanContext.getParentId()));
        }
        carrier.put(SPAN_ID_NAME, HexCodec.toLowerHex(spanContext.getSpanId()));
        carrier.put(SAMPLED_NAME, spanContext.isSampled() ? "1" : "0");
        if (spanContext.isDebug()) {
            carrier.put(FLAGS_NAME, "1");
        }
    }

    @Override
    public SpanContext extract(TextMap carrier) {
        Long traceId = null;
        Long spanId = null;
        Long parentId = 0L;
        byte flags = 0;
        for (Map.Entry entry : carrier) {
            if (((String)entry.getKey()).equalsIgnoreCase(SAMPLED_NAME)) {
                String value = (String)entry.getValue();
                if (!"1".equals(value) && !"true".equalsIgnoreCase(value)) continue;
                flags = (byte)(flags | 1);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase(TRACE_ID_NAME)) {
                traceId = HexCodec.lowerHexToUnsignedLong((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase(PARENT_SPAN_ID_NAME)) {
                parentId = HexCodec.lowerHexToUnsignedLong((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase(SPAN_ID_NAME)) {
                spanId = HexCodec.lowerHexToUnsignedLong((String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equalsIgnoreCase(FLAGS_NAME) || !((String)entry.getValue()).equals("1")) continue;
            flags = (byte)(flags | 2);
        }
        if (null != traceId && null != parentId && null != spanId) {
            return new SpanContext(traceId, spanId, parentId, flags);
        }
        return null;
    }
}

