/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.samplers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.jaegertracing.exceptions.SamplingStrategyErrorException;
import io.jaegertracing.samplers.SamplingManager;
import io.jaegertracing.samplers.http.SamplingStrategyResponse;
import io.jaegertracing.utils.Http;
import java.io.IOException;
import java.net.URLEncoder;

public class HttpSamplingManager
implements SamplingManager {
    public static final String DEFAULT_HOST_PORT = "localhost:5778";
    private final Gson gson = new Gson();
    private final String hostPort;

    public HttpSamplingManager() {
        this(DEFAULT_HOST_PORT);
    }

    public HttpSamplingManager(String hostPort) {
        this.hostPort = hostPort != null ? hostPort : DEFAULT_HOST_PORT;
    }

    SamplingStrategyResponse parseJson(String json) {
        try {
            return (SamplingStrategyResponse)this.gson.fromJson(json, SamplingStrategyResponse.class);
        }
        catch (JsonSyntaxException e) {
            throw new SamplingStrategyErrorException("Cannot deserialize json", e);
        }
    }

    @Override
    public SamplingStrategyResponse getSamplingStrategy(String serviceName) throws SamplingStrategyErrorException {
        String jsonString;
        try {
            jsonString = Http.makeGetRequest("http://" + this.hostPort + "/?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new SamplingStrategyErrorException("http call to get sampling strategy from local agent failed.", e);
        }
        return this.parseJson(jsonString);
    }

    public String toString() {
        return "HttpSamplingManager(gson=" + this.gson + ", hostPort=" + this.hostPort + ")";
    }
}

