/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.senders;

import io.jaegertracing.agent.thrift.Agent;
import io.jaegertracing.exceptions.SenderException;
import io.jaegertracing.senders.ThriftSender;
import io.jaegertracing.thrift.reporters.protocols.ThriftUdpTransport;
import io.jaegertracing.thrift.senders.ThriftSenderBase;
import io.jaegertracing.thriftjava.Batch;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Span;
import java.util.List;
import org.apache.thrift.transport.TTransport;

public class UdpSender
extends ThriftSender {
    public static final String DEFAULT_AGENT_UDP_HOST = "localhost";
    public static final int DEFAULT_AGENT_UDP_COMPACT_PORT = 6831;
    private Agent.Client agentClient;
    private ThriftUdpTransport udpTransport;

    public UdpSender() {
        this(DEFAULT_AGENT_UDP_HOST, 6831, 0);
    }

    public UdpSender(String host, int port, int maxPacketSize) {
        super(ThriftSenderBase.ProtocolType.Compact, maxPacketSize);
        if (host == null || host.length() == 0) {
            host = DEFAULT_AGENT_UDP_HOST;
        }
        if (port == 0) {
            port = 6831;
        }
        this.udpTransport = ThriftUdpTransport.newThriftUdpClient((String)host, (int)port);
        this.agentClient = new Agent.Client(this.protocolFactory.getProtocol((TTransport)this.udpTransport));
    }

    @Override
    public void send(Process process, List<Span> spans) throws SenderException {
        try {
            this.agentClient.emitBatch(new Batch(process, spans));
        }
        catch (Exception e) {
            throw new SenderException(String.format("Could not send %d spans", spans.size()), e, spans.size());
        }
    }

    @Override
    public int close() throws SenderException {
        try {
            int n = super.close();
            return n;
        }
        finally {
            this.udpTransport.close();
        }
    }

    @Override
    public String toString() {
        return "UdpSender(udpTransport=" + this.udpTransport + ")";
    }
}

