/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.dispatcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.core.internal.boot.PropertiesProvider;
import io.katharsis.core.internal.dispatcher.ControllerLookup;
import io.katharsis.core.internal.dispatcher.ControllerRegistry;
import io.katharsis.core.internal.dispatcher.DefaultControllerLookup;
import io.katharsis.core.internal.dispatcher.controller.BaseController;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;
import java.util.LinkedList;

public class ControllerRegistryBuilder {
    private final ResourceRegistry resourceRegistry;
    private final TypeParser typeParser;
    private final ObjectMapper objectMapper;
    private final DocumentMapper documentMapper;

    public ControllerRegistryBuilder(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper, PropertiesProvider propertiesProvider) {
        this.resourceRegistry = resourceRegistry;
        this.typeParser = typeParser;
        this.objectMapper = objectMapper;
        this.documentMapper = new DocumentMapper(resourceRegistry, objectMapper, propertiesProvider);
    }

    public ControllerRegistry build() {
        return ControllerRegistryBuilder.build(new DefaultControllerLookup(this.resourceRegistry, this.typeParser, this.objectMapper, this.documentMapper));
    }

    private static ControllerRegistry build(ControllerLookup lookup) {
        LinkedList<BaseController> controllers = new LinkedList<BaseController>();
        controllers.addAll(lookup.getControllers());
        return new ControllerRegistry(controllers);
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }
}

