/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.registry;

import io.katharsis.errorhandling.exception.ResourceNotFoundInitializationException;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.resource.annotations.JsonApiResource;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import io.katharsis.utils.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryImpl
implements ResourceRegistry {
    protected final Map<Class, RegistryEntry> resources;
    private final ServiceUrlProvider serviceUrlProvider;
    private final Logger logger = LoggerFactory.getLogger(ResourceRegistryImpl.class);
    private ModuleRegistry moduleRegistry;
    private ConcurrentHashMap<String, ResourceInformation> baseTypeCache = new ConcurrentHashMap();

    public ResourceRegistryImpl(ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrlProvider) {
        this.moduleRegistry = moduleRegistry;
        this.serviceUrlProvider = serviceUrlProvider;
        this.resources = new HashMap<Class, RegistryEntry>();
        this.moduleRegistry.setResourceRegistry(this);
    }

    @Override
    public RegistryEntry addEntry(Class<?> resource, RegistryEntry registryEntry) {
        this.resources.put(resource, registryEntry);
        registryEntry.initialize(this.moduleRegistry);
        this.logger.debug("Added resource {} to ResourceRegistry", (Object)resource.getName());
        return registryEntry;
    }

    @Override
    public RegistryEntry getEntry(String searchType) {
        for (Map.Entry<Class, RegistryEntry> entry : this.resources.entrySet()) {
            String type = this.getResourceType(entry.getKey());
            if (type == null) {
                return null;
            }
            if (!type.equals(searchType)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public RegistryEntry findEntry(String searchType, Class<?> clazz) {
        RegistryEntry entry = this.getEntry(searchType);
        if (entry == null) {
            return this.getEntry(clazz, false);
        }
        return entry;
    }

    @Override
    public RegistryEntry findEntry(Class<?> clazz) {
        return this.getEntry(clazz, false);
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.getEntry(clazz, true) != null;
    }

    protected RegistryEntry getEntry(Class<?> clazz, boolean allowNull) {
        Optional<Class<?>> resourceClazz = this.getResourceClass(clazz);
        if (allowNull && !resourceClazz.isPresent()) {
            return null;
        }
        if (!resourceClazz.isPresent()) {
            throw new ResourceNotFoundInitializationException(clazz.getCanonicalName());
        }
        return this.resources.get(resourceClazz.get());
    }

    public <T> RegistryEntry getEntry(T targetDataObject) {
        Class<?> targetDataObjClass = targetDataObject.getClass();
        RegistryEntry relationshipEntry = targetDataObjClass.getAnnotation(JsonApiResource.class) != null ? this.findEntry(targetDataObjClass.getAnnotation(JsonApiResource.class).type(), targetDataObjClass.getClass()) : this.findEntry(targetDataObject.getClass());
        return relationshipEntry;
    }

    public String getResourceType(Class<?> clazz) {
        RegistryEntry entry = this.getEntry(clazz, true);
        if (entry == null) {
            return null;
        }
        ResourceInformation resourceInformation = entry.getResourceInformation();
        if (resourceInformation == null) {
            return null;
        }
        return resourceInformation.getResourceType();
    }

    public Optional<Class<?>> getResourceClass(Object resource) {
        return this.getResourceClass(resource.getClass());
    }

    public Optional<Class<?>> getResourceClass(Class<?> resourceClass) {
        for (Class<?> currentClass = resourceClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            RegistryEntry entry = this.resources.get(currentClass);
            if (entry == null) continue;
            return Optional.of(currentClass);
        }
        return Optional.empty();
    }

    public String getResourceUrl(Class<?> clazz) {
        return this.serviceUrlProvider.getUrl() + "/" + this.getResourceType(clazz);
    }

    public String getServiceUrl() {
        return this.serviceUrlProvider.getUrl();
    }

    @Override
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public Set<RegistryEntry> getResources() {
        return Collections.unmodifiableSet(new HashSet<RegistryEntry>(this.resources.values()));
    }

    @Override
    public RegistryEntry getEntryForClass(Class<?> resourceClass) {
        return this.resources.get(resourceClass);
    }

    @Override
    public String getResourceUrl(ResourceInformation resourceInformation) {
        String url = this.serviceUrlProvider.getUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url + resourceInformation.getResourceType();
    }

    @Override
    public ResourceInformation getBaseResourceInformation(String resourceType) {
        ResourceInformation baseInformation = this.baseTypeCache.get(resourceType);
        if (baseInformation != null) {
            return baseInformation;
        }
        RegistryEntry entry = this.getEntry(resourceType);
        baseInformation = entry.getResourceInformation();
        while (baseInformation.getSuperResourceType() != null) {
            entry = this.getEntry(baseInformation.getSuperResourceType());
            baseInformation = entry.getResourceInformation();
        }
        this.baseTypeCache.put(resourceType, baseInformation);
        return baseInformation;
    }
}

