/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.repository.adapter;

import io.katharsis.core.internal.query.QuerySpecAdapter;
import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.core.internal.utils.StringUtils;
import io.katharsis.legacy.internal.DefaultQuerySpecConverter;
import io.katharsis.legacy.internal.QueryParamsAdapter;
import io.katharsis.legacy.queryParams.DefaultQueryParamsParser;
import io.katharsis.legacy.queryParams.QueryParams;
import io.katharsis.legacy.queryParams.QueryParamsBuilder;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.queryspec.IncludeFieldSpec;
import io.katharsis.queryspec.IncludeRelationSpec;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.request.RepositoryRequestSpec;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class RepositoryRequestSpecImpl
implements RepositoryRequestSpec {
    private ResourceField relationshipField;
    private QueryAdapter queryAdapter;
    private Iterable<?> ids;
    private Object entity;
    private ModuleRegistry moduleRegistry;
    private HttpMethod method;

    private RepositoryRequestSpecImpl(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    @Override
    public ResourceField getRelationshipField() {
        return this.relationshipField;
    }

    @Override
    public QuerySpec getQuerySpec(ResourceInformation targetResourceInformation) {
        if (this.queryAdapter == null) {
            return null;
        }
        Class<?> targetResourceClass = targetResourceInformation.getResourceClass();
        if (this.queryAdapter instanceof QuerySpecAdapter) {
            QuerySpec querySpec = ((QuerySpecAdapter)this.queryAdapter).getQuerySpec();
            return querySpec.getOrCreateQuerySpec(targetResourceClass);
        }
        QueryParams queryParams = this.getQueryParams();
        DefaultQuerySpecConverter converter = new DefaultQuerySpecConverter(this.moduleRegistry);
        return converter.fromParams(targetResourceClass, queryParams);
    }

    @Override
    public QueryParams getQueryParams() {
        if (this.queryAdapter == null) {
            return null;
        }
        if (!(this.queryAdapter instanceof QueryParamsAdapter)) {
            QuerySpec rootQuerySpec = ((QuerySpecAdapter)this.queryAdapter).getQuerySpec();
            return this.convertToQueryParams(rootQuerySpec);
        }
        return ((QueryParamsAdapter)this.queryAdapter).getQueryParams();
    }

    private QueryParams convertToQueryParams(QuerySpec rootQuerySpec) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        querySpecs.addAll(rootQuerySpec.getRelatedSpecs().values());
        querySpecs.add(rootQuerySpec);
        for (QuerySpec spec : querySpecs) {
            HashSet<String> fieldNames;
            if (!spec.getFilters().isEmpty() || !spec.getSort().isEmpty() || spec.getLimit() != null || spec.getOffset() != 0L) {
                throw new UnsupportedOperationException();
            }
            String resourceType = this.moduleRegistry.getResourceRegistry().findEntry(spec.getResourceClass()).getResourceInformation().getResourceType();
            if (!spec.getIncludedFields().isEmpty()) {
                fieldNames = new HashSet<String>();
                for (IncludeFieldSpec includeFieldSpec : spec.getIncludedFields()) {
                    fieldNames.add(StringUtils.join(".", includeFieldSpec.getAttributePath()));
                }
                map.put("fields[" + resourceType + "]", fieldNames);
            }
            if (spec.getIncludedRelations().isEmpty()) continue;
            fieldNames = new HashSet();
            for (IncludeRelationSpec includeRelationSpec : spec.getIncludedRelations()) {
                fieldNames.add(StringUtils.join(".", includeRelationSpec.getAttributePath()));
            }
            map.put("include[" + resourceType + "]", fieldNames);
        }
        QueryParamsBuilder queryParamsBuilder = new QueryParamsBuilder(new DefaultQueryParamsParser());
        return queryParamsBuilder.buildQueryParams(map);
    }

    @Override
    public Serializable getId() {
        Iterator iterator;
        Iterable iterable = this.getIds();
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            return (Serializable)iterator.next();
        }
        return null;
    }

    @Override
    public <T> Iterable<T> getIds() {
        if (this.ids == null && this.entity != null) {
            ResourceInformation resourceInformation = this.queryAdapter.getResourceInformation();
            return Collections.singleton(resourceInformation.getId(this.entity));
        }
        return this.ids;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    public static RepositoryRequestSpec forDelete(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Serializable id) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = Arrays.asList(id);
        spec.method = HttpMethod.DELETE;
        return spec;
    }

    public static RepositoryRequestSpec forSave(ModuleRegistry moduleRegistry, HttpMethod method, QueryAdapter queryAdapter, Object entity) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.entity = entity;
        spec.method = method;
        return spec;
    }

    public static RepositoryRequestSpec forFindIds(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Iterable<?> ids) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindAll(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindId(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, Serializable id) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = Collections.singleton(id);
        spec.method = HttpMethod.GET;
        return spec;
    }

    public static RepositoryRequestSpec forFindTarget(ModuleRegistry moduleRegistry, QueryAdapter queryAdapter, List<?> ids, ResourceField relationshipField) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.relationshipField = relationshipField;
        spec.method = HttpMethod.GET;
        PreconditionUtil.assertNotNull("relationshipField is null", relationshipField);
        return spec;
    }

    public static RepositoryRequestSpecImpl forRelation(ModuleRegistry moduleRegistry, HttpMethod method, Object entity, QueryAdapter queryAdapter, Iterable<?> ids, ResourceField relationshipField) {
        RepositoryRequestSpecImpl spec = new RepositoryRequestSpecImpl(moduleRegistry);
        spec.entity = entity;
        spec.queryAdapter = queryAdapter;
        spec.ids = ids;
        spec.relationshipField = relationshipField;
        spec.method = method;
        PreconditionUtil.assertNotNull("relationshipField is null", relationshipField);
        return spec;
    }
}

