/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import io.katharsis.errorhandling.exception.InternalException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class AnnotatedFieldBuilder {
    private static final String CANNOT_FIND_PROPER_CONSTRUCTOR = "Couldn't find proper AnnotatedField constructor";

    public static AnnotatedField build(AnnotatedClass annotatedClass, Field field, AnnotationMap annotationMap) {
        int n = 0;
        Constructor<?>[] constructorArray = AnnotatedField.class.getConstructors();
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            try {
                return AnnotatedFieldBuilder.buildAnnotatedField(annotatedClass, field, annotationMap, constructor);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InternalException("Exception while building " + AnnotatedField.class.getCanonicalName(), e);
            }
        }
        throw new InternalException(CANNOT_FIND_PROPER_CONSTRUCTOR);
    }

    private static AnnotatedField buildAnnotatedField(AnnotatedClass annotatedClass, Field field, AnnotationMap annotationMap, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> firstParameterType = constructor.getParameterTypes()[0];
        if (firstParameterType == AnnotatedClass.class || "TypeResolutionContext".equals(firstParameterType.getSimpleName())) {
            return (AnnotatedField)constructor.newInstance(annotatedClass, field, annotationMap);
        }
        throw new InternalException(CANNOT_FIND_PROPER_CONSTRUCTOR);
    }
}

