/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.katharsis.core.internal.resource.DefaultResourceInstanceBuilder;
import io.katharsis.core.internal.resource.ResourceFieldImpl;
import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.core.internal.utils.FieldOrderedComparator;
import io.katharsis.core.internal.utils.StringUtils;
import io.katharsis.errorhandling.exception.RepositoryAnnotationNotFoundException;
import io.katharsis.resource.annotations.JsonApiId;
import io.katharsis.resource.annotations.JsonApiIncludeByDefault;
import io.katharsis.resource.annotations.JsonApiLinksInformation;
import io.katharsis.resource.annotations.JsonApiLookupIncludeAutomatically;
import io.katharsis.resource.annotations.JsonApiMetaInformation;
import io.katharsis.resource.annotations.JsonApiRelation;
import io.katharsis.resource.annotations.JsonApiResource;
import io.katharsis.resource.annotations.JsonApiToMany;
import io.katharsis.resource.annotations.JsonApiToOne;
import io.katharsis.resource.annotations.LookupIncludeBehavior;
import io.katharsis.resource.annotations.SerializeType;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceFieldNameTransformer;
import io.katharsis.resource.information.ResourceFieldType;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.information.ResourceInformationBuilder;
import io.katharsis.resource.information.ResourceInformationBuilderContext;
import io.katharsis.utils.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AnnotationResourceInformationBuilder
implements ResourceInformationBuilder {
    private final ResourceFieldNameTransformer resourceFieldNameTransformer;
    private ResourceInformationBuilderContext context;

    public AnnotationResourceInformationBuilder(ResourceFieldNameTransformer resourceFieldNameTransformer) {
        this.resourceFieldNameTransformer = resourceFieldNameTransformer;
    }

    @Override
    public boolean accept(Class<?> resourceClass) {
        return resourceClass.getAnnotation(JsonApiResource.class) != null;
    }

    @Override
    public ResourceInformation build(Class<?> resourceClass) {
        List<ResourceField> resourceFields = this.getResourceFields(resourceClass);
        String resourceType = this.getResourceType(resourceClass);
        Optional<JsonPropertyOrder> propertyOrder = ClassUtils.getAnnotation(resourceClass, JsonPropertyOrder.class);
        if (propertyOrder.isPresent()) {
            JsonPropertyOrder propertyOrderAnnotation = propertyOrder.get();
            Collections.sort(resourceFields, new FieldOrderedComparator(propertyOrderAnnotation.value(), propertyOrderAnnotation.alphabetic()));
        }
        DefaultResourceInstanceBuilder instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        Class<?> superclass = resourceClass.getSuperclass();
        String superResourceType = superclass != Object.class && this.context.accept(superclass) ? this.context.getResourceType(superclass) : null;
        return new ResourceInformation(this.context.getTypeParser(), resourceClass, resourceType, superResourceType, instanceBuilder, resourceFields);
    }

    @Override
    public String getResourceType(Class<?> resourceClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = resourceClass.getAnnotations()) {
            if (!(annotation instanceof JsonApiResource)) continue;
            JsonApiResource apiResource = (JsonApiResource)annotation;
            return apiResource.type();
        }
        throw new RepositoryAnnotationNotFoundException(resourceClass.getName());
    }

    private List<AnnotatedResourceField> getResourceFields(Class<?> resourceClass) {
        List<Field> classFields = ClassUtils.getClassFields(resourceClass);
        List<Method> classGetters = ClassUtils.getClassGetters(resourceClass);
        List<ResourceFieldWrapper> resourceClassFields = this.getFieldResourceFields(classFields);
        List<ResourceFieldWrapper> resourceGetterFields = this.getGetterResourceFields(classGetters);
        return this.getResourceFields(resourceClassFields, resourceGetterFields);
    }

    private List<ResourceFieldWrapper> getFieldResourceFields(List<Field> classFields) {
        ArrayList<ResourceFieldWrapper> fieldWrappers = new ArrayList<ResourceFieldWrapper>(classFields.size());
        for (Field field : classFields) {
            String jsonName = this.resourceFieldNameTransformer.getName(field);
            String underlyingName = field.getName();
            List<Annotation> annotations = Arrays.asList(field.getAnnotations());
            ResourceFieldType resourceFieldType = AnnotatedResourceField.getResourceFieldType(annotations);
            String oppositeResourceType = resourceFieldType == ResourceFieldType.RELATIONSHIP ? AnnotationResourceInformationBuilder.getResourceType(field.getGenericType(), this.context) : null;
            AnnotatedResourceField resourceField = new AnnotatedResourceField(jsonName, underlyingName, field.getType(), field.getGenericType(), oppositeResourceType, annotations);
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                fieldWrappers.add(new ResourceFieldWrapper(resourceField, true));
                continue;
            }
            fieldWrappers.add(new ResourceFieldWrapper(resourceField, false));
        }
        return fieldWrappers;
    }

    public static String getResourceType(Type genericType, ResourceInformationBuilderContext context) {
        Class<?> rawType;
        Class<?> elementType = genericType;
        if (Iterable.class.isAssignableFrom(ClassUtils.getRawType(genericType))) {
            elementType = ClassUtils.getRawType(((ParameterizedType)((Object)genericType)).getActualTypeArguments()[0]);
        }
        return context.accept(rawType = ClassUtils.getRawType(elementType)) ? context.getResourceType(rawType) : null;
    }

    private List<ResourceFieldWrapper> getGetterResourceFields(List<Method> classGetters) {
        ArrayList<ResourceFieldWrapper> fieldWrappers = new ArrayList<ResourceFieldWrapper>(classGetters.size());
        for (Method getter : classGetters) {
            String jsonName = this.resourceFieldNameTransformer.getName(getter);
            String underlyingName = this.resourceFieldNameTransformer.getMethodName(getter);
            List<Annotation> annotations = Arrays.asList(getter.getAnnotations());
            ResourceFieldType resourceFieldType = AnnotatedResourceField.getResourceFieldType(annotations);
            String oppositeResourceType = resourceFieldType == ResourceFieldType.RELATIONSHIP ? AnnotationResourceInformationBuilder.getResourceType(getter.getGenericReturnType(), this.context) : null;
            AnnotatedResourceField resourceField = new AnnotatedResourceField(jsonName, underlyingName, getter.getReturnType(), getter.getGenericReturnType(), oppositeResourceType, annotations);
            if (Modifier.isStatic(getter.getModifiers())) {
                fieldWrappers.add(new ResourceFieldWrapper(resourceField, true));
                continue;
            }
            fieldWrappers.add(new ResourceFieldWrapper(resourceField, false));
        }
        return fieldWrappers;
    }

    private List<AnnotatedResourceField> getResourceFields(List<ResourceFieldWrapper> resourceClassFields, List<ResourceFieldWrapper> resourceGetterFields) {
        HashMap<String, AnnotatedResourceField> resourceFieldMap = new HashMap<String, AnnotatedResourceField>();
        for (ResourceFieldWrapper fieldWrapper : resourceClassFields) {
            if (fieldWrapper.isDiscarded()) continue;
            resourceFieldMap.put(fieldWrapper.getResourceField().getUnderlyingName(), fieldWrapper.getResourceField());
        }
        for (ResourceFieldWrapper fieldWrapper : resourceGetterFields) {
            if (fieldWrapper.isDiscarded()) continue;
            String originalName = fieldWrapper.getResourceField().getUnderlyingName();
            AnnotatedResourceField field = fieldWrapper.getResourceField();
            if (resourceFieldMap.containsKey(originalName)) {
                resourceFieldMap.put(originalName, AnnotationResourceInformationBuilder.mergeAnnotations((AnnotatedResourceField)resourceFieldMap.get(originalName), field, this.context));
                continue;
            }
            if (AnnotationResourceInformationBuilder.hasDiscardedField(fieldWrapper, resourceClassFields)) continue;
            resourceFieldMap.put(originalName, field);
        }
        return this.discardIgnoredField(resourceFieldMap.values());
    }

    private List<AnnotatedResourceField> discardIgnoredField(Collection<AnnotatedResourceField> resourceFieldValues) {
        LinkedList<AnnotatedResourceField> resourceFields = new LinkedList<AnnotatedResourceField>();
        for (AnnotatedResourceField resourceField : resourceFieldValues) {
            if (resourceField.isAnnotationPresent(JsonIgnore.class)) continue;
            resourceFields.add(resourceField);
        }
        return resourceFields;
    }

    private static boolean hasDiscardedField(ResourceFieldWrapper fieldWrapper, List<ResourceFieldWrapper> resourceClassFields) {
        for (ResourceFieldWrapper resourceFieldWrapper : resourceClassFields) {
            if (!fieldWrapper.getResourceField().getUnderlyingName().equals(resourceFieldWrapper.getResourceField().getUnderlyingName())) continue;
            return true;
        }
        return false;
    }

    private static AnnotatedResourceField mergeAnnotations(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod, ResourceInformationBuilderContext context) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(fromField.getAnnotations());
        annotations.addAll(fromMethod.getAnnotations());
        Class<?> fieldType = AnnotationResourceInformationBuilder.mergeFieldType(fromField, fromMethod);
        Type fieldGenericType = AnnotationResourceInformationBuilder.mergeGenericType(fromField, fromMethod);
        String oppositeResourceType = AnnotationResourceInformationBuilder.getResourceType(fieldGenericType, context);
        return new AnnotatedResourceField(fromField.getJsonName(), fromField.getUnderlyingName(), fieldType, fieldGenericType, oppositeResourceType, annotations);
    }

    private static Class<?> mergeFieldType(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod) {
        if (AnnotationResourceInformationBuilder.hasKatharsisAnnotation(fromField.getAnnotations())) {
            return fromField.getType();
        }
        return fromMethod.getType();
    }

    private static Type mergeGenericType(AnnotatedResourceField fromField, AnnotatedResourceField fromMethod) {
        if (AnnotationResourceInformationBuilder.hasKatharsisAnnotation(fromField.getAnnotations())) {
            return fromField.getGenericType();
        }
        return fromMethod.getGenericType();
    }

    private static boolean hasKatharsisAnnotation(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != JsonApiId.class && annotation.annotationType() != JsonApiRelation.class && annotation.annotationType() != JsonApiToOne.class && annotation.annotationType() != JsonApiToMany.class && annotation.annotationType() != JsonApiMetaInformation.class && annotation.annotationType() != JsonApiLinksInformation.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(ResourceInformationBuilderContext context) {
        this.context = context;
    }

    public static class AnnotatedResourceField
    extends ResourceFieldImpl {
        private List<Annotation> annotations;

        public AnnotatedResourceField(String jsonName, String underlyingName, Class<?> type, Type genericType, String oppositeResourceType, List<Annotation> annotations) {
            super(jsonName, underlyingName, AnnotatedResourceField.getResourceFieldType(annotations), type, genericType, oppositeResourceType, AnnotatedResourceField.getOppositeName(annotations), AnnotatedResourceField.isLazy(annotations), AnnotatedResourceField.getIncludeByDefault(annotations), AnnotatedResourceField.getLookupIncludeBehavior(annotations));
            this.annotations = annotations;
        }

        private static String getOppositeName(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiToMany) {
                    return StringUtils.emptyToNull(((JsonApiToMany)annotation).opposite());
                }
                if (annotation instanceof JsonApiToOne) {
                    return StringUtils.emptyToNull(((JsonApiToOne)annotation).opposite());
                }
                if (!(annotation instanceof JsonApiRelation)) continue;
                return StringUtils.emptyToNull(((JsonApiRelation)annotation).opposite());
            }
            return null;
        }

        public static boolean getIncludeByDefault(Collection<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    JsonApiRelation jsonApiRelation = (JsonApiRelation)annotation;
                    return jsonApiRelation.serialize() == SerializeType.EAGER;
                }
                if (!(annotation instanceof JsonApiIncludeByDefault)) continue;
                return true;
            }
            return false;
        }

        public static LookupIncludeBehavior getLookupIncludeBehavior(Collection<Annotation> annotations) {
            return AnnotatedResourceField.getLookupIncludeBehavior(annotations, LookupIncludeBehavior.NONE);
        }

        public static LookupIncludeBehavior getLookupIncludeBehavior(Collection<Annotation> annotations, LookupIncludeBehavior defaultBehavior) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    JsonApiRelation jsonApiRelation = (JsonApiRelation)annotation;
                    return jsonApiRelation.lookUp();
                }
                if (!(annotation instanceof JsonApiLookupIncludeAutomatically)) continue;
                JsonApiLookupIncludeAutomatically includeAnnotation = (JsonApiLookupIncludeAutomatically)annotation;
                if (includeAnnotation.overwrite()) {
                    return LookupIncludeBehavior.AUTOMATICALLY_ALWAYS;
                }
                return LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL;
            }
            return defaultBehavior;
        }

        public static boolean isLazy(List<Annotation> annotations) {
            return AnnotatedResourceField.isLazy(annotations, false);
        }

        public static boolean isLazy(Collection<Annotation> annotations, boolean defaultValue) {
            JsonApiRelation jsonApiRelation = null;
            JsonApiIncludeByDefault includeByDefaultAnnotation = null;
            JsonApiToMany toManyAnnotation = null;
            JsonApiToOne toOneAnnotation = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiRelation) {
                    jsonApiRelation = (JsonApiRelation)annotation;
                    break;
                }
                if (annotation.annotationType().equals(JsonApiIncludeByDefault.class)) {
                    includeByDefaultAnnotation = (JsonApiIncludeByDefault)annotation;
                }
                if (annotation.annotationType().equals(JsonApiToMany.class)) {
                    toManyAnnotation = (JsonApiToMany)annotation;
                }
                if (!annotation.annotationType().equals(JsonApiToOne.class)) continue;
                toOneAnnotation = (JsonApiToOne)annotation;
            }
            if (jsonApiRelation != null) {
                switch (jsonApiRelation.serialize()) {
                    case LAZY: {
                        return true;
                    }
                    case ONLY_ID: {
                        return false;
                    }
                    case EAGER: {
                        return false;
                    }
                }
                throw new UnsupportedOperationException("Unknown serialize type " + (Object)((Object)jsonApiRelation.serialize()));
            }
            if (includeByDefaultAnnotation != null) {
                return false;
            }
            if (toManyAnnotation != null) {
                return toManyAnnotation.lazy();
            }
            if (toOneAnnotation != null) {
                return toOneAnnotation.lazy();
            }
            return defaultValue;
        }

        public static ResourceFieldType getResourceFieldType(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JsonApiId) {
                    return ResourceFieldType.ID;
                }
                if (annotation instanceof JsonApiToOne || annotation instanceof JsonApiToMany || annotation instanceof JsonApiRelation) {
                    return ResourceFieldType.RELATIONSHIP;
                }
                if (annotation instanceof JsonApiMetaInformation) {
                    return ResourceFieldType.META_INFORMATION;
                }
                if (!(annotation instanceof JsonApiLinksInformation)) continue;
                return ResourceFieldType.LINKS_INFORMATION;
            }
            return ResourceFieldType.ATTRIBUTE;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<?> annotationClass) {
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationClass)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ResourceFieldWrapper {
        private AnnotatedResourceField resourceField;
        private boolean discarded;

        public ResourceFieldWrapper(AnnotatedResourceField resourceField, boolean discarded) {
            this.resourceField = resourceField;
            this.discarded = discarded;
        }

        public AnnotatedResourceField getResourceField() {
            return this.resourceField;
        }

        public boolean isDiscarded() {
            return this.discarded;
        }
    }
}

