/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.katharsis.resource.Resource;
import io.katharsis.utils.Nullable;
import java.io.IOException;
import java.util.Arrays;

public class DocumentDataDeserializer
extends JsonDeserializer<Nullable<Object>> {
    public Nullable<Object> deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.START_ARRAY) {
            Resource[] resources = (Resource[])jp.readValueAs(Resource[].class);
            return Nullable.of(Arrays.asList(resources));
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return Nullable.nullValue();
        }
        if (currentToken == JsonToken.START_OBJECT) {
            return Nullable.of(jp.readValueAs(Resource.class));
        }
        throw new IllegalStateException(currentToken.toString());
    }

    public Nullable<Object> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return Nullable.nullValue();
    }
}

