/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.resource.annotations.LookupIncludeBehavior;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceFieldType;
import io.katharsis.resource.information.ResourceInformation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ResourceFieldImpl
implements ResourceField {
    private final String jsonName;
    private final String underlyingName;
    private final Class<?> type;
    private String oppositeResourceType;
    private final Type genericType;
    private final boolean lazy;
    private LookupIncludeBehavior lookupIncludeBehavior;
    private boolean includeByDefault;
    private ResourceFieldType resourceFieldType;
    private String oppositeName;
    private ResourceInformation parentResourceInformation;

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType) {
        this(jsonName, underlyingName, resourceFieldType, type, genericType, oppositeResourceType, null, true, false, LookupIncludeBehavior.NONE);
    }

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType, String oppositeName, boolean lazy, boolean includeByDefault, LookupIncludeBehavior lookupIncludeBehavior) {
        this.jsonName = jsonName;
        this.underlyingName = underlyingName;
        this.resourceFieldType = resourceFieldType;
        this.includeByDefault = includeByDefault;
        this.type = type;
        this.genericType = genericType;
        this.lazy = lazy;
        this.lookupIncludeBehavior = lookupIncludeBehavior;
        this.oppositeName = oppositeName;
        this.oppositeResourceType = oppositeResourceType;
    }

    @Override
    public ResourceFieldType getResourceFieldType() {
        return this.resourceFieldType;
    }

    @Override
    public LookupIncludeBehavior getLookupIncludeAutomatically() {
        return this.lookupIncludeBehavior;
    }

    @Override
    public String getOppositeName() {
        return this.oppositeName;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public String getOppositeResourceType() {
        PreconditionUtil.assertEquals("not an association", (Object)ResourceFieldType.RELATIONSHIP, (Object)this.resourceFieldType);
        PreconditionUtil.assertNotNull("resourceType must not be null", this.oppositeResourceType);
        return this.oppositeResourceType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean getIncludeByDefault() {
        return this.includeByDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldImpl that = (ResourceFieldImpl)o;
        return Objects.equals(this.jsonName, that.jsonName) && Objects.equals(this.underlyingName, that.underlyingName) && Objects.equals(this.type, that.type) && Objects.equals((Object)this.lookupIncludeBehavior, (Object)that.lookupIncludeBehavior) && Objects.equals(this.includeByDefault, that.includeByDefault) && Objects.equals(this.genericType, that.genericType) && Objects.equals(this.lazy, that.lazy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonName, this.underlyingName, this.type, this.genericType, this.lazy, this.includeByDefault, this.lookupIncludeBehavior});
    }

    @Override
    public Class<?> getElementType() {
        if (Iterable.class.isAssignableFrom(this.type)) {
            return (Class)((ParameterizedType)this.getGenericType()).getActualTypeArguments()[0];
        }
        return this.type;
    }

    @Override
    public ResourceInformation getParentResourceInformation() {
        return this.parentResourceInformation;
    }

    @Override
    public void setResourceInformation(ResourceInformation resourceInformation) {
        this.parentResourceInformation = resourceInformation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[jsonName=" + this.jsonName + ",resourceType=" + this.parentResourceInformation.getResourceType() + "]";
    }

    @Override
    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.getType());
    }
}

