/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.core.internal.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.katharsis.core.internal.resource.DocumentMapperUtil;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.resource.Relationship;
import io.katharsis.resource.Resource;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.links.LinksInformation;
import io.katharsis.resource.links.SelfLinksInformation;
import io.katharsis.resource.meta.MetaInformation;
import java.util.List;

public class ResourceMapper {
    private static final String SELF_FIELD_NAME = "self";
    private static final String RELATED_FIELD_NAME = "related";
    private DocumentMapperUtil util;
    private boolean client;
    private ObjectMapper objectMapper;

    public ResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper) {
        this.util = util;
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public Resource toData(Object entity, QueryAdapter queryAdapter) {
        if (entity instanceof Resource) {
            return (Resource)entity;
        }
        Class<?> dataClass = entity.getClass();
        ResourceInformation resourceInformation = this.util.getResourceInformation(dataClass);
        Resource resource = new Resource();
        resource.setId(this.util.getIdString(entity, resourceInformation));
        resource.setType(resourceInformation.getResourceType());
        if (!this.client) {
            this.util.setLinks(resource, this.getResourceLinks(entity, resourceInformation));
            this.util.setMeta(resource, this.getResourceMeta(entity, resourceInformation));
        }
        this.setAttributes(resource, entity, resourceInformation, queryAdapter);
        this.setRelationships(resource, entity, resourceInformation, queryAdapter);
        return resource;
    }

    private MetaInformation getResourceMeta(Object entity, ResourceInformation resourceInformation) {
        if (resourceInformation.getMetaField() != null) {
            return (MetaInformation)PropertyUtils.getProperty(entity, resourceInformation.getMetaField().getUnderlyingName());
        }
        return null;
    }

    public LinksInformation getResourceLinks(Object entity, ResourceInformation resourceInformation) {
        SelfLinksInformation self;
        LinksInformation info = resourceInformation.getLinksField() != null ? (LinksInformation)PropertyUtils.getProperty(entity, resourceInformation.getLinksField().getUnderlyingName()) : new DocumentMapperUtil.DefaultSelfRelatedLinksInformation();
        if (info instanceof SelfLinksInformation && (self = (SelfLinksInformation)info).getSelf() == null) {
            self.setSelf(this.util.getSelfUrl(resourceInformation, entity));
        }
        return info;
    }

    protected void setAttributes(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getAttributeFields().getFields(), false);
        for (ResourceField field : fields) {
            Object value = PropertyUtils.getProperty(entity, field.getUnderlyingName());
            JsonNode valueNode = this.objectMapper.valueToTree(value);
            resource.getAttributes().put(field.getJsonName(), valueNode);
        }
    }

    protected void setRelationships(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getRelationshipFields(), true);
        for (ResourceField field : fields) {
            this.setRelationship(resource, field, entity, resourceInformation, queryAdapter);
        }
    }

    protected void setRelationship(Resource resource, ResourceField field, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        ObjectNode relationshipLinks = this.objectMapper.createObjectNode();
        relationshipLinks.put(SELF_FIELD_NAME, this.util.getRelationshipLink(resourceInformation, entity, field, false));
        relationshipLinks.put(RELATED_FIELD_NAME, this.util.getRelationshipLink(resourceInformation, entity, field, true));
        Relationship relationship = new Relationship();
        relationship.setLinks(relationshipLinks);
        resource.getRelationships().put(field.getJsonName(), relationship);
    }
}

