/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.internal;

import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.legacy.internal.AnnotatedRepositoryAdapter;
import io.katharsis.legacy.internal.ParametersFactory;
import io.katharsis.legacy.repository.annotations.JsonApiAddRelations;
import io.katharsis.legacy.repository.annotations.JsonApiFindManyTargets;
import io.katharsis.legacy.repository.annotations.JsonApiFindOneTarget;
import io.katharsis.legacy.repository.annotations.JsonApiRemoveRelations;
import io.katharsis.legacy.repository.annotations.JsonApiSetRelation;
import io.katharsis.legacy.repository.annotations.JsonApiSetRelations;
import io.katharsis.repository.request.QueryAdapter;
import java.io.Serializable;
import java.lang.reflect.Method;

public class AnnotatedRelationshipRepositoryAdapter<T, T_ID extends Serializable, D, D_ID extends Serializable>
extends AnnotatedRepositoryAdapter<T> {
    private Method setRelationMethod;
    private Method setRelationsMethod;
    private Method addRelationsMethod;
    private Method removeRelationsMethod;
    private Method findOneTargetMethod;
    private Method findManyTargetsMethod;

    public AnnotatedRelationshipRepositoryAdapter(Object implementationObject, ParametersFactory parametersFactory) {
        super(implementationObject, parametersFactory);
    }

    public void setRelation(T source, D_ID targetId, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiSetRelation> annotationType = JsonApiSetRelation.class;
        if (this.setRelationMethod == null) {
            this.setRelationMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        this.invokeOperation(this.setRelationMethod, annotationType, new Object[]{source, targetId, fieldName}, queryAdapter);
    }

    public void setRelations(T source, Iterable<D_ID> targetIds, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiSetRelations> annotationType = JsonApiSetRelations.class;
        if (this.setRelationsMethod == null) {
            this.setRelationsMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        this.invokeOperation(this.setRelationsMethod, annotationType, new Object[]{source, targetIds, fieldName}, queryAdapter);
    }

    public void addRelations(T source, Iterable<D_ID> targetIds, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiAddRelations> annotationType = JsonApiAddRelations.class;
        if (this.addRelationsMethod == null) {
            this.addRelationsMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        this.invokeOperation(this.addRelationsMethod, annotationType, new Object[]{source, targetIds, fieldName}, queryAdapter);
    }

    public void removeRelations(T source, Iterable<D_ID> targetIds, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiRemoveRelations> annotationType = JsonApiRemoveRelations.class;
        if (this.removeRelationsMethod == null) {
            this.removeRelationsMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        this.invokeOperation(this.removeRelationsMethod, annotationType, new Object[]{source, targetIds, fieldName}, queryAdapter);
    }

    public Object findOneTarget(T_ID sourceId, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiFindOneTarget> annotationType = JsonApiFindOneTarget.class;
        if (this.findOneTargetMethod == null) {
            this.findOneTargetMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.findOneTargetMethod, annotationType, new Object[]{sourceId, fieldName}, queryAdapter);
    }

    public Object findManyTargets(T_ID sourceId, String fieldName, QueryAdapter queryAdapter) {
        Class<JsonApiFindManyTargets> annotationType = JsonApiFindManyTargets.class;
        if (this.findManyTargetsMethod == null) {
            this.findManyTargetsMethod = ClassUtils.findMethodWith(this.implementationClass, annotationType);
        }
        return this.invokeOperation(this.findManyTargetsMethod, annotationType, new Object[]{sourceId, fieldName}, queryAdapter);
    }
}

