/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.legacy.registry;

import io.katharsis.core.internal.registry.DirectResponseResourceEntry;
import io.katharsis.core.internal.repository.NotFoundRepository;
import io.katharsis.legacy.locator.JsonServiceLocator;
import io.katharsis.legacy.registry.AnnotatedRepositoryEntryBuilder;
import io.katharsis.legacy.registry.DirectRepositoryEntryBuilder;
import io.katharsis.legacy.registry.RepositoryEntryBuilder;
import io.katharsis.legacy.registry.RepositoryInstanceBuilder;
import io.katharsis.legacy.repository.ResourceRepository;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.resource.registry.ResourceEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import java.util.LinkedList;
import java.util.List;

public class RepositoryEntryBuilderFacade
implements RepositoryEntryBuilder {
    private final DirectRepositoryEntryBuilder directRepositoryEntryBuilder;
    private final AnnotatedRepositoryEntryBuilder annotatedRepositoryEntryBuilder;

    public RepositoryEntryBuilderFacade(ModuleRegistry moduleRegistry, JsonServiceLocator jsonServiceLocator) {
        this.directRepositoryEntryBuilder = new DirectRepositoryEntryBuilder(jsonServiceLocator);
        this.annotatedRepositoryEntryBuilder = new AnnotatedRepositoryEntryBuilder(moduleRegistry, jsonServiceLocator);
    }

    @Override
    public ResourceEntry buildResourceRepository(ResourceLookup lookup, final Class<?> resourceClass) {
        ResourceEntry resourceEntry = this.annotatedRepositoryEntryBuilder.buildResourceRepository(lookup, resourceClass);
        if (resourceEntry == null) {
            resourceEntry = this.directRepositoryEntryBuilder.buildResourceRepository(lookup, resourceClass);
        }
        if (resourceEntry == null) {
            RepositoryInstanceBuilder<ResourceRepository> repositoryInstanceBuilder = new RepositoryInstanceBuilder<ResourceRepository>(new JsonServiceLocator(){

                @Override
                public <T> T getInstance(Class<T> clazz) {
                    return (T)new NotFoundRepository(resourceClass);
                }
            }, NotFoundRepository.class);
            resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        }
        return resourceEntry;
    }

    @Override
    public List<ResponseRelationshipEntry> buildRelationshipRepositories(ResourceLookup lookup, Class<?> resourceClass) {
        List<ResponseRelationshipEntry> annotationEntries = this.annotatedRepositoryEntryBuilder.buildRelationshipRepositories(lookup, resourceClass);
        LinkedList<ResponseRelationshipEntry> targetEntries = new LinkedList<ResponseRelationshipEntry>(annotationEntries);
        List<ResponseRelationshipEntry> directEntries = this.directRepositoryEntryBuilder.buildRelationshipRepositories(lookup, resourceClass);
        for (ResponseRelationshipEntry directEntry : directEntries) {
            if (this.contains(targetEntries, directEntry)) continue;
            targetEntries.add(directEntry);
        }
        return targetEntries;
    }

    private boolean contains(List<ResponseRelationshipEntry> targetEntries, ResponseRelationshipEntry directEntry) {
        boolean contains = false;
        for (ResponseRelationshipEntry targetEntry : targetEntries) {
            if (!targetEntry.getTargetAffiliation().equals(directEntry.getTargetAffiliation())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

