/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.resource.information;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import io.katharsis.core.internal.resource.AnnotatedClassBuilder;
import io.katharsis.core.internal.resource.AnnotatedFieldBuilder;
import io.katharsis.core.internal.resource.AnnotatedMethodBuilder;
import io.katharsis.core.internal.utils.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ResourceFieldNameTransformer {
    private final SerializationConfig serializationConfig;

    public ResourceFieldNameTransformer() {
        this(null);
    }

    public ResourceFieldNameTransformer(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
    }

    public String getName(Field field) {
        String name = field.getName();
        if (field.isAnnotationPresent(JsonProperty.class) && !"".equals(field.getAnnotation(JsonProperty.class).value())) {
            name = field.getAnnotation(JsonProperty.class).value();
        } else if (this.serializationConfig != null && this.serializationConfig.getPropertyNamingStrategy() != null) {
            AnnotationMap annotationMap = ResourceFieldNameTransformer.buildAnnotationMap(field.getDeclaredAnnotations());
            AnnotatedClass annotatedClass = AnnotatedClassBuilder.build(field.getDeclaringClass(), this.serializationConfig);
            AnnotatedField annotatedField = AnnotatedFieldBuilder.build(annotatedClass, field, annotationMap);
            name = this.serializationConfig.getPropertyNamingStrategy().nameForField((MapperConfig)this.serializationConfig, annotatedField, name);
        }
        return name;
    }

    public String getName(Method method) {
        String name = this.getMethodName(method);
        if (method.isAnnotationPresent(JsonProperty.class) && !"".equals(method.getAnnotation(JsonProperty.class).value())) {
            name = method.getAnnotation(JsonProperty.class).value();
        } else if (this.serializationConfig != null && this.serializationConfig.getPropertyNamingStrategy() != null) {
            Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
            AnnotationMap annotationMap = ResourceFieldNameTransformer.buildAnnotationMap(declaredAnnotations);
            int paramsLength = method.getParameterAnnotations().length;
            AnnotationMap[] paramAnnotations = new AnnotationMap[paramsLength];
            for (int i = 0; i < paramsLength; ++i) {
                AnnotationMap parameterAnnotationMap;
                paramAnnotations[i] = parameterAnnotationMap = ResourceFieldNameTransformer.buildAnnotationMap(method.getParameterAnnotations()[i]);
            }
            AnnotatedClass annotatedClass = AnnotatedClassBuilder.build(method.getDeclaringClass(), this.serializationConfig);
            AnnotatedMethod annotatedField = AnnotatedMethodBuilder.build(annotatedClass, method, annotationMap, paramAnnotations);
            name = this.serializationConfig.getPropertyNamingStrategy().nameForGetterMethod((MapperConfig)this.serializationConfig, annotatedField, name);
        }
        return name;
    }

    private static AnnotationMap buildAnnotationMap(Annotation[] declaredAnnotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        for (Annotation annotation : declaredAnnotations) {
            annotationMap.add(annotation);
        }
        return annotationMap;
    }

    public String getMethodName(Method method) {
        String name = ClassUtils.isBooleanGetter(method) ? ResourceFieldNameTransformer.extractMethodName(method, 2) : ResourceFieldNameTransformer.extractMethodName(method, 3);
        return name;
    }

    private static String extractMethodName(Method method, int nameStart) {
        String resourceName = method.getName().substring(nameStart);
        return resourceName.substring(0, 1).toLowerCase() + resourceName.substring(1);
    }
}

