/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.utils.parser;

import io.katharsis.utils.parser.StringParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class DefaultStringParsers {
    public static Map<Class, StringParser> get() {
        HashMap<Class, StringParser> parsers = new HashMap<Class, StringParser>();
        DefaultStringParsers.addType(parsers, Arrays.asList(Byte.class, Byte.TYPE), new StringParser<Byte>(){

            @Override
            public Byte parse(String input) {
                return Byte.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Short.class, Short.TYPE), new StringParser<Short>(){

            @Override
            public Short parse(String input) {
                return Short.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Integer.class, Integer.TYPE), new StringParser<Integer>(){

            @Override
            public Integer parse(String input) {
                return Integer.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Long.class, Long.TYPE), new StringParser<Long>(){

            @Override
            public Long parse(String input) {
                return Long.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Float.class, Float.TYPE), new StringParser<Float>(){

            @Override
            public Float parse(String input) {
                return Float.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Double.class, Double.TYPE), new StringParser<Double>(){

            @Override
            public Double parse(String input) {
                return Double.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(BigInteger.class), new StringParser<BigInteger>(){

            @Override
            public BigInteger parse(String input) {
                return new BigInteger(input);
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(BigDecimal.class), new StringParser<BigDecimal>(){

            @Override
            public BigDecimal parse(String input) {
                return new BigDecimal(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Character.class, Character.TYPE), new StringParser<Character>(){

            @Override
            public Character parse(String input) {
                if (input.length() != 1) {
                    DefaultStringParsers.throwException(Character.class, input);
                }
                return Character.valueOf(input.charAt(0));
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Boolean.class, Boolean.TYPE), new StringParser<Boolean>(){

            @Override
            public Boolean parse(String input) {
                String inputNormalized = input.toLowerCase();
                if ("true".equals(inputNormalized) || "t".equals(inputNormalized)) {
                    return true;
                }
                if ("false".equals(inputNormalized) || "f".equals(inputNormalized)) {
                    return false;
                }
                DefaultStringParsers.throwException(Boolean.class, input);
                return false;
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(UUID.class), new StringParser<UUID>(){

            @Override
            public UUID parse(String input) {
                return UUID.fromString(input);
            }
        });
        return parsers;
    }

    private static <T> void addType(Map<Class, StringParser> parsers, List<Class<T>> classes, StringParser<T> standardTypeParser) {
        for (Class<T> clazz : classes) {
            parsers.put(clazz, standardTypeParser);
        }
    }

    private static void throwException(Class clazz, String input) {
        throw new IllegalArgumentException(String.format("String cannot be casted to %s: %s", clazz, input));
    }
}

