/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0000\u001a*\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"PRF", "", "secret", "Ljavax/crypto/SecretKey;", "label", "seed", "requiredLength", "", "P_hash", "mac", "Ljavax/crypto/Mac;", "secretKey", "ktor-network-tls"})
public final class HashesKt {
    @NotNull
    public static final byte[] PRF(@NotNull SecretKey secret, @NotNull byte[] label, @NotNull byte[] seed, int requiredLength) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        byte[] byArray = ArraysKt.plus((byte[])label, (byte[])seed);
        Mac mac = Mac.getInstance(secret.getAlgorithm());
        Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(secret.algorithm)");
        return HashesKt.P_hash(byArray, mac, secret, requiredLength);
    }

    public static /* synthetic */ byte[] PRF$default(SecretKey secretKey, byte[] byArray, byte[] byArray2, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 12;
        }
        return HashesKt.PRF(secretKey, byArray, byArray2, n);
    }

    private static final byte[] P_hash(byte[] seed, Mac mac, SecretKey secretKey, int requiredLength) {
        boolean bl = requiredLength >= 12;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] A = seed;
        byte[] result = new byte[]{};
        while (result.length < requiredLength) {
            mac.reset();
            mac.init(secretKey);
            mac.update(A);
            byte[] byArray = mac.doFinal();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal()");
            A = byArray;
            mac.reset();
            mac.init(secretKey);
            mac.update(A);
            mac.update(seed);
            byArray = mac.doFinal();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal()");
            result = ArraysKt.plus((byte[])result, (byte[])byArray);
        }
        byte[] byArray = result;
        bl4 = false;
        byte[] byArray2 = Arrays.copyOf(byArray, requiredLength);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        return byArray2;
    }

    static /* synthetic */ byte[] P_hash$default(byte[] byArray, Mac mac, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 12;
        }
        return HashesKt.P_hash(byArray, mac, secretKey, n);
    }
}

