/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.Digest;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.TLSClientHandshake;
import io.ktor.network.tls.TLSClientHandshakeKt;
import io.ktor.network.tls.TLSConfig;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.UtilsKt;
import io.ktor.network.tls.certificates.CertificateType;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.CloseableJVMKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.PreviewKt;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010/\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0011\u00102\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J5\u00105\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010=\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010>\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010?\u001a\u00020.H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010@\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u001b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020;H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ!\u0010E\u001a\u0002032\u0006\u0010C\u001a\u00020;2\u0006\u0010F\u001a\u00020BH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0019\u0010H\u001a\u0002032\u0006\u0010I\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\u0011\u0010K\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J3\u0010L\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010M\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ2\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020Q2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002030S\u00a2\u0006\u0002\bUH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u0010\u0010W\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b#\u0010$R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u001c\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006X"}, d2={"Lio/ktor/network/tls/TLSClientHandshake;", "Lkotlinx/coroutines/CoroutineScope;", "rawInput", "Lio/ktor/utils/io/ByteReadChannel;", "rawOutput", "Lio/ktor/utils/io/ByteWriteChannel;", "config", "Lio/ktor/network/tls/TLSConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lio/ktor/network/tls/TLSConfig;Lkotlin/coroutines/CoroutineContext;)V", "cipher", "Lio/ktor/network/tls/cipher/TLSCipher;", "getCipher", "()Lio/ktor/network/tls/cipher/TLSCipher;", "cipher$delegate", "Lkotlin/Lazy;", "clientSeed", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "digest", "Lio/ktor/network/tls/Digest;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "handshakes", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/network/tls/TLSHandshake;", "getHandshakes$annotations", "()V", "input", "Lio/ktor/network/tls/TLSRecord;", "getInput$annotations", "getInput", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "keyMaterial", "getKeyMaterial", "()[B", "keyMaterial$delegate", "masterSecret", "Ljavax/crypto/spec/SecretKeySpec;", "output", "Lkotlinx/coroutines/channels/SendChannel;", "getOutput$annotations", "getOutput", "()Lkotlinx/coroutines/channels/SendChannel;", "serverHello", "Lio/ktor/network/tls/TLSServerHello;", "generatePreSecret", "encryptionInfo", "Lio/ktor/network/tls/EncryptionInfo;", "handleCertificatesAndKeys", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleServerDone", "exchangeType", "Lio/ktor/network/tls/SecretExchangeType;", "serverCertificate", "Ljava/security/cert/Certificate;", "certificateInfo", "Lio/ktor/network/tls/CertificateInfo;", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "negotiate", "receiveServerFinished", "receiveServerHello", "sendChangeCipherSpec", "sendClientCertificate", "Lio/ktor/network/tls/CertificateAndKey;", "info", "(Lio/ktor/network/tls/CertificateInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientCertificateVerify", "certificateAndKey", "(Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/CertificateAndKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientFinished", "masterKey", "(Ljavax/crypto/spec/SecretKeySpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientHello", "sendClientKeyExchange", "preSecret", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;[BLio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendHandshakeRecord", "handshakeType", "Lio/ktor/network/tls/TLSHandshakeType;", "block", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/network/tls/TLSHandshakeType;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyHello", "ktor-network-tls"})
public final class TLSClientHandshake
implements CoroutineScope {
    @NotNull
    private final TLSConfig config;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final BytePacketBuilder digest;
    @NotNull
    private final byte[] clientSeed;
    private volatile TLSServerHello serverHello;
    private volatile SecretKeySpec masterSecret;
    @NotNull
    private final Lazy keyMaterial$delegate;
    @NotNull
    private final Lazy cipher$delegate;
    @NotNull
    private final ReceiveChannel<TLSRecord> input;
    @NotNull
    private final SendChannel<TLSRecord> output;
    @NotNull
    private final ReceiveChannel<TLSHandshake> handshakes;

    public TLSClientHandshake(@NotNull ByteReadChannel rawInput, @NotNull ByteWriteChannel rawOutput, @NotNull TLSConfig config, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)rawInput, (String)"rawInput");
        Intrinsics.checkNotNullParameter((Object)rawOutput, (String)"rawOutput");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.config = config;
        this.coroutineContext = coroutineContext;
        this.digest = UtilsKt.Digest();
        this.clientSeed = TLSClientHandshakeKt.access$generateClientSeed(this.config.getRandom());
        this.keyMaterial$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                Object object = TLSClientHandshake.access$getServerHello$p(this.this$0);
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                object = ((TLSServerHello)object).getCipherSuite();
                TLSClientHandshake tLSClientHandshake = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$invoke_u24lambda_u2d0 = object;
                boolean bl3 = false;
                Object object2 = TLSClientHandshake.access$getMasterSecret$p(tLSClientHandshake);
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
                    throw null;
                }
                SecretKey secretKey = (SecretKey)object2;
                object2 = TLSClientHandshake.access$getServerHello$p(tLSClientHandshake);
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                return KeysKt.keyMaterial(secretKey, ArraysKt.plus((byte[])((TLSServerHello)object2).getServerSeed(), (byte[])TLSClientHandshake.access$getClientSeed$p(tLSClientHandshake)), ((CipherSuite)$this$invoke_u24lambda_u2d0).getKeyStrengthInBytes(), ((CipherSuite)$this$invoke_u24lambda_u2d0).getMacStrengthInBytes(), ((CipherSuite)$this$invoke_u24lambda_u2d0).getFixedIvLength());
            }
        }));
        this.cipher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TLSCipher>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TLSCipher invoke() {
                TLSServerHello tLSServerHello = TLSClientHandshake.access$getServerHello$p(this.this$0);
                if (tLSServerHello == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                return TLSCipher.Companion.fromSuite(tLSServerHello.getCipherSuite(), TLSClientHandshake.access$getKeyMaterial(this.this$0));
            }
        }));
        this.input = ProduceKt.produce$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)new CoroutineName("cio-tls-parser")), (int)0, (Function2)((Function2)new Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object>(rawInput, this, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ByteReadChannel $rawInput;
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.$rawInput = $rawInput;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSRecord> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.output = ActorKt.actor$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)new CoroutineName("cio-tls-encoder")), (int)0, null, null, (Function2)((Function2)new Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object>(this, rawOutput, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteWriteChannel $rawOutput;
            {
                this.this$0 = $receiver;
                this.$rawOutput = $rawOutput;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ActorScope<TLSRecord> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)14, null);
        this.handshakes = ProduceKt.produce$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)new CoroutineName("cio-tls-handshake")), (int)0, (Function2)((Function2)new Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$produce = (ProducerScope)this.L$0;
                        while (true) {
                            this.L$0 = $this$produce;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 1;
                            v0 = this.this$0.getInput().receive((Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl20
                            break;
                        }
                    }
                    case 1: {
                        $this$produce = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((record = (TLSRecord)v0).getType() != TLSRecordType.Handshake) {
                            record.getPacket().release();
                            var4_5 = Intrinsics.stringPlus((String)"TLS handshake expected, got ", (Object)record.getType());
                            var5_7 = false;
                            throw (Throwable)new IllegalStateException(var4_5.toString());
                        }
                        packet = record.getPacket();
lbl26:
                        // 2 sources

                        while (true) {
                            $this$isNotEmpty$iv = packet;
                            $i$f$isNotEmpty = false;
                            if (!($this$isNotEmpty$iv.getEndOfInput() == false)) ** continue;
                            handshake = ParserKt.readTLSHandshake(packet);
                            if (handshake.getType() == TLSHandshakeType.HelloRequest) continue;
                            if (handshake.getType() != TLSHandshakeType.Finished) {
                                var6_9 = this.this$0;
                                UtilsKt.plusAssign-Bb1Az4c(TLSClientHandshake.access$getDigest$p(var6_9), handshake);
                            }
                            this.L$0 = $this$produce;
                            this.L$1 = packet;
                            this.L$2 = handshake;
                            this.label = 2;
                            v1 = $this$produce.getChannel().send((Object)handshake, (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl49
                            break;
                        }
                    }
                    case 2: {
                        var5_6 = (TLSHandshake)this.L$2;
                        var4_5 = (ByteReadPacket)this.L$1;
                        var2_3 = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl49:
                        // 2 sources

                        if (var5_6.getType() == TLSHandshakeType.Finished) ** break;
                        ** continue;
                        var4_5.release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSHandshake> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final byte[] getKeyMaterial() {
        Lazy lazy = this.keyMaterial$delegate;
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    private final TLSCipher getCipher() {
        Lazy lazy = this.cipher$delegate;
        boolean bl = false;
        return (TLSCipher)lazy.getValue();
    }

    @NotNull
    public final ReceiveChannel<TLSRecord> getInput() {
        return this.input;
    }

    public static /* synthetic */ void getInput$annotations() {
    }

    @NotNull
    public final SendChannel<TLSRecord> getOutput() {
        return this.output;
    }

    public static /* synthetic */ void getOutput$annotations() {
    }

    private static /* synthetic */ void getHandshakes$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object negotiate(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof negotiate.1)) ** GOTO lbl-1000
        var11_2 = var1_1;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.negotiate((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$use$iv = Digest.box-impl(this.digest);
                $i$f$use = false;
                closed$iv = 0;
                var5_10 = $this$use$iv.unbox-impl();
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.label = 1;
                v0 = this.sendClientHello((Continuation<? super Unit>)$continuation);
                ** if (v0 != var12_4) goto lbl26
lbl25:
                // 1 sources

                return var12_4;
lbl26:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                var7_14 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = var7_14;
                $continuation.I$0 = closed$iv;
                $continuation.label = 2;
                v1 = this.receiveServerHello((Continuation<? super TLSServerHello>)$continuation);
                ** if (v1 != var12_4) goto lbl46
lbl45:
                // 1 sources

                return var12_4;
lbl46:
                // 1 sources

                ** GOTO lbl58
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                var7_14 = (TLSClientHandshake)$continuation.L$2;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl58:
                // 2 sources

                var8_16 = v1;
                var7_14.serverHello = (TLSServerHello)var8_16;
                var9_17 = this.serverHello;
                if (var9_17 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                this.verifyHello(var9_17);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = null;
                $continuation.I$0 = closed$iv;
                $continuation.label = 3;
                v2 = this.handleCertificatesAndKeys((Continuation<? super Unit>)$continuation);
                ** if (v2 != var12_4) goto lbl73
lbl72:
                // 1 sources

                return var12_4;
lbl73:
                // 1 sources

                ** GOTO lbl84
            }
            case 3: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl84:
                // 2 sources

                $continuation.L$0 = $this$use$iv;
                $continuation.L$1 = null;
                $continuation.I$0 = closed$iv;
                $continuation.label = 4;
                v3 = this.receiveServerFinished((Continuation<? super Unit>)$continuation);
                ** if (v3 != var12_4) goto lbl91
lbl90:
                // 1 sources

                return var12_4;
lbl91:
                // 1 sources

                ** GOTO lbl101
            }
            case 4: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl101:
                    // 2 sources

                    var5_10 = Unit.INSTANCE;
                }
                catch (Throwable first$iv) {
                    try {
                        try {
                            closed$iv = 1;
                            $this$use$iv.close();
                        }
                        catch (Throwable second$iv) {
                            CloseableJVMKt.addSuppressedInternal((Throwable)first$iv, (Throwable)second$iv);
                        }
                        throw first$iv;
                    }
                    catch (Throwable var6_13) {
                        if (closed$iv == 0) {
                            $this$use$iv.close();
                        }
                        throw var6_13;
                    }
                }
                $this$use$iv.close();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyHello(TLSServerHello serverHello) {
        boolean bl;
        List<HashAndSign> serverExchanges;
        List clientExchanges;
        block8: {
            void $this$filterTo$iv$iv;
            CipherSuite suite = serverHello.getCipherSuite();
            boolean bl2 = this.config.getCipherSuites().contains(suite);
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Unsupported cipher suite " + suite.getName() + " in SERVER_HELLO";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable $this$filter$iv = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
            boolean $i$f$filter = false;
            Iterable bl5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HashAndSign it = (HashAndSign)element$iv$iv;
                boolean bl6 = false;
                if (!(it.getHash() == suite.getHash() && it.getSign() == suite.getSignatureAlgorithm())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            clientExchanges = (List)destination$iv$iv;
            if (clientExchanges.isEmpty()) {
                throw new TLSException(Intrinsics.stringPlus((String)"No appropriate hash algorithm for suite: ", (Object)suite), null, 2, null);
            }
            serverExchanges = serverHello.getHashAndSignAlgorithms();
            if (serverExchanges.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = clientExchanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HashAndSign it = (HashAndSign)element$iv;
                    boolean bl7 = false;
                    if (!serverExchanges.contains(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            String message = "No sign algorithms in common. \nServer candidates: " + serverExchanges + " \nClient candidates: " + clientExchanges;
            throw new TLSException(message, null, 2, null);
        }
    }

    private final Object sendClientHello(Continuation<? super Unit> $completion) {
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientHello, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter((Object)$this$sendHandshakeRecord, (String)"$this$sendHandshakeRecord");
                RenderKt.writeTLSClientHello($this$sendHandshakeRecord, TLSVersion.TLS12, TLSClientHandshake.access$getConfig$p(this.this$0).getCipherSuites(), TLSClientHandshake.access$getClientSeed$p(this.this$0), new byte[32], TLSClientHandshake.access$getConfig$p(this.this$0).getServerName());
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object receiveServerHello(Continuation<? super TLSServerHello> var1_1) {
        if (!(var1_1 instanceof receiveServerHello.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$receiveServerHello(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.handshakes.receive((Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var3_6 = (handshake = (TLSHandshake)v0).getType() == TLSHandshakeType.ServerHello;
                var4_7 = false;
                var5_8 = false;
                if (!var3_6) {
                    $i$a$-check-TLSClientHandshake$receiveServerHello$2 = false;
                    var5_9 = Intrinsics.stringPlus((String)"Expected TLS handshake ServerHello but got ", (Object)handshake.getType());
                    throw (Throwable)new IllegalStateException(var5_9.toString());
                }
                return ParserKt.readTLSServerHello(handshake.getPacket());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object handleCertificatesAndKeys(Continuation<? super Unit> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleServerDone(SecretExchangeType var1_1, Certificate var2_2, CertificateInfo var3_3, EncryptionInfo var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof handleServerDone.1)) ** GOTO lbl-1000
        var15_6 = var5_5;
        if ((var15_6.label & -2147483648) != 0) {
            var15_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$handleServerDone(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var7_9 = certificateInfo;
                if (var7_9 != null) ** GOTO lbl16
                v0 = null;
                ** GOTO lbl42
lbl16:
                // 1 sources

                var8_10 = var7_9;
                var9_11 = false;
                var10_13 = false;
                it = var8_10;
                $i$a$-let-TLSClientHandshake$handleServerDone$chain$1 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = exchangeType;
                $continuation.L$2 = serverCertificate;
                $continuation.L$3 = certificateInfo;
                $continuation.L$4 = encryptionInfo;
                $continuation.label = 1;
                v1 = this.sendClientCertificate((CertificateInfo)it, (Continuation<? super CertificateAndKey>)$continuation);
                if (v1 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl40
            }
            case 1: {
                $i$a$-let-TLSClientHandshake$handleServerDone$chain$1 = false;
                encryptionInfo = (EncryptionInfo)$continuation.L$4;
                certificateInfo = (CertificateInfo)$continuation.L$3;
                serverCertificate = (Certificate)$continuation.L$2;
                exchangeType = (SecretExchangeType)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                v0 = (CertificateAndKey)v1;
lbl42:
                // 2 sources

                chain = v0;
                preSecret = this.generatePreSecret(encryptionInfo);
                $continuation.L$0 = this;
                $continuation.L$1 = certificateInfo;
                $continuation.L$2 = chain;
                $continuation.L$3 = preSecret;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v2 = this.sendClientKeyExchange(exchangeType, serverCertificate, preSecret, encryptionInfo, (Continuation<? super Unit>)$continuation);
                if (v2 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl61
            }
            case 2: {
                preSecret = (byte[])$continuation.L$3;
                chain = (CertificateAndKey)$continuation.L$2;
                var3_3 = (CertificateInfo)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl61:
                // 2 sources

                if ((var8_10 = this.serverHello) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                v3 = new SecretKeySpec(preSecret, var8_10.getCipherSuite().getHash().getMacName());
                var8_10 = this.serverHello;
                if (var8_10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                this.masterSecret = KeysKt.masterSecret(v3, this.clientSeed, var8_10.getServerSeed());
                ArraysKt.fill$default((byte[])preSecret, (byte)0, (int)0, (int)0, (int)6, null);
                var8_10 = chain;
                if (var8_10 != null) {
                    var9_12 = var8_10;
                    var10_13 = false;
                    var11_15 = false;
                    it = var9_12;
                    $i$a$-let-TLSClientHandshake$handleServerDone$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.label = 3;
                    v4 = this.sendClientCertificateVerify(var3_3, (CertificateAndKey)it, (Continuation<? super Unit>)$continuation);
                    if (v4 == var16_8) {
                        return var16_8;
                    }
                }
                ** GOTO lbl93
            }
            case 3: {
                $i$a$-let-TLSClientHandshake$handleServerDone$2 = false;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl93:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 4;
                v5 = this.sendChangeCipherSpec((Continuation<? super Unit>)$continuation);
                if (v5 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl106
            }
            case 4: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl106:
                // 2 sources

                if ((var8_10 = this.masterSecret) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
                    throw null;
                }
                $continuation.L$0 = null;
                $continuation.label = 5;
                v6 = this.sendClientFinished((SecretKeySpec)var8_10, (Continuation<? super Unit>)$continuation);
                if (v6 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl118
            }
            case 5: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl118:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final byte[] generatePreSecret(EncryptionInfo encryptionInfo) {
        byte[] byArray;
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
            throw null;
        }
        SecretExchangeType secretExchangeType = tLSServerHello.getCipherSuite().getExchangeType();
        int n = WhenMappings.$EnumSwitchMapping$1[secretExchangeType.ordinal()];
        switch (n) {
            case 2: {
                byte[] byArray2 = new byte[48];
                boolean bl = false;
                boolean bl2 = false;
                byte[] it = byArray2;
                boolean bl3 = false;
                this.config.getRandom().nextBytes(it);
                it[0] = 3;
                it[1] = 3;
                byArray = byArray2;
                break;
            }
            case 1: {
                KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                Intrinsics.checkNotNull((Object)keyAgreement);
                KeyAgreement keyAgreement2 = keyAgreement;
                boolean bl = false;
                boolean bl4 = false;
                KeyAgreement $this$generatePreSecret_u24lambda_u2d13 = keyAgreement2;
                boolean bl5 = false;
                if (encryptionInfo == null) {
                    throw new TLSException("ECDHE_ECDSA: Encryption info should be provided", null, 2, null);
                }
                $this$generatePreSecret_u24lambda_u2d13.init(encryptionInfo.getClientPrivate());
                $this$generatePreSecret_u24lambda_u2d13.doPhase(encryptionInfo.getServerPublic(), true);
                byte[] byArray3 = $this$generatePreSecret_u24lambda_u2d13.generateSecret();
                byArray = byArray3;
                Intrinsics.checkNotNull((Object)byArray3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    private final Object sendClientKeyExchange(SecretExchangeType exchangeType, Certificate serverCertificate, byte[] preSecret, EncryptionInfo encryptionInfo, Continuation<? super Unit> $completion) {
        ByteReadPacket byteReadPacket;
        SecretExchangeType secretExchangeType = exchangeType;
        int n = WhenMappings.$EnumSwitchMapping$1[secretExchangeType.ordinal()];
        switch (n) {
            case 2: {
                int headerSizeHint$iv = 0;
                boolean $i$f$buildPacket = false;
                boolean bl = false;
                BytePacketBuilder builder$iv22 = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    BytePacketBuilder $this$sendClientKeyExchange_u24lambda_u2d14 = builder$iv22;
                    boolean bl2 = false;
                    PublicKey publicKey = serverCertificate.getPublicKey();
                    Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"serverCertificate.publicKey");
                    RenderKt.writeEncryptedPreMasterSecret($this$sendClientKeyExchange_u24lambda_u2d14, preSecret, publicKey, this.config.getRandom());
                    byteReadPacket = builder$iv22.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv22.release();
                    throw t$iv;
                }
            }
            case 1: {
                int headerSizeHint$iv = 0;
                boolean $i$f$buildPacket = false;
                boolean builder$iv22 = false;
                BytePacketBuilder builder$iv22 = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    BytePacketBuilder $this$sendClientKeyExchange_u24lambda_u2d15 = builder$iv22;
                    boolean bl = false;
                    if (encryptionInfo == null) {
                        throw new TLSException("ECDHE: Encryption info should be provided", null, 2, null);
                    }
                    RenderKt.writePublicKeyUncompressed($this$sendClientKeyExchange_u24lambda_u2d15, encryptionInfo.getClientPublic());
                    byteReadPacket = builder$iv22.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv22.release();
                    throw t$iv;
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ByteReadPacket packet2 = byteReadPacket;
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientKeyExchange, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(packet2){
            final /* synthetic */ ByteReadPacket $packet;
            {
                this.$packet = $packet;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter((Object)$this$sendHandshakeRecord, (String)"$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writePacket(this.$packet);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendClientCertificate(CertificateInfo var1_1, Continuation<? super CertificateAndKey> var2_2) {
        if (!(var2_2 instanceof sendClientCertificate.1)) ** GOTO lbl-1000
        var29_3 = var2_2;
        if ((var29_3.label & -2147483648) != 0) {
            var29_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendClientCertificate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var30_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = this.config.getCertificates();
                var5_7 = false;
                var6_8 = var4_6;
                var7_9 = false;
                for (T var9_11 : var6_8) {
                    candidate = (CertificateAndKey)var9_11;
                    $i$a$-find-TLSClientHandshake$sendClientCertificate$chainAndKey$1 = false;
                    leaf = (X509Certificate)ArraysKt.first((Object[])candidate.getCertificateChain());
                    var13_15 = leaf.getPublicKey().getAlgorithm();
                    v0 = Intrinsics.areEqual((Object)var13_15, (Object)"RSA") != false ? ArraysKt.contains((byte[])info.getTypes(), (byte)CertificateType.INSTANCE.getRSA()) : (validAlgorithm = Intrinsics.areEqual((Object)var13_15, (Object)"DSS") != false ? ArraysKt.contains((byte[])info.getTypes(), (byte)CertificateType.INSTANCE.getDSS()) : false);
                    if (validAlgorithm) ** GOTO lbl25
                    v1 = false;
                    ** GOTO lbl72
lbl25:
                    // 1 sources

                    $this$none$iv = info.getHashAndSign();
                    $i$f$none = false;
                    var17_20 = $this$none$iv;
                    var18_21 = ((HashAndSign[])var17_20).length;
                    for (var19_23 = 0; var19_23 < var18_21; ++var19_23) {
                        it = element$iv = var17_20[var19_23];
                        $i$a$-none-TLSClientHandshake$sendClientCertificate$chainAndKey$1$hasHashAndSignInCommon$1 = false;
                        if (!Boxing.boxBoolean((boolean)StringsKt.equals((String)it.getName(), (String)leaf.getSigAlgName(), (boolean)true)).booleanValue()) continue;
                        v2 = false;
                        ** GOTO lbl36
                    }
                    v2 = hasHashAndSignInCommon = true;
lbl36:
                    // 2 sources

                    if (!hasHashAndSignInCommon) ** GOTO lbl39
                    v1 = false;
                    ** GOTO lbl72
lbl39:
                    // 1 sources

                    if (info.getAuthorities().isEmpty()) ** GOTO lbl-1000
                    $this$map$iv = candidate.getCertificateChain();
                    $i$f$map = false;
                    var17_20 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    element$iv = $this$mapTo$iv$iv;
                    var21_28 = ((HashAndSign)element$iv).length;
                    for (var22_29 = 0; var22_29 < var21_28; ++var22_29) {
                        var24_31 = item$iv$iv = element$iv[var22_29];
                        var25_32 = destination$iv$iv;
                        $i$a$-map-TLSClientHandshake$sendClientCertificate$chainAndKey$1$1 = false;
                        var27_34 = new X500Principal(it.getIssuerDN().getName());
                        var25_32.add(var27_34);
                    }
                    $this$any$iv = (List)destination$iv$iv;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl60
                    v3 = false;
                    ** GOTO lbl67
lbl60:
                    // 2 sources

                    for (E element$iv : $this$any$iv) {
                        it = (X500Principal)element$iv;
                        $i$a$-any-TLSClientHandshake$sendClientCertificate$chainAndKey$1$2 = false;
                        if (!Boxing.boxBoolean((boolean)info.getAuthorities().contains(it)).booleanValue()) continue;
                        v3 = true;
                        ** GOTO lbl67
                    }
                    v3 = false;
lbl67:
                    // 3 sources

                    if (v3) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
lbl72:
                    // 4 sources

                    if (!Boxing.boxBoolean((boolean)v1).booleanValue()) continue;
                    v4 = var9_11;
                    ** GOTO lbl76
                }
                v4 = null;
lbl76:
                // 2 sources

                chainAndKey = v4;
                $continuation.L$0 = chainAndKey;
                $continuation.label = 1;
                v5 = this.sendHandshakeRecord(TLSHandshakeType.Certificate, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(chainAndKey){
                    final /* synthetic */ CertificateAndKey $chainAndKey;
                    {
                        this.$chainAndKey = $chainAndKey;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                        Intrinsics.checkNotNullParameter((Object)$this$sendHandshakeRecord, (String)"$this$sendHandshakeRecord");
                        CertificateAndKey certificateAndKey = this.$chainAndKey;
                        X509Certificate[] x509CertificateArray = certificateAndKey == null ? null : certificateAndKey.getCertificateChain();
                        RenderKt.writeTLSCertificates($this$sendHandshakeRecord, x509CertificateArray == null ? new X509Certificate[]{} : x509CertificateArray);
                    }
                }), (Continuation<? super Unit>)$continuation);
                if (v5 == var30_5) {
                    return var30_5;
                }
                ** GOTO lbl87
            }
            case 1: {
                chainAndKey = (CertificateAndKey)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl87:
                // 2 sources

                return chainAndKey;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object sendClientCertificateVerify(CertificateInfo info, CertificateAndKey certificateAndKey, Continuation<? super Unit> $completion) {
        HashAndSign hashAndSign;
        block4: {
            HashAndSign hashAndSign2;
            X509Certificate leaf = (X509Certificate)ArraysKt.first((Object[])certificateAndKey.getCertificateChain());
            HashAndSign[] $this$firstOrNull$iv = info.getHashAndSign();
            boolean $i$f$firstOrNull = false;
            HashAndSign[] hashAndSignArray = $this$firstOrNull$iv;
            int n = hashAndSignArray.length;
            for (int i = 0; i < n; ++i) {
                HashAndSign element$iv;
                HashAndSign it = element$iv = hashAndSignArray[i];
                boolean bl = false;
                if (!Boxing.boxBoolean((boolean)StringsKt.equals((String)it.getName(), (String)leaf.getSigAlgName(), (boolean)true)).booleanValue()) continue;
                hashAndSign2 = element$iv;
                break block4;
            }
            hashAndSign2 = hashAndSign = null;
        }
        if (hashAndSign == null) {
            return Unit.INSTANCE;
        }
        HashAndSign hashAndSign3 = hashAndSign;
        if (hashAndSign3.getSign() == SignatureAlgorithm.DSA) {
            return Unit.INSTANCE;
        }
        Signature signature = Signature.getInstance(((X509Certificate)ArraysKt.first((Object[])certificateAndKey.getCertificateChain())).getSigAlgName());
        Intrinsics.checkNotNull((Object)signature);
        Signature sign = signature;
        sign.initSign(certificateAndKey.getKey());
        Object object = this.sendHandshakeRecord(TLSHandshakeType.CertificateVerify, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(hashAndSign3, this, sign){
            final /* synthetic */ HashAndSign $hashAndSign;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ Signature $sign;
            {
                this.$hashAndSign = $hashAndSign;
                this.this$0 = $receiver;
                this.$sign = $sign;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                void $this$preview$iv;
                Intrinsics.checkNotNullParameter((Object)$this$sendHandshakeRecord, (String)"$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getHash().getCode());
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getSign().getCode());
                BytePacketBuilder bytePacketBuilder = TLSClientHandshake.access$getDigest$p(this.this$0);
                Signature signature = this.$sign;
                boolean $i$f$preview = false;
                boolean bl = false;
                ByteReadPacket packet$iv = PreviewKt.preview((BytePacketBuilder)$this$preview$iv);
                try {
                    ByteReadPacket it = packet$iv;
                    boolean bl2 = false;
                    signature.update(io.ktor.utils.io.core.StringsKt.readBytes$default((ByteReadPacket)it, (int)0, (int)1, null));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    packet$iv.release();
                }
                byte[] byArray = this.$sign.sign();
                Intrinsics.checkNotNull((Object)byArray);
                byte[] signBytes = byArray;
                OutputPrimitivesKt.writeShort((Output)((Output)$this$sendHandshakeRecord), (short)((short)signBytes.length));
                OutputKt.writeFully$default((Output)((Output)$this$sendHandshakeRecord), (byte[])signBytes, (int)0, (int)0, (int)6, null);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendChangeCipherSpec(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof sendChangeCipherSpec.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendChangeCipherSpec(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                headerSizeHint$iv = 0;
                $i$f$buildPacket = false;
                var5_8 = false;
                builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    $this$sendChangeCipherSpec_u24lambda_u2d21 = builder$iv;
                    $i$a$-buildPacket$default-TLSClientHandshake$sendChangeCipherSpec$packet$1 = false;
                    $this$sendChangeCipherSpec_u24lambda_u2d21.writeByte((byte)1);
                    v0 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                packet = v0;
                $continuation.L$0 = packet;
                $continuation.label = 1;
                v1 = this.getOutput().send((Object)new TLSRecord(TLSRecordType.ChangeCipherSpec, null, packet, 2, null), (Continuation)$continuation);
                ** if (v1 != var10_4) goto lbl35
lbl34:
                // 1 sources

                return var10_4;
lbl35:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                packet = (ByteReadPacket)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Throwable cause) {
                    packet.release();
                    throw cause;
                }
lbl46:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object sendClientFinished(SecretKeySpec masterKey, Continuation<? super Unit> $completion) {
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
            throw null;
        }
        byte[] checksum = Digest.doHash-impl(this.digest, tLSServerHello.getCipherSuite().getHash().getOpenSSLName());
        ByteReadPacket finished = RenderKt.finished(checksum, masterKey);
        Object object = this.sendHandshakeRecord(TLSHandshakeType.Finished, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(finished){
            final /* synthetic */ ByteReadPacket $finished;
            {
                this.$finished = $finished;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter((Object)$this$sendHandshakeRecord, (String)"$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writePacket(this.$finished);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object receiveServerFinished(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof receiveServerFinished.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$receiveServerFinished(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.handshakes.receive((Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((finished = (TLSHandshake)v0).getType() != TLSHandshakeType.Finished) {
                    throw new TLSException(Intrinsics.stringPlus((String)"Finished handshake expected, received: ", (Object)finished), null, 2, null);
                }
                receivedChecksum = io.ktor.utils.io.core.StringsKt.readBytes$default((ByteReadPacket)finished.getPacket(), (int)0, (int)1, null);
                var5_7 = this.serverHello;
                if (var5_7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                    throw null;
                }
                v1 = Digest.doHash-impl(this.digest, var5_7.getCipherSuite().getHash().getOpenSSLName());
                var5_7 = this.masterSecret;
                if (var5_7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
                    throw null;
                }
                expectedChecksum = RenderKt.serverFinished(v1, (SecretKey)var5_7, receivedChecksum.length);
                var5_7 = receivedChecksum;
                var6_9 = false;
                if (!Arrays.equals((byte[])var5_7, expectedChecksum)) {
                    throw new TLSException(StringsKt.trimMargin$default((String)("Handshake: ServerFinished verification failed:\n                |Expected: " + ArraysKt.joinToString$default((byte[])expectedChecksum, null, null, null, (int)0, null, null, (int)63, null) + "\n                |Actual: " + ArraysKt.joinToString$default((byte[])receivedChecksum, null, null, null, (int)0, null, null, (int)63, null) + "\n            "), null, (int)1, null), null, 2, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendHandshakeRecord(TLSHandshakeType var1_1, Function1<? super BytePacketBuilder, Unit> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof sendHandshakeRecord.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendHandshakeRecord(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                headerSizeHint$iv = 0;
                $i$f$buildPacket = false;
                var7_11 = false;
                builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    block.invoke((Object)builder$iv);
                    v0 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                handshakeBody = v0;
                headerSizeHint$iv = 0;
                $i$f$buildPacket = false;
                t$iv = false;
                builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    $this$sendHandshakeRecord_u24lambda_u2d22 = builder$iv;
                    $i$a$-buildPacket$default-TLSClientHandshake$sendHandshakeRecord$recordBody$1 = false;
                    RenderKt.writeTLSHandshakeType($this$sendHandshakeRecord_u24lambda_u2d22, (TLSHandshakeType)handshakeType, (int)handshakeBody.getRemaining());
                    $this$sendHandshakeRecord_u24lambda_u2d22.writePacket(handshakeBody);
                    v1 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                recordBody = v1;
                Digest.update-impl(this.digest, recordBody);
                element = new TLSRecord(TLSRecordType.Handshake, null, recordBody, 2, null);
                $continuation.L$0 = element;
                $continuation.label = 1;
                v2 = this.getOutput().send((Object)element, (Continuation)$continuation);
                ** if (v2 != var14_6) goto lbl54
lbl53:
                // 1 sources

                return var14_6;
lbl54:
                // 1 sources

                ** GOTO lbl65
            }
            case 1: {
                element = (TLSRecord)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (Throwable cause) {
                    element.getPacket().release();
                    throw cause;
                }
lbl65:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$sendClientHello(TLSClientHandshake $this, Continuation $completion) {
        return $this.sendClientHello((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TLSConfig access$getConfig$p(TLSClientHandshake $this) {
        return $this.config;
    }

    public static final /* synthetic */ byte[] access$getClientSeed$p(TLSClientHandshake $this) {
        return $this.clientSeed;
    }

    public static final /* synthetic */ Object access$receiveServerHello(TLSClientHandshake $this, Continuation $completion) {
        return $this.receiveServerHello((Continuation<? super TLSServerHello>)$completion);
    }

    public static final /* synthetic */ Object access$handleCertificatesAndKeys(TLSClientHandshake $this, Continuation $completion) {
        return $this.handleCertificatesAndKeys((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleServerDone(TLSClientHandshake $this, SecretExchangeType exchangeType, Certificate serverCertificate, CertificateInfo certificateInfo, EncryptionInfo encryptionInfo, Continuation $completion) {
        return $this.handleServerDone(exchangeType, serverCertificate, certificateInfo, encryptionInfo, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendClientKeyExchange(TLSClientHandshake $this, SecretExchangeType exchangeType, Certificate serverCertificate, byte[] preSecret, EncryptionInfo encryptionInfo, Continuation $completion) {
        return $this.sendClientKeyExchange(exchangeType, serverCertificate, preSecret, encryptionInfo, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendClientCertificate(TLSClientHandshake $this, CertificateInfo info, Continuation $completion) {
        return $this.sendClientCertificate(info, (Continuation<? super CertificateAndKey>)$completion);
    }

    public static final /* synthetic */ Object access$sendClientCertificateVerify(TLSClientHandshake $this, CertificateInfo info, CertificateAndKey certificateAndKey, Continuation $completion) {
        return $this.sendClientCertificateVerify(info, certificateAndKey, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ BytePacketBuilder access$getDigest$p(TLSClientHandshake $this) {
        return $this.digest;
    }

    public static final /* synthetic */ Object access$sendChangeCipherSpec(TLSClientHandshake $this, Continuation $completion) {
        return $this.sendChangeCipherSpec((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendClientFinished(TLSClientHandshake $this, SecretKeySpec masterKey, Continuation $completion) {
        return $this.sendClientFinished(masterKey, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$receiveServerFinished(TLSClientHandshake $this, Continuation $completion) {
        return $this.receiveServerFinished((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendHandshakeRecord(TLSClientHandshake $this, TLSHandshakeType handshakeType, Function1 block, Continuation $completion) {
        return $this.sendHandshakeRecord(handshakeType, (Function1<? super BytePacketBuilder, Unit>)block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TLSServerHello access$getServerHello$p(TLSClientHandshake $this) {
        return $this.serverHello;
    }

    public static final /* synthetic */ SecretKeySpec access$getMasterSecret$p(TLSClientHandshake $this) {
        return $this.masterSecret;
    }

    public static final /* synthetic */ byte[] access$getKeyMaterial(TLSClientHandshake $this) {
        return $this.getKeyMaterial();
    }

    public static final /* synthetic */ TLSCipher access$getCipher(TLSClientHandshake $this) {
        return $this.getCipher();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TLSHandshakeType.values().length];
            nArray[TLSHandshakeType.Certificate.ordinal()] = 1;
            nArray[TLSHandshakeType.CertificateRequest.ordinal()] = 2;
            nArray[TLSHandshakeType.ServerKeyExchange.ordinal()] = 3;
            nArray[TLSHandshakeType.ServerDone.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SecretExchangeType.values().length];
            nArray[SecretExchangeType.ECDHE.ordinal()] = 1;
            nArray[SecretExchangeType.RSA.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

