/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a%\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u001c\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a(\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u001a/\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\b\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004\u00a8\u0006\u0015"}, d2={"findTrustManager", "Ljavax/net/ssl/X509TrustManager;", "addCertificateChain", "", "Lio/ktor/network/tls/TLSConfigBuilder;", "chain", "", "Ljava/security/cert/X509Certificate;", "key", "Ljava/security/PrivateKey;", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "addKeyStore", "store", "Ljava/security/KeyStore;", "password", "", "alias", "", "addKeyStoreNullablePassword", "takeFrom", "other", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void takeFrom(@NotNull TLSConfigBuilder $this$takeFrom, @NotNull TLSConfigBuilder other) {
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        TLSConfigBuilder tLSConfigBuilder = $this$takeFrom;
        Collection collection = tLSConfigBuilder.getCertificates();
        Iterable iterable = other.getCertificates();
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        $this$takeFrom.setRandom(other.getRandom());
        $this$takeFrom.setCipherSuites(other.getCipherSuites());
        $this$takeFrom.setServerName(other.getServerName());
        $this$takeFrom.setTrustManager(other.getTrustManager());
    }

    public static final void addCertificateChain(@NotNull TLSConfigBuilder $this$addCertificateChain, @NotNull X509Certificate[] chain, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$addCertificateChain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        TLSConfigBuilder tLSConfigBuilder = $this$addCertificateChain;
        Collection collection = tLSConfigBuilder.getCertificates();
        CertificateAndKey certificateAndKey = new CertificateAndKey(chain, key);
        boolean bl = false;
        collection.add(certificateAndKey);
    }

    @Deprecated(message="Binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void addKeyStore(TLSConfigBuilder $this$addKeyStore, KeyStore store, char[] password) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        TLSConfigBuilderKt.addKeyStoreNullablePassword$default($this$addKeyStore, store, password, null, 4, null);
    }

    @Deprecated(message="Please use the nullable overload", replaceWith=@ReplaceWith(expression="addKeyStore(store, password as CharArray?, alias)", imports={}), level=DeprecationLevel.WARNING)
    public static final void addKeyStore(@NotNull TLSConfigBuilder $this$addKeyStore, @NotNull KeyStore store, @NotNull char[] password, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        TLSConfigBuilderKt.addKeyStoreNullablePassword($this$addKeyStore, store, password, alias);
    }

    public static /* synthetic */ void addKeyStore$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStore(tLSConfigBuilder, keyStore, cArray, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="addKeyStoreNullablePassword")
    public static final void addKeyStoreNullablePassword(@NotNull TLSConfigBuilder $this$addKeyStore, @NotNull KeyStore store, @Nullable char[] password, @Nullable String alias) {
        List list;
        List list2;
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addKeyStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        String string = KeyManagerFactory.getDefaultAlgorithm();
        Intrinsics.checkNotNull((Object)string);
        String keyManagerAlgorithm = string;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        Intrinsics.checkNotNull((Object)keyManagerFactory);
        KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
        keyManagerFactory2.init(store, password);
        KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
        Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"keyManagerFactory.keyManagers");
        Object[] $this$filterIsInstance$iv = keyManagerArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (PrivateKey element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509KeyManager)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List managers = (List)destination$iv$iv2;
        $this$filterIsInstanceTo$iv$iv = alias;
        if ($this$filterIsInstanceTo$iv$iv == null) {
            list2 = null;
        } else {
            destination$iv$iv2 = $this$filterIsInstanceTo$iv$iv;
            $i$f$filterIsInstanceTo = false;
            boolean bl = false;
            Object it = destination$iv$iv2;
            boolean bl2 = false;
            list2 = CollectionsKt.listOf((Object)it);
        }
        List list3 = list2;
        if (list3 == null) {
            Enumeration<String> enumeration = store.aliases();
            Intrinsics.checkNotNull(enumeration);
            $this$filterIsInstanceTo$iv$iv = enumeration;
            boolean destination$iv$iv2 = false;
            ArrayList arrayList = Collections.list($this$filterIsInstanceTo$iv$iv);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            list = arrayList;
        } else {
            list = list3;
        }
        List aliases = list;
        block1: for (String certAlias : aliases) {
            boolean bl;
            Certificate[] it;
            boolean $i$f$all2;
            Certificate[] chain;
            block12: {
                chain = store.getCertificateChain(certAlias);
                $i$f$filterIsInstanceTo = false;
                boolean bl3 = false;
                if (chain == null) {
                    boolean bl4 = false;
                    String string2 = Intrinsics.stringPlus((String)"Fail to get the certificate chain for this alias: ", (Object)certAlias);
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                Certificate[] $this$all$iv = chain;
                $i$f$all2 = false;
                Certificate[] bl2 = $this$all$iv;
                int element$iv$iv = bl2.length;
                for (int i = 0; i < element$iv$iv; ++i) {
                    Certificate[] element$iv;
                    it = element$iv = bl2[i];
                    boolean bl5 = false;
                    if (it instanceof X509Certificate) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
            boolean allX509 = bl;
            boolean bl6 = false;
            $i$f$all2 = false;
            if (!allX509) {
                boolean bl7 = false;
                String $i$f$all2 = "Fail to add key store " + store + ". Only X509 certificate format supported.";
                throw (Throwable)new IllegalStateException($i$f$all2.toString());
            }
            for (X509KeyManager manager : managers) {
                void $this$mapTo$iv$iv;
                PrivateKey element$iv$iv;
                element$iv$iv = manager.getPrivateKey(certAlias);
                if (element$iv$iv == null) continue;
                PrivateKey key = element$iv$iv;
                Certificate[] $this$map$iv = chain;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var21_38 = $this$mapTo$iv$iv;
                int n = ((void)var21_38).length;
                for (int i = 0; i < n; ++i) {
                    void it2;
                    void item$iv$iv;
                    void var25_42 = item$iv$iv = var21_38[i];
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    X509Certificate x509Certificate = (X509Certificate)it2;
                    collection.add(x509Certificate);
                }
                List map = (List)destination$iv$iv3;
                Collection $this$toTypedArray$iv = map;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
                if (x509CertificateArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                TLSConfigBuilderKt.addCertificateChain($this$addKeyStore, x509CertificateArray, key);
                continue block1;
            }
            throw new NoPrivateKeyException(certAlias, store);
        }
    }

    public static /* synthetic */ void addKeyStoreNullablePassword$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStoreNullablePassword(tLSConfigBuilder, keyStore, cArray, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final X509TrustManager findTrustManager() {
        void $this$filterIsInstanceTo$iv$iv;
        TrustManager[] manager;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNull((Object)trustManagerFactory);
        TrustManagerFactory factory = trustManagerFactory;
        factory.init((KeyStore)null);
        TrustManager[] trustManagerArray = factory.getTrustManagers();
        Intrinsics.checkNotNull((Object)trustManagerArray);
        TrustManager[] $this$filterIsInstance$iv = manager = trustManagerArray;
        boolean $i$f$filterIsInstance = false;
        TrustManager[] trustManagerArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509TrustManager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (X509TrustManager)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

