/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.util.CryptoKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ktor/network/tls/cipher/CBCCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "(Lio/ktor/network/tls/CipherSuite;[B)V", "inputCounter", "", "outputCounter", "receiveCipher", "Ljavax/crypto/Cipher;", "receiveKey", "Ljavax/crypto/spec/SecretKeySpec;", "receiveMac", "Ljavax/crypto/Mac;", "sendCipher", "sendKey", "sendMac", "decrypt", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "prepareMac", "content", "validateMac", "", "macOffset", "", "validatePadding", "paddingStart", "writePadding", "Lio/ktor/utils/io/core/BytePacketBuilder;", "ktor-network-tls"})
public final class CBCCipher
implements TLSCipher {
    @NotNull
    private final CipherSuite suite;
    @NotNull
    private final byte[] keyMaterial;
    @NotNull
    private final Cipher sendCipher;
    @NotNull
    private final SecretKeySpec sendKey;
    @NotNull
    private final Mac sendMac;
    @NotNull
    private final Cipher receiveCipher;
    @NotNull
    private final SecretKeySpec receiveKey;
    @NotNull
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;

    public CBCCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)keyMaterial2, (String)"keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher2);
        this.sendCipher = cipher2;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac);
        this.sendMac = mac;
        Cipher cipher3 = Cipher.getInstance(this.suite.getJdkCipherName());
        Intrinsics.checkNotNull((Object)cipher3);
        this.receiveCipher = cipher3;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        Intrinsics.checkNotNull((Object)mac2);
        this.receiveMac = mac2;
    }

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce((int)this.suite.getFixedIvLength())));
        byte[] content = StringsKt.readBytes$default((ByteReadPacket)record.getPacket(), (int)0, (int)1, null);
        byte[] macBytes = this.prepareMac(record, content);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$encrypt_u24lambda_u2d0 = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully$default((Output)((Output)$this$encrypt_u24lambda_u2d0), (byte[])content, (int)0, (int)0, (int)6, null);
            OutputKt.writeFully$default((Output)((Output)$this$encrypt_u24lambda_u2d0), (byte[])macBytes, (int)0, (int)0, (int)6, null);
            this.writePadding($this$encrypt_u24lambda_u2d0);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encryptionData = byteReadPacket;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(encryptionData, this.sendCipher, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ CBCCipher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"$this$cipherLoop");
                Output output2 = (Output)$this$cipherLoop;
                byte[] byArray = CBCCipher.access$getSendCipher$p(this.this$0).getIV();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sendCipher.iv");
                OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
            }
        }));
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ByteReadPacket packet2 = record.getPacket();
        byte[] serverIV = StringsKt.readBytes((ByteReadPacket)packet2, (int)this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(serverIV));
        byte[] content = StringsKt.readBytes$default((ByteReadPacket)CipherUtilsKt.cipherLoop$default(packet2, this.receiveCipher, null, 2, null), (int)0, (int)1, null);
        int paddingLength = content[content.length - 1] & 0xFF;
        int paddingStart = content.length - paddingLength - 1;
        int macStart = paddingStart - this.suite.getMacStrengthInBytes();
        this.validatePadding(content, paddingStart);
        this.validateMac(record, content, macStart);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$decrypt_u24lambda_u2d1 = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully((Output)((Output)$this$decrypt_u24lambda_u2d1), (byte[])content, (int)0, (int)macStart);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket decryptedContent = byteReadPacket;
        return new TLSRecord(record.getType(), record.getVersion(), decryptedContent);
    }

    private final byte[] prepareMac(TLSRecord record, byte[] content) {
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        Object object = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = object;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.outputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)content.length);
        byte[] header = object;
        object = this;
        ++object.outputCounter;
        this.sendMac.update(header);
        object = this.sendMac.doFinal(content);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sendMac.doFinal(content)");
        return object;
    }

    private final void writePadding(BytePacketBuilder $this$writePadding) {
        int lastBlockSize = ($this$writePadding.getSize() + 1) % this.sendCipher.getBlockSize();
        byte paddingSize = (byte)(this.sendCipher.getBlockSize() - lastBlockSize);
        int n = paddingSize + 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            $this$writePadding.writeByte(paddingSize);
        }
    }

    private final void validatePadding(byte[] content, int paddingStart) {
        int padding = content[content.length - 1] & 0xFF;
        int n = paddingStart;
        int n2 = content.length;
        if (n < n2) {
            do {
                int i;
                int n3;
                if (padding == (n3 = content[i = n++] & 0xFF)) continue;
                throw new TLSException("Padding invalid: expected " + padding + ", actual " + n3, null, 2, null);
            } while (n < n2);
        }
    }

    private final void validateMac(TLSRecord record, byte[] content, int macOffset) {
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        Object object = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = object;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.inputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)macOffset);
        byte[] header = object;
        object = this;
        long l = object.inputCounter;
        object.inputCounter = l + 1L;
        this.receiveMac.update(header);
        this.receiveMac.update(content, 0, macOffset);
        byte[] byArray = this.receiveMac.doFinal();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] expectedMac = byArray;
        byte[] actual = ArraysKt.sliceArray((byte[])content, (IntRange)RangesKt.until((int)macOffset, (int)(macOffset + this.suite.getMacStrengthInBytes())));
        if (!MessageDigest.isEqual(expectedMac, actual)) {
            throw new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    public static final /* synthetic */ Cipher access$getSendCipher$p(CBCCipher $this) {
        return $this.sendCipher;
    }
}

