/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.util.PoolsKt;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.pool.ByteBufferPool;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0019\b\u0002\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"CryptoBufferPool", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getCryptoBufferPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "cipherLoop", "Lio/ktor/utils/io/core/ByteReadPacket;", "cipher", "Ljavax/crypto/Cipher;", "header", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "ktor-network-tls"})
public final class CipherUtilsKt {
    @NotNull
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = (ObjectPool)new ByteBufferPool(128, 65536);

    @NotNull
    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket cipherLoop(@NotNull ByteReadPacket $this$cipherLoop, @NotNull Cipher cipher2, @NotNull Function1<? super BytePacketBuilder, Unit> header) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher2, (String)"cipher");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        ByteBuffer srcBuffer = (ByteBuffer)PoolsKt.getDefaultByteBufferPool().borrow();
        Object dstBuffer = null;
        dstBuffer = CryptoBufferPool.borrow();
        boolean dstBufferFromPool = false;
        dstBufferFromPool = true;
        try {
            ByteReadPacket byteReadPacket;
            int headerSizeHint$iv = 0;
            boolean $i$f$buildPacket = false;
            boolean bl = false;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                int rc;
                BytePacketBuilder $this$cipherLoop_u24lambda_u2d2 = builder$iv;
                boolean bl2 = false;
                srcBuffer.clear();
                header.invoke((Object)$this$cipherLoop_u24lambda_u2d2);
                while (true) {
                    rc = srcBuffer.hasRemaining() ? ByteBuffersKt.readAvailable((ByteReadPacket)$this$cipherLoop, (ByteBuffer)srcBuffer) : 0;
                    srcBuffer.flip();
                    if (!srcBuffer.hasRemaining()) {
                        if (rc == -1) break;
                        ByteReadPacket $this$isEmpty$iv = $this$cipherLoop;
                        boolean $i$f$isEmpty = false;
                        if ($this$isEmpty$iv.getEndOfInput()) break;
                    }
                    ((ByteBuffer)dstBuffer).clear();
                    if (cipher2.getOutputSize(srcBuffer.remaining()) > ((ByteBuffer)dstBuffer).remaining()) {
                        if (dstBufferFromPool) {
                            CipherUtilsKt.getCryptoBufferPool().recycle(dstBuffer);
                        }
                        ByteBuffer byteBuffer = ByteBuffer.allocate(cipher2.getOutputSize(srcBuffer.remaining()));
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(cipher.getOutputSize(srcBuffer.remaining()))");
                        dstBuffer = byteBuffer;
                        dstBufferFromPool = false;
                    }
                    cipher2.update(srcBuffer, (ByteBuffer)dstBuffer);
                    ((ByteBuffer)dstBuffer).flip();
                    OutputArraysJVMKt.writeFully((Output)((Output)$this$cipherLoop_u24lambda_u2d2), (ByteBuffer)((ByteBuffer)dstBuffer));
                    srcBuffer.compact();
                }
                rc = !srcBuffer.hasRemaining() ? 1 : 0;
                boolean bl3 = false;
                if (_Assertions.ENABLED && rc == 0) {
                    boolean $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = false;
                    String $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = "Cipher loop completed too early: there are unprocessed bytes";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CipherUtilsKt$cipherLoop$2$32));
                }
                rc = !((ByteBuffer)dstBuffer).hasRemaining() ? 1 : 0;
                bl3 = false;
                if (_Assertions.ENABLED && rc == 0) {
                    boolean bl4 = false;
                    String string = "Not all bytes were appended to the packet";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int requiredBufferSize = cipher2.getOutputSize(0);
                if (requiredBufferSize != 0) {
                    if (requiredBufferSize > ((ByteBuffer)dstBuffer).capacity()) {
                        Output output2 = (Output)$this$cipherLoop_u24lambda_u2d2;
                        byte[] byArray = cipher2.doFinal();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal()");
                        OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                    } else {
                        ((ByteBuffer)dstBuffer).clear();
                        cipher2.doFinal(CipherKt.getEmptyByteBuffer(), (ByteBuffer)dstBuffer);
                        ((ByteBuffer)dstBuffer).flip();
                        if (!((ByteBuffer)dstBuffer).hasRemaining()) {
                            Output output3 = (Output)$this$cipherLoop_u24lambda_u2d2;
                            byte[] byArray = cipher2.doFinal();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal()");
                            OutputKt.writeFully$default((Output)output3, (byte[])byArray, (int)0, (int)0, (int)6, null);
                        } else {
                            OutputArraysJVMKt.writeFully((Output)((Output)$this$cipherLoop_u24lambda_u2d2), (ByteBuffer)((ByteBuffer)dstBuffer));
                        }
                    }
                }
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            PoolsKt.getDefaultByteBufferPool().recycle((Object)srcBuffer);
            if (dstBufferFromPool) {
                CryptoBufferPool.recycle(dstBuffer);
            }
        }
    }

    public static /* synthetic */ ByteReadPacket cipherLoop$default(ByteReadPacket byteReadPacket, Cipher cipher2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = cipherLoop.1.INSTANCE;
        }
        return CipherUtilsKt.cipherLoop(byteReadPacket, cipher2, (Function1<? super BytePacketBuilder, Unit>)function1);
    }
}

