/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.resources.serialization;

import io.ktor.http.Parameters;
import io.ktor.resources.ResourceSerializationException;
import io.ktor.resources.serialization.ListLikeDecoder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b,\u0010\u0015J\u0011\u0010.\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\r2\u0006\u00100\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b1\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00102\u001a\u0004\b3\u00104R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00105R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u0007068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u00078\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lio/ktor/resources/serialization/ParametersDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lio/ktor/http/Parameters;", "parameters", "", "", "elementNames", "<init>", "(Lkotlinx/serialization/modules/SerializersModule;Lio/ktor/http/Parameters;Ljava/lang/Iterable;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "decodeBoolean", "()Z", "", "decodeByte", "()B", "", "decodeChar", "()C", "", "decodeDouble", "()D", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "", "decodeShort", "()S", "decodeString", "()Ljava/lang/String;", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "Lio/ktor/http/Parameters;", "", "parameterNames", "Ljava/util/Iterator;", "currentName", "Ljava/lang/String;", "ktor-resources"})
public final class ParametersDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final Iterator<String> parameterNames;
    private String currentName;

    public ParametersDecoder(@NotNull SerializersModule serializersModule, @NotNull Parameters parameters, @NotNull Iterable<String> elementNames) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(elementNames, (String)"elementNames");
        this.serializersModule = serializersModule;
        this.parameters = parameters;
        this.parameterNames = elementNames.iterator();
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.parameterNames.hasNext()) {
            return -1;
        }
        while (this.parameterNames.hasNext()) {
            this.currentName = this.parameterNames.next();
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                string = null;
            }
            int elementIndex = descriptor.getElementIndex(string);
            SerialKind elementDescriptorKind = descriptor.getElementDescriptor(elementIndex).getKind();
            boolean isPrimitive = elementDescriptorKind instanceof PrimitiveKind;
            boolean isEnum = elementDescriptorKind instanceof SerialKind.ENUM;
            if (isPrimitive || isEnum) {
                String string2 = this.currentName;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                    string2 = null;
                }
                if (!this.parameters.contains(string2)) continue;
            }
            return elementIndex;
        }
        return -1;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE)) {
            SerializersModule serializersModule = this.getSerializersModule();
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                string = null;
            }
            return (CompositeDecoder)new ListLikeDecoder(serializersModule, this.parameters, string);
        }
        return (CompositeDecoder)new ParametersDecoder(this.getSerializersModule(), this.parameters, SerialDescriptorKt.getElementNames((SerialDescriptor)descriptor));
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public char decodeChar() {
        return this.decodeString().charAt(0);
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeString());
    }

    public int decodeInt() {
        return Integer.parseInt(this.decodeString());
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    @NotNull
    public String decodeString() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    public boolean decodeNotNullMark() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
            string = null;
        }
        return this.parameters.contains(string);
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new ResourceSerializationException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

