/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.contentnegotiation;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.plugins.contentnegotiation.ContentTypeWithQuality;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\t\u001a\u00020\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/application/ApplicationCall;", "", "Lio/ktor/server/plugins/contentnegotiation/ContentTypeWithQuality;", "parseAcceptHeader", "(Lio/ktor/server/application/ApplicationCall;)Ljava/util/List;", "acceptItems", "Lio/ktor/http/ContentType;", "contentType", "", "checkAcceptHeader", "(Ljava/util/List;Lio/ktor/http/ContentType;)Z", "ktor-server-content-negotiation"})
@SourceDebugExtension(value={"SMAP\nContentNegotiationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1563#2:38\n1634#2,3:39\n1761#2,3:42\n*S KotlinDebug\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n*L\n24#1:38\n24#1:39,3\n35#1:42,3\n*E\n"})
public final class ContentNegotiationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentTypeWithQuality> parseAcceptHeader(@NotNull ApplicationCall $this$parseAcceptHeader) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$parseAcceptHeader, (String)"<this>");
        String acceptHeaderContent = ApplicationRequestPropertiesKt.header((ApplicationRequest)$this$parseAcceptHeader.getRequest(), (String)HttpHeaders.INSTANCE.getAccept());
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = HttpHeaderValueParserKt.parseHeaderValue((String)acceptHeaderContent);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HeaderValue headerValue = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ContentTypeWithQuality(ContentType.Companion.parse(it.getValue()), it.getQuality()));
            }
            list = (List)destination$iv$iv;
        }
        catch (BadContentTypeFormatException parseFailure) {
            throw new BadRequestException("Illegal Accept header format: " + acceptHeaderContent, (Throwable)parseFailure);
        }
        return list;
    }

    public static final boolean checkAcceptHeader(@NotNull List<ContentTypeWithQuality> acceptItems, @Nullable ContentType contentType) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(acceptItems, (String)"acceptItems");
            if (acceptItems.isEmpty() || contentType == null) {
                return true;
            }
            Iterable $this$any$iv = acceptItems;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ContentTypeWithQuality it = (ContentTypeWithQuality)element$iv;
                    boolean bl2 = false;
                    if (!contentType.match(it.getContentType())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

