/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationResponse;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0015\b&\u0018\u0000 J2\u00020\u0001:\u0001JB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0094@\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u0094@\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0017H\u0094@\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH$\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u001e\u0010!J\u0011\u0010$\u001a\u0004\u0018\u00010\u001dH\u0010\u00a2\u0006\u0004\b\"\u0010#J!\u0010(\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020%H\u0000\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010-\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b,\u0010*J\r\u0010.\u001a\u00020\r\u00a2\u0006\u0004\b.\u0010*R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010/\u001a\u0004\b0\u00101R\u001a\u0010\u0007\u001a\u00020\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00102\u001a\u0004\b3\u00104R\u001a\u0010\b\u001a\u00020\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\b\u00102\u001a\u0004\b5\u00104R\u001a\u00107\u001a\u0002068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001e\u0010;\u001a\u0004\b<\u0010#\"\u0004\b=\u0010>R\"\u0010?\u001a\u00020\u001a8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\"\u0010\u0015\u001a\u00020%8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010I\u00a8\u0006K"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse;", "Lio/ktor/server/engine/BaseApplicationResponse;", "Lio/ktor/server/netty/NettyApplicationCall;", "call", "Lio/netty/channel/ChannelHandlerContext;", "context", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "<init>", "(Lio/ktor/server/netty/NettyApplicationCall;Lio/netty/channel/ChannelHandlerContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "Lio/ktor/http/content/OutgoingContent;", "content", "", "respondOutgoingContent", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "bytes", "respondFromBytes", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/utils/io/ByteWriteChannel;", "responseChannel", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/http/content/OutgoingContent$NoContent;", "respondNoContent", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "chunked", "last", "", "responseMessage", "(ZZ)Ljava/lang/Object;", "data", "(Z[B)Ljava/lang/Object;", "prepareTrailerMessage$ktor_server_netty", "()Ljava/lang/Object;", "prepareTrailerMessage", "Lio/ktor/utils/io/ByteReadChannel;", "sendResponse$ktor_server_netty", "(ZLio/ktor/utils/io/ByteReadChannel;)V", "sendResponse", "ensureResponseSent$ktor_server_netty", "()V", "ensureResponseSent", "close$ktor_server_netty", "close", "cancel", "Lio/netty/channel/ChannelHandlerContext;", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "Lkotlin/coroutines/CoroutineContext;", "getEngineContext", "()Lkotlin/coroutines/CoroutineContext;", "getUserContext", "Lio/netty/channel/ChannelPromise;", "responseReady", "Lio/netty/channel/ChannelPromise;", "getResponseReady$ktor_server_netty", "()Lio/netty/channel/ChannelPromise;", "Ljava/lang/Object;", "getResponseMessage", "setResponseMessage", "(Ljava/lang/Object;)V", "responseMessageSent", "Z", "getResponseMessageSent", "()Z", "setResponseMessageSent", "(Z)V", "Lio/ktor/utils/io/ByteReadChannel;", "getResponseChannel$ktor_server_netty", "()Lio/ktor/utils/io/ByteReadChannel;", "setResponseChannel$ktor_server_netty", "(Lio/ktor/utils/io/ByteReadChannel;)V", "Companion", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyApplicationResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyApplicationResponse.kt\nio/ktor/server/netty/NettyApplicationResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1202#2,2:142\n1230#2,4:144\n*S KotlinDebug\n*F\n+ 1 NettyApplicationResponse.kt\nio/ktor/server/netty/NettyApplicationResponse\n*L\n134#1:142,2\n134#1:144,4\n*E\n"})
public abstract class NettyApplicationResponse
extends BaseApplicationResponse {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final ChannelPromise responseReady;
    public Object responseMessage;
    private volatile boolean responseMessageSent;
    @NotNull
    private ByteReadChannel responseChannel;
    @NotNull
    private static final byte[] EmptyByteArray;
    @NotNull
    private static final HttpResponseStatus[] responseStatusCache;

    public NettyApplicationResponse(@NotNull NettyApplicationCall call, @NotNull ChannelHandlerContext context, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)call), (String)"call");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        super((PipelineCall)call);
        this.context = context;
        this.engineContext = engineContext;
        this.userContext = userContext;
        ChannelPromise channelPromise = this.context.newPromise();
        Intrinsics.checkNotNullExpressionValue((Object)channelPromise, (String)"newPromise(...)");
        this.responseReady = channelPromise;
        this.responseChannel = ByteReadChannel.Companion.getEmpty();
    }

    @NotNull
    protected final ChannelHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final CoroutineContext getEngineContext() {
        return this.engineContext;
    }

    @NotNull
    protected final CoroutineContext getUserContext() {
        return this.userContext;
    }

    @NotNull
    public final ChannelPromise getResponseReady$ktor_server_netty() {
        return this.responseReady;
    }

    @NotNull
    public final Object getResponseMessage() {
        Object object = this.responseMessage;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"responseMessage");
        return Unit.INSTANCE;
    }

    public final void setResponseMessage(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.responseMessage = object;
    }

    protected final boolean getResponseMessageSent() {
        return this.responseMessageSent;
    }

    protected final void setResponseMessageSent(boolean bl) {
        this.responseMessageSent = bl;
    }

    @NotNull
    public final ByteReadChannel getResponseChannel$ktor_server_netty() {
        return this.responseChannel;
    }

    public final void setResponseChannel$ktor_server_netty(@NotNull ByteReadChannel byteReadChannel) {
        Intrinsics.checkNotNullParameter((Object)byteReadChannel, (String)"<set-?>");
        this.responseChannel = byteReadChannel;
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent content, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this, content, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondOutgoingContent$suspendImpl(NettyApplicationResponse var0, OutgoingContent var1_1, Continuation<? super Unit> $completion) {
        block18: {
            block17: {
                if (!($completion instanceof respondOutgoingContent.1)) ** GOTO lbl-1000
                var7_3 = $completion;
                if ((var7_3.label & -2147483648) != 0) {
                    var7_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, $completion){
                        Object L$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ NettyApplicationResponse this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = $this;
                        $continuation.label = 1;
                        v0 = super.respondOutgoingContent((OutgoingContent)content, (Continuation)$continuation);
                        ** if (v0 != var8_5) goto lbl19
lbl18:
                        // 1 sources

                        return var8_5;
lbl19:
                        // 1 sources

                        ** GOTO lbl26
                    }
                    case 1: {
                        $this = (NettyApplicationResponse)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        v1 = out = (var4_6 = $this.responseChannel) instanceof ByteWriteChannel != false ? (ByteWriteChannel)var4_6 : null;
                        if (v1 == null) break;
                        $continuation.L$0 = null;
                        $continuation.label = 2;
                        v2 = v1.flushAndClose((Continuation)$continuation);
                        if (v2 == var8_5) {
                            return var8_5;
                        }
                        break block18;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break block18;
                    }
                }
                break block18;
                catch (Throwable t) {
                    try {
                        var5_13 = $this.responseChannel;
                        v3 = out = var5_13 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_13 : null;
                        if (v3 != null) {
                            ByteWriteChannelOperationsKt.close((ByteWriteChannel)v3, (Throwable)t);
                        }
                        throw t;
                    }
                    catch (Throwable var3_11) {
                        var5_14 = $this.responseChannel;
                        v4 = out = var5_14 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_14 : null;
                        if (v4 == null) break block17;
                        $continuation.L$0 = var3_11;
                        $continuation.label = 3;
                        v5 = v4.flushAndClose((Continuation)$continuation);
                        if (v5 == var8_5) {
                            return var8_5;
                        }
                        break block17;
                    }
                }
                {
                    case 3: {
                        var3_12 = (Throwable)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        break;
                    }
                }
            }
            throw var3_12;
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondFromBytes$suspendImpl(this, bytes, $completion);
    }

    static /* synthetic */ Object respondFromBytes$suspendImpl(NettyApplicationResponse $this, byte[] bytes, Continuation<? super Unit> $completion) {
        boolean chunked = Intrinsics.areEqual((Object)$this.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), (Object)"chunked");
        if ($this.responseMessageSent) {
            return Unit.INSTANCE;
        }
        Object message = $this.responseMessage(chunked, bytes);
        $this.responseChannel = message instanceof LastHttpContent ? ByteReadChannel.Companion.getEmpty() : ByteChannelCtorKt.ByteReadChannel$default((byte[])bytes, (int)0, (int)0, (int)6, null);
        $this.setResponseMessage(message);
        $this.responseReady.setSuccess();
        $this.responseMessageSent = true;
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> $completion) {
        return NettyApplicationResponse.responseChannel$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object responseChannel$suspendImpl(NettyApplicationResponse $this, Continuation<? super ByteWriteChannel> $completion) {
        ByteChannel channel = new ByteChannel(false, 1, null);
        boolean chunked = Intrinsics.areEqual((Object)$this.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), (Object)"chunked");
        $this.sendResponse$ktor_server_netty(chunked, (ByteReadChannel)channel);
        return channel;
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent content, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondNoContent$suspendImpl(this, content, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(NettyApplicationResponse $this, OutgoingContent.NoContent content, Continuation<? super Unit> $completion) {
        Object object = $this.respondFromBytes(EmptyByteArray, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected abstract Object responseMessage(boolean var1, boolean var2);

    @NotNull
    protected Object responseMessage(boolean chunked, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.responseMessage(chunked, true);
    }

    @Nullable
    public Object prepareTrailerMessage$ktor_server_netty() {
        return null;
    }

    public final void sendResponse$ktor_server_netty(boolean chunked, @NotNull ByteReadChannel content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.responseMessageSent) {
            return;
        }
        this.responseChannel = content;
        this.setResponseMessage(content.isClosedForRead() ? this.responseMessage(false, EmptyByteArray) : this.responseMessage(chunked, false));
        this.responseReady.setSuccess();
        this.responseMessageSent = true;
    }

    public static /* synthetic */ void sendResponse$ktor_server_netty$default(NettyApplicationResponse nettyApplicationResponse, boolean bl, ByteReadChannel byteReadChannel, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendResponse");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        nettyApplicationResponse.sendResponse$ktor_server_netty(bl, byteReadChannel);
    }

    public final void ensureResponseSent$ktor_server_netty() {
        NettyApplicationResponse.sendResponse$ktor_server_netty$default(this, false, ByteReadChannel.Companion.getEmpty(), 1, null);
    }

    public final void close$ktor_server_netty() {
        ByteReadChannel existingChannel = this.responseChannel;
        if (existingChannel instanceof ByteWriteChannel) {
            ByteWriteChannelOperationsKt.close((ByteWriteChannel)((ByteWriteChannel)existingChannel), null);
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
        }
        this.ensureResponseSent$ktor_server_netty();
    }

    public final void cancel() {
        if (!this.responseMessageSent) {
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
            this.responseReady.setFailure((Throwable)new CancellationException("Response was cancelled"));
            this.responseMessageSent = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        EmptyByteArray = new byte[0];
        Iterable $this$associateBy$iv = HttpStatusCode.Companion.getAllStatusCodes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HttpStatusCode httpStatusCode = (HttpStatusCode)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getValue(), element$iv$iv);
        }
        Map codes = destination$iv$iv;
        boolean bl = false;
        HttpResponseStatus[] httpResponseStatusArray = new HttpResponseStatus[1000];
        for (int i = 0; i < 1000; ++i) {
            HttpResponseStatus httpResponseStatus;
            int n = i;
            if (codes.keySet().contains(n)) {
                Object v = codes.get(n);
                Intrinsics.checkNotNull(v);
                httpResponseStatus = new HttpResponseStatus(n, ((HttpStatusCode)v).getDescription());
            } else {
                httpResponseStatus = null;
            }
            httpResponseStatusArray[n] = httpResponseStatus;
        }
        responseStatusCache = httpResponseStatusArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse$Companion;", "", "<init>", "()V", "", "EmptyByteArray", "[B", "", "Lio/netty/handler/codec/http/HttpResponseStatus;", "responseStatusCache", "[Lio/netty/handler/codec/http/HttpResponseStatus;", "getResponseStatusCache", "()[Lio/netty/handler/codec/http/HttpResponseStatus;", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponseStatus[] getResponseStatusCache() {
            return responseStatusCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

