/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.netty.NettyApplicationEngineKt;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.util.DispatcherWithShutdown;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00019B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\b\u00107\u001a\u000208H\u0016R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001c\u0010\u0014R\u001b\u0010\u001e\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0010\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0010\u001a\u0004\b$\u0010%R\u001b\u0010'\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b(\u0010%R\u001b\u0010*\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0010\u001a\u0004\b+\u0010\u0014\u00a8\u0006:"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "bootstraps", "", "Lio/netty/bootstrap/ServerBootstrap;", "getBootstraps", "()Ljava/util/List;", "bootstraps$delegate", "Lkotlin/Lazy;", "callEventGroup", "Lio/netty/channel/EventLoopGroup;", "getCallEventGroup", "()Lio/netty/channel/EventLoopGroup;", "callEventGroup$delegate", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "channels", "Lio/netty/channel/Channel;", "configuration", "connectionEventGroup", "getConnectionEventGroup", "connectionEventGroup$delegate", "customBootstrap", "getCustomBootstrap", "()Lio/netty/bootstrap/ServerBootstrap;", "customBootstrap$delegate", "dispatcherWithShutdown", "Lio/ktor/util/DispatcherWithShutdown;", "getDispatcherWithShutdown", "()Lio/ktor/util/DispatcherWithShutdown;", "dispatcherWithShutdown$delegate", "engineDispatcherWithShutdown", "getEngineDispatcherWithShutdown", "engineDispatcherWithShutdown$delegate", "workerEventGroup", "getWorkerEventGroup", "workerEventGroup$delegate", "createBootstrap", "connector", "Lio/ktor/server/engine/EngineConnectorConfig;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "toString", "", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    private final Configuration configuration;
    private final Lazy connectionEventGroup$delegate;
    private final Lazy workerEventGroup$delegate;
    private final Lazy customBootstrap$delegate;
    private final Lazy callEventGroup$delegate;
    private final Lazy dispatcherWithShutdown$delegate;
    private final Lazy engineDispatcherWithShutdown$delegate;
    private CompletableJob cancellationDeferred;
    private List<? extends Channel> channels;
    private final Lazy bootstraps$delegate;

    private final EventLoopGroup getConnectionEventGroup() {
        Lazy lazy = this.connectionEventGroup$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventLoopGroup)lazy.getValue();
    }

    private final EventLoopGroup getWorkerEventGroup() {
        Lazy lazy = this.workerEventGroup$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ServerBootstrap getCustomBootstrap() {
        Lazy lazy = this.customBootstrap$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ServerBootstrap)lazy.getValue();
    }

    private final EventLoopGroup getCallEventGroup() {
        Lazy lazy = this.callEventGroup$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventLoopGroup)lazy.getValue();
    }

    private final DispatcherWithShutdown getDispatcherWithShutdown() {
        Lazy lazy = this.dispatcherWithShutdown$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DispatcherWithShutdown)lazy.getValue();
    }

    private final DispatcherWithShutdown getEngineDispatcherWithShutdown() {
        Lazy lazy = this.engineDispatcherWithShutdown$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DispatcherWithShutdown)lazy.getValue();
    }

    private final List<ServerBootstrap> getBootstraps() {
        Lazy lazy = this.bootstraps$delegate;
        NettyApplicationEngine nettyApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private final ServerBootstrap createBootstrap(EngineConnectorConfig connector) {
        ServerBootstrap serverBootstrap = this.getCustomBootstrap().clone();
        boolean bl = false;
        boolean bl2 = false;
        ServerBootstrap $this$apply = serverBootstrap;
        boolean bl3 = false;
        if ($this$apply.config().group() == null && $this$apply.config().childGroup() == null) {
            $this$apply.group(this.getConnectionEventGroup(), this.getWorkerEventGroup());
        }
        if ($this$apply.config().channelFactory() == null) {
            $this$apply.channel(JvmClassMappingKt.getJavaClass((KClass)NettyApplicationEngineKt.access$getChannelClass()));
        }
        $this$apply.childHandler((ChannelHandler)new NettyChannelInitializer(this.getPipeline(), this.getEnvironment(), (EventExecutorGroup)this.getCallEventGroup(), (CoroutineContext)this.getEngineDispatcherWithShutdown(), this.getEnvironment().getParentCoroutineContext().plus((CoroutineContext)this.getDispatcherWithShutdown()), connector, this.configuration.getRequestQueueLimit(), this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec()));
        if (this.configuration.getTcpKeepAlive()) {
            $this$apply.option(NioChannelOption.SO_KEEPALIVE, (Object)true);
        }
        ServerBootstrap serverBootstrap2 = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue((Object)serverBootstrap2, (String)"customBootstrap.clone().\u2026)\n            }\n        }");
        return serverBootstrap2;
    }

    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        ChannelFuture channelFuture;
        ChannelFuture it;
        Collection<ChannelFuture> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.getEnvironment().start();
        Iterable iterable = CollectionsKt.zip((Iterable)this.getBootstraps(), (Iterable)this.getEnvironment().getConnectors());
        Object object = this;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = ((ServerBootstrap)it.getFirst()).bind(((EngineConnectorConfig)it.getSecond()).getHost(), ((EngineConnectorConfig)it.getSecond()).getPort());
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChannelFuture)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = it.sync().channel();
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        ((NettyApplicationEngine)((Object)object)).channels = collection;
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Channel)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    collection = it.closeFuture();
                    object.add(collection);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ChannelFuture it2 = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it2.sync();
                }
            }
            ApplicationEngineJvmKt.stop((ApplicationEngine)this, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        List list;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        List<? extends Channel> list2 = this.channels;
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = list2;
            $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChannelFuture channelFuture;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if ((it.isOpen() ? it.close() : null) == null) continue;
                channelFuture = channelFuture;
                boolean bl3 = false;
                boolean bl4 = false;
                ChannelFuture it$iv$iv = channelFuture;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        $this$mapNotNull$iv = list;
        $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        Iterable channelFutures = iterable;
        this.getDispatcherWithShutdown().prepareShutdown();
        this.getEngineDispatcherWithShutdown().prepareShutdown();
        try {
            Future shutdownConnections = this.getConnectionEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            shutdownConnections.await();
            Future shutdownWorkers = this.getWorkerEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                shutdownWorkers.await();
            } else {
                Future shutdownCall = this.getCallEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
                shutdownWorkers.await();
                shutdownCall.await();
            }
            this.getEnvironment().stop();
        }
        finally {
            this.getDispatcherWithShutdown().completeShutdown();
            this.getEngineDispatcherWithShutdown().completeShutdown();
            Iterable $this$forEach$iv = channelFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    public NettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration = new Configuration();
        boolean bl = false;
        boolean bl2 = false;
        configure.invoke((Object)configuration);
        this.configuration = configuration;
        this.connectionEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap$p(this.this$0).config().group();
                if (eventLoopGroup == null) {
                    eventLoopGroup = EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConnectionGroupSize());
                }
                return eventLoopGroup;
            }
            {
                this.this$0 = nettyApplicationEngine;
                super(0);
            }
        }));
        this.workerEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroupProxy defaultGroup = NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize() + NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize()) : EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize());
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap$p(this.this$0).config().childGroup();
                if (eventLoopGroup == null) {
                    eventLoopGroup = defaultGroup;
                }
                return eventLoopGroup;
            }
            {
                this.this$0 = nettyApplicationEngine;
                super(0);
            }
        }));
        this.customBootstrap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServerBootstrap>(this){
            final /* synthetic */ NettyApplicationEngine this$0;

            @NotNull
            public final ServerBootstrap invoke() {
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                Function1<ServerBootstrap, Unit> function1 = NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConfigureBootstrap();
                boolean bl = false;
                boolean bl2 = false;
                function1.invoke((Object)serverBootstrap);
                return serverBootstrap;
            }
            {
                this.this$0 = nettyApplicationEngine;
                super(0);
            }
        }));
        this.callEventGroup$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;

            @NotNull
            public final EventLoopGroup invoke() {
                return NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? NettyApplicationEngine.access$getWorkerEventGroup$p(this.this$0) : (EventLoopGroup)EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize());
            }
            {
                this.this$0 = nettyApplicationEngine;
                super(0);
            }
        }));
        this.dispatcherWithShutdown$delegate = LazyKt.lazy((Function0)dispatcherWithShutdown.2.INSTANCE);
        this.engineDispatcherWithShutdown$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DispatcherWithShutdown>(this){
            final /* synthetic */ NettyApplicationEngine this$0;

            @NotNull
            public final DispatcherWithShutdown invoke() {
                return new DispatcherWithShutdown((CoroutineDispatcher)ExecutorsKt.from((ExecutorService)((ExecutorService)NettyApplicationEngine.access$getWorkerEventGroup$p(this.this$0))));
            }
            {
                this.this$0 = nettyApplicationEngine;
                super(0);
            }
        }));
        this.bootstraps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ServerBootstrap>>(this, environment){
            final /* synthetic */ NettyApplicationEngine this$0;
            final /* synthetic */ ApplicationEngineEnvironment $environment;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ServerBootstrap> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$environment.getConnectors();
                NettyApplicationEngine nettyApplicationEngine = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ServerBootstrap serverBootstrap = NettyApplicationEngine.access$createBootstrap(nettyApplicationEngine, (EngineConnectorConfig)p1);
                    collection.add(serverBootstrap);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = nettyApplicationEngine;
                this.$environment = applicationEngineEnvironment;
                super(0);
            }
        }));
        PipelinePhase afterCall = new PipelinePhase("After");
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), afterCall);
        this.getPipeline().intercept(afterCall, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            private /* synthetic */ Object L$0;
            int label;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PipelineContext $this$intercept;
                        ResultKt.throwOnFailure((Object)object);
                        PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                        boolean $i$f$getCall = false;
                        ApplicationCall applicationCall = (ApplicationCall)$this$call$iv.getContext();
                        if (!(applicationCall instanceof NettyApplicationCall)) {
                            applicationCall = null;
                        }
                        NettyApplicationCall nettyApplicationCall = (NettyApplicationCall)applicationCall;
                        if (nettyApplicationCall == null) break;
                        NettyApplicationCall nettyApplicationCall2 = nettyApplicationCall;
                        this.label = 1;
                        Object object3 = nettyApplicationCall2.finish$ktor_server_netty((Continuation<? super Unit>)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<Unit, ApplicationCall> $this$create, @NotNull Unit it, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                PipelineContext<Unit, ApplicationCall> pipelineContext = function3.L$0 = $this$create;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((PipelineContext<Unit, ApplicationCall>)((PipelineContext)object), (Unit)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ NettyApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(applicationEngineEnvironment, (Function1<? super Configuration, Unit>)function1);
    }

    public static final /* synthetic */ ServerBootstrap access$getCustomBootstrap$p(NettyApplicationEngine $this) {
        return $this.getCustomBootstrap();
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(NettyApplicationEngine $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ EventLoopGroup access$getWorkerEventGroup$p(NettyApplicationEngine $this) {
        return $this.getWorkerEventGroup();
    }

    public static final /* synthetic */ ServerBootstrap access$createBootstrap(NettyApplicationEngine $this, EngineConnectorConfig connector) {
        return $this.createBootstrap(connector);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'\u00a8\u0006+"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureBootstrap", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "requestQueueLimit", "", "getRequestQueueLimit", "()I", "setRequestQueueLimit", "(I)V", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "runningLimit", "getRunningLimit", "setRunningLimit", "shareWorkGroup", "", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "tcpKeepAlive", "getTcpKeepAlive", "setTcpKeepAlive", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int requestQueueLimit = 16;
        private int runningLimit = 10;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = configureBootstrap.1.INSTANCE;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        private boolean tcpKeepAlive;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = httpServerCodec.1.INSTANCE;

        public final int getRequestQueueLimit() {
            return this.requestQueueLimit;
        }

        public final void setRequestQueueLimit(int n) {
            this.requestQueueLimit = n;
        }

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n) {
            this.requestReadTimeoutSeconds = n;
        }

        public final boolean getTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public final void setTcpKeepAlive(boolean bl) {
            this.tcpKeepAlive = bl;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
            this.httpServerCodec = function0;
        }
    }
}

