/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.eks;

import io.kubernetes.client.util.eks.AWS4SignerBase;
import io.kubernetes.client.util.eks.BinaryUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWS4STSSigner
extends AWS4SignerBase {
    private static final Logger log = LoggerFactory.getLogger(AWS4STSSigner.class);

    public AWS4STSSigner(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
    }

    public String computeSignature(URI endpoint, Map<String, String> headers, Map<String, String> queryParameters, int expiringInSeconds, String bodyHash, String awsAccessKey, String awsSecretKey, String sessionToken) throws URISyntaxException {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWS4STSSigner.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4STSSigner.getCanonicalizedHeaderString(headers);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        queryParameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        queryParameters.put("X-Amz-Credential", awsAccessKey + "/" + scope);
        queryParameters.put("X-Amz-Date", dateTimeStamp);
        queryParameters.put("X-Amz-Expires", String.valueOf(expiringInSeconds));
        queryParameters.put("X-Amz-Security-Token", sessionToken);
        queryParameters.put("X-Amz-SignedHeaders", canonicalizedHeaderNames);
        String canonicalizedQueryParameters = AWS4STSSigner.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4STSSigner.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        log.debug("--------- Canonical request --------");
        log.debug(canonicalRequest);
        log.debug("------------------------------------");
        String stringToSign = AWS4STSSigner.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        log.debug("--------- String to sign -----------");
        log.debug(stringToSign);
        log.debug("------------------------------------");
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes();
        byte[] kDate = AWS4STSSigner.sign(dateStamp, kSecret, "HmacSHA256");
        byte[] kRegion = AWS4STSSigner.sign(this.regionName, kDate, "HmacSHA256");
        byte[] kService = AWS4STSSigner.sign(this.serviceName, kRegion, "HmacSHA256");
        byte[] kSigning = AWS4STSSigner.sign("aws4_request", kService, "HmacSHA256");
        byte[] signature = AWS4STSSigner.sign(stringToSign, kSigning, "HmacSHA256");
        StringBuilder authString = new StringBuilder();
        URIBuilder builder = new URIBuilder(endpoint);
        queryParameters.forEach((k, v) -> builder.addParameter(k, v));
        builder.addParameter("X-Amz-Signature", BinaryUtils.toHex(signature));
        authString.append(builder.build());
        return authString.toString();
    }
}

