/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DynamicKubernetesListObject
implements KubernetesListObject {
    private final JsonObject raw;

    public DynamicKubernetesListObject() {
        this(new JsonObject());
    }

    public DynamicKubernetesListObject(JsonObject obj) {
        this.raw = obj;
    }

    public V1ListMeta getMetadata() {
        Configuration.getDefaultApiClient().getJSON();
        return (V1ListMeta)JSON.getGson().fromJson(this.raw.get("metadata"), V1ListMeta.class);
    }

    public String getApiVersion() {
        return this.raw.get("apiVersion").getAsString();
    }

    public String getKind() {
        return this.raw.get("kind").getAsString();
    }

    public List<DynamicKubernetesObject> getItems() {
        ArrayList<DynamicKubernetesObject> list = new ArrayList<DynamicKubernetesObject>();
        for (JsonElement e : this.raw.get("items").getAsJsonArray()) {
            list.add(new DynamicKubernetesObject(e.getAsJsonObject()));
        }
        return list;
    }

    public JsonObject getRaw() {
        return this.raw;
    }

    public void setApiVersion(String apiVersion) {
        this.raw.addProperty("apiVersion", apiVersion);
    }

    public void setKind(String kind) {
        this.raw.addProperty("kind", kind);
    }

    public void setMetadata(V1ListMeta objectMeta) {
        Configuration.getDefaultApiClient().getJSON();
        this.raw.add("metadata", JSON.getGson().toJsonTree((Object)objectMeta));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicKubernetesListObject that = (DynamicKubernetesListObject)o;
        return Objects.equals(this.raw, that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }
}

