/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic.dynamic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesListObject;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesObject;
import io.kubernetes.client.util.generic.dynamic.LegacyJSON;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Dynamics {
    static final LegacyJSON internalJSONCodec = new LegacyJSON();
    static final Yaml internalYamlCodec = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));

    public static DynamicKubernetesObject newFromJson(String jsonContent) {
        return Dynamics.newFromJson(internalJSONCodec.getGson(), jsonContent);
    }

    public static DynamicKubernetesObject newFromJson(Gson gson, String jsonContent) {
        JsonElement raw = (JsonElement)gson.fromJson(jsonContent, JsonElement.class);
        return new DynamicKubernetesObject(raw.getAsJsonObject());
    }

    public static DynamicKubernetesListObject newListFromJson(String jsonContent) {
        return Dynamics.newListFromJson(internalJSONCodec.getGson(), jsonContent);
    }

    public static DynamicKubernetesListObject newListFromJson(Gson gson, String jsonContent) {
        JsonElement raw = (JsonElement)gson.fromJson(jsonContent, JsonElement.class);
        return new DynamicKubernetesListObject(raw.getAsJsonObject());
    }

    public static DynamicKubernetesObject newFromYaml(String yamlContent) {
        return Dynamics.newFromYaml(internalYamlCodec, yamlContent);
    }

    public static DynamicKubernetesObject newFromYaml(Yaml yamlCodec, String yamlContent) {
        return Dynamics.newFromJson(internalJSONCodec.getGson(), Dynamics.fromYamlToJson(yamlCodec, internalJSONCodec.getGson(), yamlContent));
    }

    public static String fromYamlToJson(String yamlContent) {
        return Dynamics.fromYamlToJson(internalYamlCodec, internalJSONCodec.getGson(), yamlContent);
    }

    public static String fromJsonToYaml(String jsonContent) {
        return Dynamics.fromJsonToYaml(internalYamlCodec, internalJSONCodec.getGson(), jsonContent);
    }

    public static String fromYamlToJson(Yaml yamlCodec, Gson gson, String yamlContent) {
        Map rawYamlObj = (Map)yamlCodec.load(yamlContent);
        return gson.toJson((Object)rawYamlObj);
    }

    public static String fromJsonToYaml(Yaml yamlCodec, Gson gson, String jsonContent) {
        Map rawJsonObj = (Map)gson.fromJson(jsonContent, Map.class);
        return yamlCodec.dump((Object)rawJsonObj);
    }
}

